/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.crusader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.indexing.DiscIndexer;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.crusader.CrusaderDemuxPiece;
import jpsxdec.modules.crusader.CrusaderPacketHeaderReader;
import jpsxdec.modules.crusader.CrusaderSectorToCrusaderPacket;
import jpsxdec.modules.crusader.DiscItemCrusader;
import jpsxdec.modules.crusader.SectorCrusader;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.framenumber.HeaderFrameNumber;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.util.DemuxedData;
import jpsxdec.util.Misc;

public class DiscIndexerCrusader
extends DiscIndexer
implements IdentifiedSectorListener<SectorCrusader> {
    private static final Logger LOG = Logger.getLogger(DiscIndexerCrusader.class.getName());
    private static final Dimensions MOST_COMMON = new Dimensions(240, 176);
    private static final Dimensions LESS_COMMON = new Dimensions(320, 240);
    private static final int MAX_WIDTH = 320;
    private static final int MAX_HEIGHT = 240;
    private static final double IDEAL_ASPECT_RATIO = 1.3636363636363635;
    @Nonnull
    private final ILocalizedLogger _errLog;
    @CheckForNull
    private VidBuilder _currentStream;

    static int compareAspectRatio(Dimensions candidateA, Dimensions candidateB) {
        double aspectRatioCandidateA = (double)candidateA.getWidth() / (double)candidateA.getHeight();
        double aspectRatioCandidateB = (double)candidateB.getWidth() / (double)candidateB.getHeight();
        double closenessScoreA = 1.0 - 1.3636363636363635 / aspectRatioCandidateA;
        double closenessScoreB = 1.0 - 1.3636363636363635 / aspectRatioCandidateB;
        if (Math.abs(closenessScoreA) <= Math.abs(closenessScoreB)) {
            return 1;
        }
        return -1;
    }

    public DiscIndexerCrusader(@Nonnull ILocalizedLogger errLog) {
        this._errLog = errLog;
    }

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        scs.addIdListener(this);
    }

    @Override
    @Nonnull
    public Class<SectorCrusader> getListeningFor() {
        return SectorCrusader.class;
    }

    @Override
    public void feedSector(@Nonnull SectorCrusader idSector, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        boolean blnAccepted;
        if (this._currentStream != null && !(blnAccepted = this._currentStream.feedSector(idSector))) {
            DiscItemCrusader vid = this._currentStream.endOfMovie(this.getCd());
            if (vid != null) {
                this.addDiscItem(vid);
            }
            this._currentStream = null;
        }
        if (this._currentStream == null) {
            this._currentStream = new VidBuilder(this._errLog, idSector);
        }
    }

    @Override
    public void endOfFeedSectors(@Nonnull ILocalizedLogger log) throws LoggedFailure {
        if (this._currentStream != null) {
            DiscItemCrusader vid = this._currentStream.endOfMovie(this.getCd());
            if (vid != null) {
                this.addDiscItem(vid);
            }
            this._currentStream = null;
        }
    }

    @Override
    @CheckForNull
    public DiscItem deserializeLineRead(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        if ("Crusader".equals(fields.getType())) {
            return new DiscItemCrusader(this.getCd(), fields);
        }
        return null;
    }

    @Override
    public void listPostProcessing(@Nonnull Collection<DiscItem> allItems) {
    }

    @Override
    public boolean filterChild(DiscItem parent, DiscItem child) {
        return false;
    }

    @Override
    public void indexGenerated(@Nonnull DiscIndex index) {
    }

    private static class VidBuilder
    implements CrusaderSectorToCrusaderPacket.PacketListener {
        @Nonnull
        private final ILocalizedLogger _errLog;
        @CheckForNull
        private IndexSectorFrameNumber.Format.Builder _indexSectorFrameNumberBuilder;
        @CheckForNull
        private HeaderFrameNumber.Format.Builder _headerFrameNumberBuilder;
        private int _iSoundUnitCount = 0;
        private final CrusaderSectorToCrusaderPacket _cs2cp = new CrusaderSectorToCrusaderPacket(this);
        private final TreeMap<Dimensions, DimCounter> _dimCounter = new TreeMap(new DimensionCmp());
        private final int _iStartSector;
        private int _iEndSector;
        private int _iInitialFramePresentationSector = -1;

        public VidBuilder(@Nonnull ILocalizedLogger errLog, @Nonnull SectorCrusader vidSect) throws LoggedFailure {
            this._errLog = errLog;
            this._iStartSector = this._iEndSector = vidSect.getSectorNumber();
            if (!this._cs2cp.sectorRead(vidSect, errLog)) {
                throw new RuntimeException("Sector should have been accepted " + vidSect);
            }
        }

        public boolean feedSector(@Nonnull SectorCrusader sector) throws LoggedFailure {
            if (!this._cs2cp.sectorRead(sector, this._errLog)) {
                return false;
            }
            this._iEndSector = sector.getSectorNumber();
            return true;
        }

        @Override
        public void frame(@Nonnull CrusaderPacketHeaderReader.VideoHeader frame, @Nonnull DemuxedData<CrusaderDemuxPiece> demux, @Nonnull ILocalizedLogger log) {
            if (this._iInitialFramePresentationSector < 0) {
                this._iInitialFramePresentationSector = frame.getFrameNumber() * 10;
                if (this._iInitialFramePresentationSector != 0) {
                    LOG.log(Level.WARNING, "[Video] Setting initial presentation sector {0,number,#}", this._iInitialFramePresentationSector);
                }
            }
            Dimensions dims = new Dimensions(frame.getWidth(), frame.getHeight());
            if (this._indexSectorFrameNumberBuilder == null) {
                this._indexSectorFrameNumberBuilder = new IndexSectorFrameNumber.Format.Builder(demux.getStartSector());
                this._headerFrameNumberBuilder = new HeaderFrameNumber.Format.Builder(frame.getFrameNumber());
                this._dimCounter.put(dims, new DimCounter(dims, 1));
            } else {
                DimCounter dimCounts = this._dimCounter.get(dims);
                if (dimCounts == null) {
                    LOG.log(Level.SEVERE, "Crusader inconsistent dimensions: {0}", dims);
                    dimCounts = new DimCounter(dims, 0);
                    this._dimCounter.put(dims, dimCounts);
                }
                ++dimCounts.iCount;
                this._indexSectorFrameNumberBuilder.addFrameStartSector(demux.getStartSector());
                this._headerFrameNumberBuilder.addHeaderFrameNumber(frame.getFrameNumber());
            }
        }

        @Override
        public void audio(@Nonnull CrusaderPacketHeaderReader.AudioHeader audio, @Nonnull DemuxedData<CrusaderDemuxPiece> demux, @Nonnull ILocalizedLogger log) {
            if (this._iInitialFramePresentationSector < 0) {
                this._iInitialFramePresentationSector = audio.getPresentationSampleFrame() / 147 - 60;
                if (this._iInitialFramePresentationSector < 0) {
                    this._iInitialFramePresentationSector = 0;
                } else if (this._iInitialFramePresentationSector > 0) {
                    LOG.log(Level.WARNING, "[Audio] Setting initial presentation sector {0,number,#}", this._iInitialFramePresentationSector);
                }
            }
            this._iSoundUnitCount += audio.getByteSize() / 2 / 16;
        }

        @CheckForNull
        public DiscItemCrusader endOfMovie(@Nonnull CdFileSectorReader cd) throws LoggedFailure {
            this._cs2cp.endVideo(this._errLog);
            if (this._indexSectorFrameNumberBuilder == null) {
                return null;
            }
            Set<Map.Entry<Dimensions, DimCounter>> y = this._dimCounter.entrySet();
            ArrayList<Map.Entry<Dimensions, DimCounter>> x = new ArrayList<Map.Entry<Dimensions, DimCounter>>(y);
            Collections.sort(x, new Comparator<Map.Entry<Dimensions, DimCounter>>(){

                @Override
                public int compare(Map.Entry<Dimensions, DimCounter> o1, Map.Entry<Dimensions, DimCounter> o2) {
                    return Misc.intCompare(o2.getValue().iCount, o1.getValue().iCount);
                }
            });
            DimCounter max = Collections.max(this._dimCounter.values());
            Dimensions dims = max.dims;
            if (this._dimCounter.size() > 1) {
                LOG.log(Level.INFO, "Choosing crusader dimensions {0}", dims);
            }
            return new DiscItemCrusader(cd, this._iStartSector, this._iEndSector, dims, this._indexSectorFrameNumberBuilder.makeFormat(), this._headerFrameNumberBuilder.makeFormat(), this._iInitialFramePresentationSector, this._iSoundUnitCount);
        }
    }

    static class DimCounter
    implements Comparable<DimCounter> {
        @Nonnull
        public final Dimensions dims;
        public int iCount = 0;

        public DimCounter(@Nonnull Dimensions dim, int iInitialCount) {
            this.dims = dim;
            this.iCount = iInitialCount;
        }

        @Override
        public int compareTo(DimCounter o) {
            int iCompare = Misc.intCompare(this.iCount, o.iCount);
            if (iCompare != 0) {
                return iCompare;
            }
            iCompare = Misc.intCompare(this.expectedDimRating(), o.expectedDimRating());
            if (iCompare != 0) {
                return iCompare;
            }
            iCompare = Misc.intCompare(this.tooLargeDimRating(), o.tooLargeDimRating());
            if (iCompare != 0) {
                return iCompare;
            }
            return DiscIndexerCrusader.compareAspectRatio(this.dims, o.dims);
        }

        private int expectedDimRating() {
            if (this.dims.equals(MOST_COMMON)) {
                return 2;
            }
            if (this.dims.equals(LESS_COMMON)) {
                return 1;
            }
            return 0;
        }

        private int tooLargeDimRating() {
            if (this.dims.getWidth() < 320 && this.dims.getHeight() < 240) {
                return 1;
            }
            return 0;
        }
    }

    static class DimensionCmp
    implements Comparator<Dimensions> {
        DimensionCmp() {
        }

        @Override
        public int compare(Dimensions o1, Dimensions o2) {
            int i = Misc.intCompare(o1.getWidth(), o2.getWidth());
            if (i != 0) {
                return i;
            }
            return Misc.intCompare(o1.getHeight(), o2.getHeight());
        }
    }
}

