/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.crusader;

import java.io.PrintStream;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.crusader.CrusaderDemuxPiece;
import jpsxdec.modules.crusader.SectorCrusader;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.DemuxedData;
import jpsxdec.util.Fraction;

public class DemuxedCrusaderFrame
implements IDemuxedFrame {
    private final int _iWidth;
    private final int _iHeight;
    private final int _iHeaderFrameNumber;
    @Nonnull
    private final DemuxedData<CrusaderDemuxPiece> _demux;
    @CheckForNull
    private FrameNumber _frameNumber;
    private final int _iPresentationSector;

    public DemuxedCrusaderFrame(int iWidth, int iHeight, int iHeaderFrameNumber, @Nonnull DemuxedData<CrusaderDemuxPiece> demux, int iPresentationSector) {
        this._iWidth = iWidth;
        this._iHeight = iHeight;
        this._iHeaderFrameNumber = iHeaderFrameNumber;
        this._demux = demux;
        this._iPresentationSector = iPresentationSector;
    }

    @Override
    @CheckForNull
    public MdecInputStream getCustomFrameMdecStream() {
        return null;
    }

    @Override
    @Nonnull
    public byte[] copyDemuxData() {
        return this._demux.copyDemuxData();
    }

    @Override
    public int getDemuxSize() {
        return this._demux.getDemuxSize();
    }

    @Override
    public int getStartSector() {
        return this._demux.getStartSector();
    }

    @Override
    public int getEndSector() {
        return this._demux.getEndSector();
    }

    @Override
    @Nonnull
    public FrameNumber getFrame() {
        if (this._frameNumber == null) {
            throw new IllegalStateException();
        }
        return this._frameNumber;
    }

    public void setFrame(@Nonnull FrameNumber fn) {
        this._frameNumber = fn;
    }

    public int getHeaderFrameNumber() {
        return this._iHeaderFrameNumber;
    }

    @Override
    public int getWidth() {
        return this._iWidth;
    }

    @Override
    public int getHeight() {
        return this._iHeight;
    }

    @Override
    @Nonnull
    public Fraction getPresentationSector() {
        return new Fraction(this._iPresentationSector);
    }

    @Override
    public void printSectors(@Nonnull PrintStream ps) {
        boolean blnFirstPiece = true;
        Iterator<CrusaderDemuxPiece> iterator = this._demux.iterator();
        while (iterator.hasNext()) {
            SectorCrusader vidSector = iterator.next().getSector();
            ps.print(vidSector);
            if (blnFirstPiece) {
                ps.print(" (start offset " + this._demux.getStartDataOffset() + ")");
            } else if (!iterator.hasNext()) {
                ps.print(" (end offset " + this._demux.getEndDataOffset() + ")");
            }
            ps.println();
            blnFirstPiece = false;
        }
    }

    @Override
    public void writeToSectors(SectorBasedFrameAnalysis existingFrame, BitStreamAnalysis newFrame, CdFileSectorReader cd, ILocalizedLogger log) {
        throw new UnsupportedOperationException("Replacing Crusader frames is not supported");
    }

    public String toString() {
        return "Crusader " + this._iWidth + "x" + this._iHeight + " Frame " + this._frameNumber + " Size " + this.getDemuxSize() + " PresSect " + this._iPresentationSector;
    }
}

