/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.crusader;

import java.io.EOFException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.crusader.CrusaderDemuxPiece;
import jpsxdec.modules.crusader.CrusaderPacketHeaderReader;
import jpsxdec.modules.crusader.SectorCrusader;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.DemuxPushInputStream;
import jpsxdec.util.DemuxedData;
import jpsxdec.util.IO;

public class CrusaderSectorToCrusaderPacket {
    private static final Logger LOG = Logger.getLogger(CrusaderSectorToCrusaderPacket.class.getName());
    @CheckForNull
    private PacketListener _packetListener;
    private int _iPrevCrusaderSector = -1;
    @CheckForNull
    private DemuxPushInputStream<CrusaderDemuxPiece> _stream;
    @CheckForNull
    private CrusaderPacketHeaderReader.Header _header;

    public CrusaderSectorToCrusaderPacket(@Nonnull PacketListener listener) {
        this._packetListener = listener;
    }

    public void setListener(@CheckForNull PacketListener listener) {
        this._packetListener = listener;
    }

    public boolean sectorRead(@Nonnull SectorCrusader sector, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        if (this._iPrevCrusaderSector != -1) {
            if (sector.getCrusaderSectorNumber() < this._iPrevCrusaderSector) {
                return false;
            }
            int iNumberOfSectorsMissing = sector.getCrusaderSectorNumber() - this._iPrevCrusaderSector;
            int iPrevCdSector = sector.getSectorNumber() - iNumberOfSectorsMissing;
            int iCrusaderSector = this._iPrevCrusaderSector + 1;
            int iCdSector = iPrevCdSector + 1;
            while (iCrusaderSector < sector.getCrusaderSectorNumber()) {
                this.addPiece(new CrusaderDemuxPiece(iCdSector));
                ++iCrusaderSector;
                ++iCdSector;
            }
        }
        this.addPiece(new CrusaderDemuxPiece(sector));
        this._iPrevCrusaderSector = sector.getCrusaderSectorNumber();
        this.read(log);
        return true;
    }

    private void addPiece(@Nonnull CrusaderDemuxPiece piece) {
        if (this._stream == null) {
            this._stream = new DemuxPushInputStream<CrusaderDemuxPiece>(piece);
        } else {
            this._stream.addPiece(piece);
        }
    }

    public void endVideo(@Nonnull ILocalizedLogger log) throws LoggedFailure {
        this._stream.close();
        this.read(log);
        this._stream = null;
    }

    private void read(@Nonnull ILocalizedLogger log) throws LoggedFailure {
        try {
            while (true) {
                if (this._header == null) {
                    this._stream.mark(16);
                    try {
                        this._header = CrusaderPacketHeaderReader.read(this._stream);
                    }
                    catch (BinaryDataNotRecognized ex) {
                        this._stream.reset();
                        LOG.log(Level.INFO, "Invalid Crusader header in {0} offset {1,number,#}", new Object[]{this._stream.getCurrentPiece(), this._stream.getOffsetInCurrentPiece()});
                        IO.skip(this._stream, 1L);
                    }
                    catch (EOFException ex) {
                        this._stream = null;
                        return;
                    }
                }
                this._stream.mark(this._header.getByteSize());
                int iSkipped = IO.skipMax(this._stream, this._header.getByteSize());
                DemuxedData<CrusaderDemuxPiece> demux = this._stream.getMarkToReadDemux();
                if (this._header.getByteSize() != demux.getDemuxSize()) {
                    LOG.log(Level.WARNING, "Crusader packet header size {0} != demux size {1}", new Object[]{this._header.getByteSize(), demux.getDemuxSize()});
                }
                if (this._header instanceof CrusaderPacketHeaderReader.VideoHeader) {
                    if (this._packetListener != null) {
                        this._packetListener.frame((CrusaderPacketHeaderReader.VideoHeader)this._header, demux, log);
                    }
                } else if (this._header instanceof CrusaderPacketHeaderReader.AudioHeader) {
                    if (this._packetListener != null) {
                        this._packetListener.audio((CrusaderPacketHeaderReader.AudioHeader)this._header, demux, log);
                    }
                } else {
                    throw new RuntimeException();
                }
                this._header = null;
            }
        }
        catch (DemuxPushInputStream.NeedsMoreData ex) {
            this._stream.reset();
        }
        catch (IOException ex) {
            throw new RuntimeException("Should not happen", ex);
        }
    }

    public static interface PacketListener {
        public void frame(@Nonnull CrusaderPacketHeaderReader.VideoHeader var1, @Nonnull DemuxedData<CrusaderDemuxPiece> var2, @Nonnull ILocalizedLogger var3) throws LoggedFailure;

        public void audio(@Nonnull CrusaderPacketHeaderReader.AudioHeader var1, @Nonnull DemuxedData<CrusaderDemuxPiece> var2, @Nonnull ILocalizedLogger var3) throws LoggedFailure;
    }
}

