/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.crusader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.adpcm.SpuAdpcmDecoder;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.crusader.CrusaderDemuxPiece;
import jpsxdec.modules.crusader.CrusaderPacketHeaderReader;
import jpsxdec.modules.crusader.CrusaderSectorToCrusaderPacket;
import jpsxdec.modules.crusader.DemuxedCrusaderFrame;
import jpsxdec.modules.sharedaudio.DecodedAudioPacket;
import jpsxdec.util.DemuxedData;
import jpsxdec.util.Fraction;

public class CrusaderPacketToFrameAndAudio
implements CrusaderSectorToCrusaderPacket.PacketListener {
    public static final int SECTORS_PER_FRAME = 10;
    public static final int CRUSADER_SAMPLE_FRAMES_PER_SECOND = 22050;
    public static final int SAMPLE_FRAMES_PER_SECTOR = 147;
    public static final AudioFormat CRUSADER_AUDIO_FORMAT = new AudioFormat(22050.0f, 16, 2, true, false);
    @Nonnull
    private final SpuAdpcmDecoder.Stereo _audDecoder;
    @CheckForNull
    private DecodedAudioPacket.Listener _audioListener;
    @CheckForNull
    private FrameListener _frameListener;
    private final int _iAbsoluteInitialFramePresentationSector;

    public CrusaderPacketToFrameAndAudio(double dblVolume, int iAbsoluteInitialFramePresentationSector) {
        this._audDecoder = new SpuAdpcmDecoder.Stereo(dblVolume);
        this._iAbsoluteInitialFramePresentationSector = iAbsoluteInitialFramePresentationSector;
    }

    public CrusaderPacketToFrameAndAudio(double dblVolume, int iAbsoluteInitialFramePresentationSector, @Nonnull DecodedAudioPacket.Listener audioListener) {
        this(dblVolume, iAbsoluteInitialFramePresentationSector);
        this._audioListener = audioListener;
    }

    public CrusaderPacketToFrameAndAudio(double dblVolume, int iAbsoluteInitialFramePresentationSector, @Nonnull FrameListener frameListener) {
        this(dblVolume, iAbsoluteInitialFramePresentationSector);
        this._frameListener = frameListener;
    }

    public CrusaderPacketToFrameAndAudio(double dblVolume, int iInitialPresentationSector, @Nonnull DecodedAudioPacket.Listener audioListener, @Nonnull FrameListener frameListener) {
        this(dblVolume, iInitialPresentationSector);
        this._audioListener = audioListener;
        this._frameListener = frameListener;
    }

    public void setFrameListener(@CheckForNull FrameListener frameListener) {
        this._frameListener = frameListener;
    }

    public void setAudioListener(@CheckForNull DecodedAudioPacket.Listener audioListener) {
        this._audioListener = audioListener;
    }

    @Override
    public void frame(@Nonnull CrusaderPacketHeaderReader.VideoHeader frameHeader, @Nonnull DemuxedData<CrusaderDemuxPiece> demux, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        int iPresentationSector = frameHeader.getFrameNumber() * 10 + this._iAbsoluteInitialFramePresentationSector;
        if (this._frameListener != null) {
            DemuxedCrusaderFrame frame = new DemuxedCrusaderFrame(frameHeader.getWidth(), frameHeader.getHeight(), frameHeader.getFrameNumber(), demux, iPresentationSector);
            this._frameListener.frameComplete(frame, log);
        }
    }

    @Override
    public void audio(@Nonnull CrusaderPacketHeaderReader.AudioHeader audio, @Nonnull DemuxedData<CrusaderDemuxPiece> demux, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        byte[] abAudioDemuxBuffer = demux.copyDemuxData();
        if (abAudioDemuxBuffer.length != audio.getByteSize()) {
            assert (abAudioDemuxBuffer.length < audio.getByteSize());
            abAudioDemuxBuffer = Arrays.copyOf(abAudioDemuxBuffer, audio.getByteSize());
        }
        ByteArrayOutputStream audioBuffer = new ByteArrayOutputStream();
        int iChannelSize = abAudioDemuxBuffer.length / 2;
        int iSoundUnitsPerChannel = iChannelSize / 16;
        try {
            this._audDecoder.decode(new ByteArrayInputStream(abAudioDemuxBuffer, 0, iChannelSize), new ByteArrayInputStream(abAudioDemuxBuffer, iChannelSize, iChannelSize), iSoundUnitsPerChannel, audioBuffer);
        }
        catch (IOException ex) {
            throw new RuntimeException("Should never happen", ex);
        }
        if (this._audDecoder.hadCorruption()) {
            log.log(Level.WARNING, I.SPU_ADPCM_CORRUPTED(demux.getStartSector(), this._audDecoder.getSampleFramesWritten()));
        }
        if (this._audioListener != null) {
            Fraction presentationSector = new Fraction(audio.getPresentationSampleFrame(), 147L).add(this._iAbsoluteInitialFramePresentationSector);
            DecodedAudioPacket packet = new DecodedAudioPacket(-1, CRUSADER_AUDIO_FORMAT, presentationSector, audioBuffer.toByteArray());
            this._audioListener.audioPacketComplete(packet, log);
        }
    }

    public static interface FrameListener {
        public void frameComplete(@Nonnull DemuxedCrusaderFrame var1, @Nonnull ILocalizedLogger var2) throws LoggedFailure;

        public void videoEnd(@Nonnull ILocalizedLogger var1, int var2, int var3) throws LoggedFailure;
    }
}

