/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.crusader;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;

public class CrusaderPacketHeaderReader {
    private static final Logger LOG = Logger.getLogger(CrusaderPacketHeaderReader.class.getName());
    private static final long AUDIO_ID = 0x8000200L;
    private static final int MDEC = 1296319811;
    private static final int ad20 = 1633956400;
    private static final int ad21 = 1633956401;

    @Nonnull
    public static Header read(@Nonnull InputStream stream) throws EOFException, IOException, BinaryDataNotRecognized {
        byte[] abHeader = IO.readByteArray(stream, 16);
        try {
            int iPayloadSize = IO.readSInt32BE(abHeader, 4);
            int iRemainingPayloadSize = iPayloadSize - 16;
            if (iRemainingPayloadSize < 1) {
                throw new BinaryDataNotRecognized("Payload size = " + iPayloadSize);
            }
            int iMagic = IO.readSInt32BE(abHeader, 0);
            switch (iMagic) {
                case 1296319811: {
                    return new VideoHeader(abHeader, iRemainingPayloadSize);
                }
                case 1633956400: 
                case 1633956401: {
                    return new AudioHeader(abHeader, iRemainingPayloadSize);
                }
            }
            throw new BinaryDataNotRecognized("Unknown magic " + iMagic);
        }
        catch (BinaryDataNotRecognized ex) {
            if (LOG.isLoggable(Level.INFO)) {
                StringBuilder sb = new StringBuilder("Invalid Crusader header ");
                for (byte b : abHeader) {
                    sb.append(String.format("%02x", b));
                }
                LOG.log(Level.INFO, sb.toString(), ex);
            }
            throw ex;
        }
    }

    public static class AudioHeader
    implements Header {
        private final int _iPresentationSampleFrame;
        private final int _iByteSize;

        public AudioHeader(@Nonnull byte[] abHeader, int iRemainingPayloadSize) throws BinaryDataNotRecognized {
            if (iRemainingPayloadSize % 32 != 0) {
                throw new BinaryDataNotRecognized();
            }
            this._iPresentationSampleFrame = IO.readSInt32BE(abHeader, 8);
            if (this._iPresentationSampleFrame < 0) {
                throw new BinaryDataNotRecognized();
            }
            long lngAudioId = IO.readUInt32BE(abHeader, 12);
            if (lngAudioId != 0x8000200L) {
                throw new BinaryDataNotRecognized();
            }
            this._iByteSize = iRemainingPayloadSize;
        }

        public int getPresentationSampleFrame() {
            return this._iPresentationSampleFrame;
        }

        @Override
        public int getByteSize() {
            return this._iByteSize;
        }
    }

    public static class VideoHeader
    implements Header {
        private final short _iWidth;
        private final short _iHeight;
        private final int _iFrameNumber;
        private final int _iByteSize;

        public VideoHeader(@Nonnull byte[] abHeader, int iRemainingPayloadSize) throws BinaryDataNotRecognized {
            this._iWidth = IO.readSInt16BE(abHeader, 8);
            if (this._iWidth < 1) {
                throw new BinaryDataNotRecognized();
            }
            this._iHeight = IO.readSInt16BE(abHeader, 10);
            if (this._iHeight < 1) {
                throw new BinaryDataNotRecognized();
            }
            this._iFrameNumber = IO.readSInt32BE(abHeader, 12);
            if (this._iFrameNumber < 0) {
                throw new BinaryDataNotRecognized();
            }
            this._iByteSize = iRemainingPayloadSize;
        }

        public short getWidth() {
            return this._iWidth;
        }

        public short getHeight() {
            return this._iHeight;
        }

        public int getFrameNumber() {
            return this._iFrameNumber;
        }

        @Override
        public int getByteSize() {
            return this._iByteSize;
        }
    }

    public static interface Header {
        public int getByteSize();
    }
}

