/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.crusader;

import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.modules.crusader.SectorCrusader;
import jpsxdec.util.DemuxedData;

public class CrusaderDemuxPiece
implements DemuxedData.Piece {
    private static final int CRUSADER_USERDATA_SIZE = 2040;
    @CheckForNull
    private final SectorCrusader _sector;
    private final int _iCdSectorNumber;

    public CrusaderDemuxPiece(@Nonnull SectorCrusader sector) {
        this._sector = sector;
        this._iCdSectorNumber = this._sector.getSectorNumber();
    }

    public CrusaderDemuxPiece(int iCdSectorNumber) {
        this._sector = null;
        this._iCdSectorNumber = iCdSectorNumber;
    }

    @Override
    public int getDemuxPieceSize() {
        if (this._sector == null) {
            return 2040;
        }
        return this._sector.getIdentifiedUserDataSize();
    }

    @Override
    public byte getDemuxPieceByte(int i) {
        if (this._sector == null) {
            return 0;
        }
        return this._sector.readIdentifiedUserDataByte(i);
    }

    @Override
    public void copyDemuxPieceData(@Nonnull byte[] abOut, int iOutPos) {
        if (this._sector != null) {
            this._sector.copyIdentifiedUserData(0, abOut, iOutPos, this._sector.getIdentifiedUserDataSize());
        } else {
            Arrays.fill(abOut, iOutPos, iOutPos + 2040, (byte)0);
        }
    }

    @CheckForNull
    public SectorCrusader getSector() {
        return this._sector;
    }

    @Override
    public int getSectorNumber() {
        return this._iCdSectorNumber;
    }

    public String toString() {
        if (this._sector != null) {
            return this._sector.toString();
        }
        return "Crusader [CD sector " + this._iCdSectorNumber + "] missing";
    }
}

