/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.aconcagua;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.aconcagua.AconcaguaDemuxer;
import jpsxdec.modules.video.sectorbased.ISelfDemuxingVideoSector;
import jpsxdec.modules.video.sectorbased.IVideoSectorWithFrameNumber;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameReplace;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.util.DemuxedData;

public class SectorAconcaguaVideo
extends IdentifiedSector
implements DemuxedData.Piece,
ISelfDemuxingVideoSector,
SectorBasedFrameReplace.IReplaceableVideoSector,
IVideoSectorWithFrameNumber {
    private static final long MAGIC_NUMBER_BE = 1610678784L;
    private int _iChunkNumber;
    private int _iChunksInFrame;
    private int _iFrameNumber;
    private int _iCodeCount;
    private int _iWidth;
    private int _iHeight;
    private int _iQuantizationScale;

    public SectorAconcaguaVideo(CdSector cdSector) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        long lngMagic = cdSector.readUInt32BE(0);
        if (lngMagic != 1610678784L) {
            return;
        }
        this._iChunkNumber = cdSector.readSInt16LE(4);
        if (this._iChunkNumber < 0 || this._iChunkNumber > 10) {
            return;
        }
        this._iChunksInFrame = cdSector.readSInt16LE(6);
        if (this._iChunksInFrame <= 0 || this._iChunksInFrame > 10) {
            return;
        }
        this._iFrameNumber = cdSector.readSInt32LE(8);
        if (this._iFrameNumber < 0) {
            return;
        }
        this._iCodeCount = cdSector.readSInt32LE(12);
        if (this._iCodeCount < 1) {
            return;
        }
        this._iWidth = cdSector.readSInt16LE(16);
        if (this._iWidth < 16 || this._iWidth > 400) {
            return;
        }
        this._iHeight = cdSector.readSInt16LE(18);
        if (this._iHeight < 16 || this._iHeight > 400) {
            return;
        }
        this._iQuantizationScale = cdSector.readSInt32LE(20);
        if (this._iQuantizationScale < 1 || this._iQuantizationScale > 64) {
            return;
        }
        for (int i = 24; i < 32; ++i) {
            if (cdSector.readUserDataByte(i) == 0) continue;
            return;
        }
        this.setProbability(100);
    }

    @Override
    public String getTypeName() {
        return "Aconcagua Video";
    }

    @Override
    public int getWidth() {
        return this._iWidth;
    }

    @Override
    public int getHeight() {
        return this._iHeight;
    }

    @Override
    public int getHeaderFrameNumber() {
        return this._iFrameNumber;
    }

    @Override
    public int getChunksInFrame() {
        return this._iChunksInFrame;
    }

    @Override
    public int getChunkNumber() {
        return this._iChunkNumber;
    }

    public int getQuantizationScale() {
        return this._iQuantizationScale;
    }

    @Override
    public int getVideoSectorHeaderSize() {
        return 32;
    }

    @Override
    public int getDemuxPieceSize() {
        return this.getCdSector().getCdUserDataSize() - this.getVideoSectorHeaderSize();
    }

    @Override
    public byte getDemuxPieceByte(int i) {
        return this.getCdSector().readUserDataByte(i);
    }

    @Override
    public void copyDemuxPieceData(@Nonnull byte[] abOut, int iOutPos) {
        this.getCdSector().getCdUserDataCopy(this.getVideoSectorHeaderSize(), abOut, iOutPos, this.getDemuxPieceSize());
    }

    @Override
    @Nonnull
    public AconcaguaDemuxer createDemuxer(@Nonnull ILocalizedLogger log) {
        return new AconcaguaDemuxer(this, log);
    }

    @Override
    public String toString() {
        return String.format("%s %s frame:%d chunk:%d/%d %dx%d codes:%d qscale=%d", this.getTypeName(), super.cdToString(), this._iFrameNumber, this._iChunkNumber, this._iChunksInFrame, this._iWidth, this._iHeight, this._iCodeCount, this._iQuantizationScale);
    }

    @Override
    public void replaceVideoSectorHeader(SectorBasedFrameAnalysis existingFrame, BitStreamAnalysis newFrame, byte[] abCurrentVidSectorHeader) {
        throw new UnsupportedOperationException("Never going to support replacing Aconcagua video");
    }
}

