/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.aconcagua;

import javax.annotation.Nonnull;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.util.Misc;

public class InstructionTable {
    private static final int BOTTOM_10_BITS = 1023;
    private static final int _111110b = 62;
    private static final InstructionCode[] PARTIAL_LOOKUP = new InstructionCode[63];
    private static final InstructionCode[] INSTRUCTIONS = new InstructionCode[]{new InstructionCode("0", 0, 0, 0), new InstructionCode("01", 0, 0, 1), new InstructionCode("011", 0, 0, 2), new InstructionCode("0111", 0, 0, 3), new InstructionCode("001111111", 0, 0, 4), new InstructionCode("011111111", 3, 1, 12), new InstructionCode("101111111", 3, 1, 14), new InstructionCode("111111111", 3, 1, 13), new InstructionCode("0000001111", 5, 2, 19), new InstructionCode("0000011111", 7, 43, 8), new InstructionCode("0000101111", 10, 7, 25), new InstructionCode("0000111111", 2, 0, 10), new InstructionCode("0001001111", 1, 0, 8), new InstructionCode("0001011111", 6, 27, 17), new InstructionCode("0001101111", 8, 4, 22), new InstructionCode("0010001111", 6, 3, 21), new InstructionCode("0010011111", 1, 56, 5), new InstructionCode("0010101111", 8, 16, 22), new InstructionCode("0010111111", 1, 1, 9), new InstructionCode("0011001111", 0, 1, 5), new InstructionCode("0011011111", 9, 24, 19), new InstructionCode("0011101111", 9, 5, 24), new InstructionCode("0100001111", 0, 0, 5), new InstructionCode("0100011111", 7, 44, 8), new InstructionCode("0100101111", 9, 6, 25), new InstructionCode("0100111111", 3, 0, 12), new InstructionCode("0101001111", 1, 0, 9), new InstructionCode("0101011111", 6, 25, 17), new InstructionCode("0101101111", 7, 3, 22), new InstructionCode("0110001111", 6, 2, 20), new InstructionCode("0110011111", 8, 33, 14), new InstructionCode("0110101111", 10, 9, 25), new InstructionCode("0110111111", 2, 1, 10), new InstructionCode("0111001111", 5, 1, 17), new InstructionCode("0111011111", 8, 28, 17), new InstructionCode("0111101111", 8, 5, 23), new InstructionCode("1000001111", 6, 1, 20), new InstructionCode("1000011111", 10, 34, 12), new InstructionCode("1000101111", 8, 11, 24), new InstructionCode("1000111111", 4, 1, 14), new InstructionCode("1001001111", 1, 0, 7), new InstructionCode("1001011111", 11, 24, 16), new InstructionCode("1001101111", 8, 4, 23), new InstructionCode("1010001111", 7, 3, 21), new InstructionCode("1010011111", 0, 58, 5), new InstructionCode("1010101111", 8, 18, 21), new InstructionCode("1010111111", 4, 1, 16), new InstructionCode("1011001111", 5, 1, 18), new InstructionCode("1011011111", 2, 53, 5), new InstructionCode("1011101111", 9, 6, 24), new InstructionCode("1100001111", 5, 2, 18), new InstructionCode("1100011111", 1, 54, 6), new InstructionCode("1100101111", 9, 7, 25), new InstructionCode("1100111111", 2, 1, 11), new InstructionCode("1101001111", 4, 1, 17), new InstructionCode("1101011111", 10, 20, 19), new InstructionCode("1101101111", 7, 4, 22), new InstructionCode("1110001111", 6, 3, 20), new InstructionCode("1110011111", 15, 29, 13), new InstructionCode("1110101111", 9, 12, 24), new InstructionCode("1110111111", 4, 1, 15), new InstructionCode("1111001111", 1, 0, 6), new InstructionCode("1111011111", 8, 33, 13), new InstructionCode("1111101111", 8, 6, 23)};

    @Nonnull
    public static InstructionCode lookup(int iBottom10Bits) throws MdecException.ReadCorruption {
        int iOnesCount;
        int b = iBottom10Bits &= 0x3FF;
        for (iOnesCount = 0; iOnesCount < 9 && (b & 1) != 0; ++iOnesCount) {
            b >>>= 1;
        }
        if (iOnesCount <= 3) {
            return INSTRUCTIONS[iOnesCount];
        }
        if (iOnesCount < 7) {
            InstructionCode code = PARTIAL_LOOKUP[iBottom10Bits >>> 4];
            if (code == null) {
                throw new MdecException.ReadCorruption("Aconcagua lookup table bits " + Misc.bitsToString(iBottom10Bits, 10));
            }
            return code;
        }
        if (iOnesCount <= 9) {
            return INSTRUCTIONS[4 + (iBottom10Bits >>> 7 & 3)];
        }
        throw new MdecException.ReadCorruption("Aconcagua lookup table bits " + Misc.bitsToString(iBottom10Bits, 10));
    }

    private static void buildLookup() {
        for (int i = 8; i < INSTRUCTIONS.length; ++i) {
            InstructionCode code = INSTRUCTIONS[i];
            int iLookupPos = Integer.parseInt(code._sBits, 2);
            InstructionTable.PARTIAL_LOOKUP[iLookupPos >>> 4] = code;
        }
    }

    static {
        InstructionTable.buildLookup();
    }

    public static class InstructionCode {
        @Nonnull
        private final String _sBits;
        private final int _iTable1Count;
        private final int _iTable2Count;
        private final int _iTable3Count;

        protected InstructionCode(@Nonnull String sBits, int iTable1Count, int iTable2Count, int iTable3Count) {
            this._sBits = sBits;
            this._iTable1Count = iTable1Count;
            this._iTable2Count = iTable2Count;
            this._iTable3Count = iTable3Count;
        }

        public int getTable1Count() {
            return this._iTable1Count;
        }

        public int getTable2Count() {
            return this._iTable2Count;
        }

        public int getTable3Count() {
            return this._iTable3Count;
        }

        public int getBitCodeLen() {
            return this._sBits.length();
        }

        public String getBits() {
            return this._sBits;
        }

        public String toString() {
            return this.make();
        }

        @Nonnull
        public String make() {
            return String.format("new InstructionCode(%12s, %2d, %2d, %2d),", "\"" + this._sBits + "\"", this._iTable1Count, this._iTable2Count, this._iTable3Count);
        }
    }
}

