/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.aconcagua;

import javax.annotation.Nonnull;
import jpsxdec.modules.aconcagua.DcTable;
import jpsxdec.modules.aconcagua.InstructionTable;
import jpsxdec.modules.aconcagua.ZeroRunLengthAcTables;
import jpsxdec.psxvideo.bitstreams.BitStreamDebugging;
import jpsxdec.psxvideo.mdec.MdecBlock;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecContext;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;

public class BitStreamUncompressor_Aconcagua
implements MdecInputStream {
    private static final int MACROBLOCK_HEIGHT = 13;
    private final int _iQuantizationScale;
    @Nonnull
    private final MdecContext _context;
    private int _iBlocksLeftInColumn = 78;
    @Nonnull
    private final AconcaguaBitReader _bitstream;
    private int _iPreviousDcCr = 0;
    private int _iPreviousDcCb = 0;
    private int _iPreviousDcSetInY1UsedInY2Y3 = 0;
    private int _iPreviousDcSetInY3UsedInY1Y4 = 0;
    private int _iTable1Reads = -1;
    private int _iTable2Reads = -1;
    private int _iTable3Reads = -1;
    private static final int BOTTOM_3_BITS = 7;
    private static final int BOTTOM_8_BITS = 255;
    private static final int BOTTOM_9_BITS = 511;
    private static final int BOTTOM_10_BITS = 1023;
    private static final int BOTTOM_11_BITS = 2047;
    private static final int BOTTOM_14_BITS = 16383;
    private static final int BIT9 = 256;
    private static final int BIT10 = 512;

    public BitStreamUncompressor_Aconcagua(int iMacroblockHeight, int iQuantizationScale, @Nonnull byte[] abBitstream) {
        this._iQuantizationScale = iQuantizationScale;
        this._bitstream = new AconcaguaBitReader(abBitstream, 0);
        this._context = new MdecContext(iMacroblockHeight);
    }

    private void resetColumn() {
        this._iPreviousDcCr = 0;
        this._iPreviousDcCb = 0;
        this._iPreviousDcSetInY1UsedInY2Y3 = 0;
        this._iPreviousDcSetInY3UsedInY1Y4 = 0;
        this._bitstream.resetColumn();
        this._iBlocksLeftInColumn = 78;
    }

    @Override
    public boolean readMdecCode(@Nonnull MdecCode code) throws MdecException.EndOfStream, MdecException.ReadCorruption {
        int iNext32Bits;
        if (this._context.atStartOfBlock()) {
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.println(this._context.toString()));
            if (this._iBlocksLeftInColumn == 0) {
                this.resetColumn();
            }
            --this._iBlocksLeftInColumn;
            int iNext32Bits2 = this._bitstream.getBits();
            int iBitsToSkip = this.readDc(this._context.getCurrentBlock(), code, iNext32Bits2);
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.println(String.format("%d bits qscale/dc %s", iBitsToSkip, code)));
            this._bitstream.skipBits(iBitsToSkip);
            this._context.nextCode();
            return false;
        }
        if (this._context.getMdecCodesReadInCurrentBlock() == 1) {
            int iInstructionCode = this._bitstream.getBits() & 0x3FF;
            InstructionTable.InstructionCode instruction = InstructionTable.lookup(iInstructionCode);
            this._bitstream.skipBits(instruction.getBitCodeLen());
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.println(String.format("%d bits %s", instruction.getBitCodeLen(), instruction)));
            this._iTable1Reads = instruction.getTable1Count();
            this._iTable2Reads = instruction.getTable2Count();
            this._iTable3Reads = instruction.getTable3Count();
        }
        if (this._iTable1Reads > 0) {
            iNext32Bits = this._bitstream.getBits();
            int iBitsToSkip = BitStreamUncompressor_Aconcagua.readTable1(code, iNext32Bits);
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.println(String.format("%d bits %s", iBitsToSkip, code)));
            this._bitstream.skipBits(iBitsToSkip);
            --this._iTable1Reads;
            this._context.nextCode();
            return false;
        }
        if (this._iTable2Reads > 0) {
            iNext32Bits = this._bitstream.getBits();
            int iBitsToSkip = BitStreamUncompressor_Aconcagua.readTable2(code, iNext32Bits);
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.println(String.format("%d bits %s", iBitsToSkip, code)));
            this._bitstream.skipBits(iBitsToSkip);
            --this._iTable2Reads;
            this._context.nextCode();
            return false;
        }
        if (this._iTable3Reads > 0) {
            iNext32Bits = this._bitstream.getBits();
            int iBitsToSkip = BitStreamUncompressor_Aconcagua.readTable3(code, iNext32Bits);
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.println(String.format("%d bits %s", iBitsToSkip, code)));
            this._bitstream.skipBits(iBitsToSkip);
            --this._iTable3Reads;
            this._context.nextCode();
            return false;
        }
        code.setToEndOfData();
        this._context.nextCodeEndBlock();
        return true;
    }

    private int readDc(@Nonnull MdecBlock block, @Nonnull MdecCode code, int iNext32Bits) throws MdecException.ReadCorruption {
        int iFinalDc;
        int iBitsToSkip;
        boolean blnIsDcEscapeCode = (iNext32Bits & 7) == 0;
        int iDcFromEscapeCode = -1;
        int iRelativeDcFromTable = -1;
        if (blnIsDcEscapeCode) {
            iDcFromEscapeCode = iNext32Bits >> 3 & 0x3FF;
            iBitsToSkip = 13;
        } else {
            DcTable.DcCode entry = DcTable.lookup(iNext32Bits & 0x7FF);
            iRelativeDcFromTable = entry.getRelativeDcCoefficient();
            iBitsToSkip = entry.getBitCodeLen();
        }
        switch (block) {
            case Cr: {
                iFinalDc = blnIsDcEscapeCode ? iDcFromEscapeCode : iRelativeDcFromTable + this._iPreviousDcCr;
                this._iPreviousDcCr = iFinalDc;
                break;
            }
            case Cb: {
                iFinalDc = blnIsDcEscapeCode ? iDcFromEscapeCode : iRelativeDcFromTable + this._iPreviousDcCb;
                this._iPreviousDcCb = iFinalDc;
                break;
            }
            case Y1: {
                iFinalDc = blnIsDcEscapeCode ? iDcFromEscapeCode : iRelativeDcFromTable + this._iPreviousDcSetInY3UsedInY1Y4;
                this._iPreviousDcSetInY1UsedInY2Y3 = iFinalDc;
                break;
            }
            case Y2: {
                if (blnIsDcEscapeCode) {
                    iFinalDc = iDcFromEscapeCode;
                    break;
                }
                iFinalDc = iRelativeDcFromTable + this._iPreviousDcSetInY1UsedInY2Y3;
                break;
            }
            case Y3: {
                iFinalDc = blnIsDcEscapeCode ? iDcFromEscapeCode : iRelativeDcFromTable + this._iPreviousDcSetInY1UsedInY2Y3;
                this._iPreviousDcSetInY3UsedInY1Y4 = iFinalDc;
                break;
            }
            default: {
                iFinalDc = blnIsDcEscapeCode ? iDcFromEscapeCode : iRelativeDcFromTable + this._iPreviousDcSetInY3UsedInY1Y4;
            }
        }
        code.set(this._iQuantizationScale << 10 | iFinalDc & 0x3FF);
        return iBitsToSkip;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this._context.toString() + " current 4 byte start=" + this._bitstream._iPositionMultOf4;
    }

    private static int readTable1(@Nonnull MdecCode code, int iNext32Bits) throws MdecException.ReadCorruption {
        if ((iNext32Bits & 0xFF) == 0) {
            int iVlcCodeLength;
            int iMdecCode;
            if ((iNext32Bits & 0x100) != 0) {
                iMdecCode = iNext32Bits >> 9;
                iVlcCodeLength = 25;
            } else {
                int iSignExtendAc = iNext32Bits << 16 >> 25;
                iMdecCode = iSignExtendAc & 0x3FF;
                iVlcCodeLength = 16;
            }
            code.set(iMdecCode);
            return iVlcCodeLength;
        }
        ZeroRunLengthAcTables.AcCode ac = ZeroRunLengthAcTables.lookupTable1(iNext32Bits & 0x3FFF);
        ac.setMdec(code);
        return ac._sBits.length();
    }

    private static int readTable2(@Nonnull MdecCode code, int iNext32Bits) throws MdecException.ReadCorruption {
        if ((iNext32Bits & 0x1FF) == 0) {
            int iVlcCodeLength;
            int iMdecCode;
            if ((iNext32Bits & 0x200) != 0) {
                iMdecCode = iNext32Bits >> 10;
                iVlcCodeLength = 26;
            } else {
                int iSignExtendAc = iNext32Bits << 17 >> 27;
                int iZeroRunLength = iNext32Bits >> 5 & 0x1C00;
                iMdecCode = iSignExtendAc & 0x3FF | iZeroRunLength;
                iVlcCodeLength = 18;
            }
            code.set(iMdecCode);
            return iVlcCodeLength;
        }
        ZeroRunLengthAcTables.AcCode ac = ZeroRunLengthAcTables.lookupTable2(iNext32Bits & 0x3FFF);
        ac.setMdec(code);
        return ac._sBits.length();
    }

    private static int readTable3(@Nonnull MdecCode code, int iNext32Bits) throws MdecException.ReadCorruption {
        if ((iNext32Bits & 0x1FF) == 0) {
            int iVlcCodeLength;
            int iMdecCode;
            if ((iNext32Bits & 0x200) != 0) {
                iMdecCode = iNext32Bits >> 10;
                iVlcCodeLength = 26;
            } else {
                int iSignExtendAc = iNext32Bits << 18 >> 28;
                int iZeroRunLength = iNext32Bits >> 4 & 0x3C00;
                iMdecCode = iSignExtendAc & 0x3FF | iZeroRunLength;
                iVlcCodeLength = 18;
            }
            code.set(iMdecCode);
            return iVlcCodeLength;
        }
        ZeroRunLengthAcTables.AcCode ac = ZeroRunLengthAcTables.lookupTable3(iNext32Bits & 0x3FFF);
        ac.setMdec(code);
        return ac._sBits.length();
    }

    private static class AconcaguaBitReader {
        private int _iFrontBits;
        private int _iMidBits;
        private int _iBackBits;
        private int _iBitsRemaining;
        @Nonnull
        private final byte[] _abBitstream;
        private int _iPositionMultOf4 = -4;

        public AconcaguaBitReader(@Nonnull byte[] abBitstream, int iStartPos) {
            this._abBitstream = abBitstream;
            this.resetColumn();
        }

        public final void resetColumn() {
            this._iBitsRemaining = 32;
            this._iPositionMultOf4 += 4;
            this._iFrontBits = IO.readSInt32LE(this._abBitstream, this._iPositionMultOf4);
            this._iMidBits = IO.readSInt32LE(this._abBitstream, this._iPositionMultOf4 + 4);
            this._iBackBits = IO.readSInt32LE(this._abBitstream, this._iPositionMultOf4 + 8);
        }

        public int getBits() {
            return this._iFrontBits;
        }

        public void skipBits(int iNumBits) {
            assert (!BitStreamDebugging.DEBUG || BitStreamDebugging.println(String.format("Skip %d bits %s", iNumBits, Misc.bitsToString(this._iFrontBits, iNumBits))));
            this._iFrontBits >>>= iNumBits;
            this._iBitsRemaining -= iNumBits;
            int i = this._iMidBits << 32 - iNumBits;
            this._iMidBits >>>= iNumBits;
            this._iFrontBits |= i;
            if (this._iBitsRemaining < 0) {
                this.loadMoreBits();
            }
        }

        public void loadMoreBits() {
            this._iMidBits = this._iBackBits;
            this._iBackBits = this._iPositionMultOf4 + 12 < this._abBitstream.length ? IO.readSInt32LE(this._abBitstream, this._iPositionMultOf4 + 12) : 0;
            this._iBitsRemaining += 32;
            int rTemp = this._iMidBits << this._iBitsRemaining;
            this._iFrontBits |= rTemp;
            rTemp = 32 - this._iBitsRemaining;
            this._iMidBits >>>= rTemp;
            this._iPositionMultOf4 += 4;
        }
    }
}

