/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.aconcagua;

import java.util.List;
import javax.annotation.Nonnull;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.aconcagua.DemuxedAconcaguaFrame;
import jpsxdec.modules.aconcagua.SectorAconcaguaVideo;
import jpsxdec.modules.video.sectorbased.ISelfDemuxingVideoSector;
import jpsxdec.modules.video.sectorbased.IVideoSectorWithFrameNumber;
import jpsxdec.modules.video.sectorbased.VideoSectorWithFrameNumberDemuxer;

public class AconcaguaDemuxer
extends VideoSectorWithFrameNumberDemuxer {
    private final int _iQuantizationScale;

    public AconcaguaDemuxer(@Nonnull SectorAconcaguaVideo firstChunk, @Nonnull ILocalizedLogger log) {
        super(firstChunk, log);
        this._iQuantizationScale = firstChunk.getQuantizationScale();
    }

    @Override
    public boolean addSectorIfPartOfFrame(@Nonnull ISelfDemuxingVideoSector sector) {
        if (!(sector instanceof SectorAconcaguaVideo)) {
            return false;
        }
        if (((SectorAconcaguaVideo)sector).getQuantizationScale() != this._iQuantizationScale) {
            return false;
        }
        return super.addSectorIfPartOfFrame(sector);
    }

    @Override
    public DemuxedAconcaguaFrame finishFrame(@Nonnull ILocalizedLogger log) {
        List<IVideoSectorWithFrameNumber> s = this.getNonNullChunks(log);
        return new DemuxedAconcaguaFrame(this.getWidth(), this.getHeight(), this.getHeaderFrameNumber(), s, this._iQuantizationScale);
    }
}

