/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.ac3;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorXaSubHeader;
import jpsxdec.modules.IdentifiedSector;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameReplace;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.util.DemuxedData;

public class SectorAceCombat3Video
extends IdentifiedSector
implements DemuxedData.Piece,
SectorBasedFrameReplace.IReplaceableVideoSector {
    private int _iChunkNumber;
    private int _iChunksInThisFrame;
    private int _iUnknown1;
    private int _iInvertedFrame;
    private int _iWidth;
    private int _iHeight;
    private long _lngUnknown2;
    private long _lngUnknown3;

    @Override
    public int getVideoSectorHeaderSize() {
        return 32;
    }

    public SectorAceCombat3Video(@Nonnull CdSector cdSector) {
        super(cdSector);
        if (this.isSuperInvalidElseReset()) {
            return;
        }
        if (cdSector.getSubHeader() == null) {
            return;
        }
        if (cdSector.readUserDataByte(0) != 1) {
            return;
        }
        this._iChunkNumber = cdSector.readUserDataByte(1);
        if (this._iChunkNumber < 0) {
            return;
        }
        this._iChunksInThisFrame = cdSector.readSInt16LE(2);
        if (this._iChunksInThisFrame < 1) {
            return;
        }
        this._iUnknown1 = cdSector.readUInt16LE(4);
        this._iInvertedFrame = cdSector.readUInt16LE(6);
        if (this._iInvertedFrame < 0) {
            return;
        }
        this._iWidth = cdSector.readSInt16LE(8);
        this._iHeight = cdSector.readSInt16LE(10);
        if (!(this._iWidth == 304 && this._iHeight == 224 || this._iWidth == 320 && this._iHeight == 176 || this._iWidth == 128 && this._iHeight == 96)) {
            return;
        }
        if (cdSector.readSInt32BE(12) != 0) {
            return;
        }
        this._lngUnknown2 = cdSector.readSInt64BE(16);
        this._lngUnknown3 = cdSector.readSInt64BE(24);
        this.setProbability(100);
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "AC3";
    }

    public int getWidth() {
        return this._iWidth;
    }

    public int getHeight() {
        return this._iHeight;
    }

    public int getChunkNumber() {
        return this._iChunkNumber;
    }

    public int getChunksInFrame() {
        return this._iChunksInThisFrame;
    }

    public int getInvertedFrameNumber() {
        return this._iInvertedFrame;
    }

    public int getChannel() {
        CdSectorXaSubHeader sh = this.getCdSector().getSubHeader();
        assert (sh != null);
        return sh.getChannel();
    }

    @Override
    public int getDemuxPieceSize() {
        return this.getCdSector().getCdUserDataSize() - this.getVideoSectorHeaderSize();
    }

    @Override
    public byte getDemuxPieceByte(int i) {
        return this.getCdSector().readUserDataByte(this.getVideoSectorHeaderSize() + i);
    }

    @Override
    public void copyDemuxPieceData(@Nonnull byte[] abOut, int iOutPos) {
        this.getCdSector().getCdUserDataCopy(this.getVideoSectorHeaderSize(), abOut, iOutPos, this.getDemuxPieceSize());
    }

    @Override
    public String toString() {
        return String.format("%s %s inv-frame: %d chunk:%d/%d %dx%d ?1:%04x ?2:%016x ?3:%016x", this.getTypeName(), this.cdToString(), this._iInvertedFrame, this._iChunkNumber, this._iChunksInThisFrame, this._iWidth, this._iHeight, this._iUnknown1, this._lngUnknown2, this._lngUnknown3);
    }

    @Override
    public void replaceVideoSectorHeader(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull byte[] abCurrentVidSectorHeader) {
    }
}

