/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.ac3;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.ac3.Ac3AddResult;
import jpsxdec.modules.ac3.Ac3Demuxer;
import jpsxdec.modules.ac3.DemuxedAc3Frame;
import jpsxdec.modules.ac3.SectorAceCombat3Video;

public class SectorAc3VideoToDemuxedAc3Frame {
    private final int _iChannel;
    @Nonnull
    private final SectorRange _sectorRange;
    @CheckForNull
    private Ac3Demuxer _currentFrame;
    @CheckForNull
    private Listener _listener;

    public SectorAc3VideoToDemuxedAc3Frame(int iChannel, @Nonnull SectorRange sectorRange) {
        this(iChannel, sectorRange, null);
    }

    public SectorAc3VideoToDemuxedAc3Frame(int iChannel, @Nonnull SectorRange sectorRange, @Nonnull Listener listener) {
        this._iChannel = iChannel;
        this._sectorRange = sectorRange;
        this._listener = listener;
    }

    public void setListener(@CheckForNull Listener listener) {
        this._listener = listener;
    }

    @Nonnull
    public Ac3AddResult feedSector(@Nonnull SectorAceCombat3Video vidSector, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        Ac3AddResult result;
        if (vidSector.getChannel() != this._iChannel) {
            return Ac3AddResult.WrongChannel;
        }
        if (this._currentFrame != null && (result = this._currentFrame.addSector(vidSector)) == Ac3AddResult.WrongFormat) {
            this.endOfSectors(log);
        }
        if (this._sectorRange.sectorIsInRange(vidSector.getSectorNumber())) {
            if (this._currentFrame == null) {
                this._currentFrame = new Ac3Demuxer(vidSector, log);
            }
            if (this._currentFrame.isFrameComplete()) {
                this.endOfSectors(log);
            }
        } else {
            this.endOfSectors(log);
        }
        return Ac3AddResult.Same;
    }

    public void endOfSectors(@Nonnull ILocalizedLogger log) throws LoggedFailure {
        if (this._currentFrame == null) {
            return;
        }
        if (this._listener != null) {
            this._listener.frameComplete(this._currentFrame.finishFrame(log), log);
        }
        this._currentFrame = null;
    }

    public static interface Listener {
        public void frameComplete(@Nonnull DemuxedAc3Frame var1, @Nonnull ILocalizedLogger var2) throws LoggedFailure;
    }
}

