/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.ac3;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.DebugLogger;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.ac3.DemuxedAc3Frame;
import jpsxdec.modules.ac3.SectorAc3VideoToDemuxedAc3Frame;
import jpsxdec.modules.ac3.SectorAceCombat3Video;
import jpsxdec.modules.video.Dimensions;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.ISectorClaimToDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.framenumber.HeaderFrameNumber;
import jpsxdec.modules.video.framenumber.IFrameNumberFormatterWithHeader;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.modules.video.sectorbased.DiscItemSectorBasedVideoStream;
import jpsxdec.modules.video.sectorbased.SectorBasedVideoInfo;
import jpsxdec.modules.xa.DiscItemXaAudioStream;

public class DiscItemAceCombat3VideoStream
extends DiscItemSectorBasedVideoStream {
    public static final String TYPE_ID = "AC3Vid";
    @Nonnull
    private final HeaderFrameNumber.Format _headerFrameNumberFormat;
    private static final String MAX_INV_FRAME_KEY = "Max inv frame";
    private final int _iMaxInvFrame;
    private static final String CHANNEL_KEY = "Channel";
    private final int _iChannel;
    private static final int AUDIO_SPLIT_THRESHOLD = 32;

    public DiscItemAceCombat3VideoStream(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector, @Nonnull Dimensions dim, @Nonnull IndexSectorFrameNumber.Format sectorIndexFrameNumberFormat, @Nonnull SectorBasedVideoInfo strVidInfo, @Nonnull HeaderFrameNumber.Format headerFrameNumberFormat, int iMaxInvFrame, int iChannel) {
        super(cd, iStartSector, iEndSector, dim, sectorIndexFrameNumberFormat, strVidInfo);
        this._headerFrameNumberFormat = headerFrameNumberFormat;
        this._iMaxInvFrame = iMaxInvFrame;
        this._iChannel = iChannel;
    }

    public DiscItemAceCombat3VideoStream(@Nonnull CdFileSectorReader cd, @Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        super(cd, fields);
        this._headerFrameNumberFormat = new HeaderFrameNumber.Format(fields);
        this._iMaxInvFrame = fields.getInt(MAX_INV_FRAME_KEY);
        this._iChannel = fields.getInt(CHANNEL_KEY);
    }

    @Override
    @Nonnull
    public SerializedDiscItem serialize() {
        SerializedDiscItem serial = super.serialize();
        this._headerFrameNumberFormat.serialize(serial);
        serial.addNumber(MAX_INV_FRAME_KEY, this._iMaxInvFrame);
        serial.addNumber(CHANNEL_KEY, this._iChannel);
        return serial;
    }

    @Override
    @Nonnull
    public String getSerializationTypeId() {
        return TYPE_ID;
    }

    @Override
    public boolean hasIndependentBitstream() {
        return true;
    }

    @Override
    public int getParentRating(@Nonnull DiscItem child) {
        if (!(child instanceof DiscItemXaAudioStream)) {
            return 0;
        }
        if (((DiscItemXaAudioStream)child).getChannel() != this._iChannel) {
            return 0;
        }
        int iOverlapPercent = child.getOverlap(this) * 100 / child.getSectorLength();
        if (iOverlapPercent > 0) {
            iOverlapPercent += 100;
        }
        return iOverlapPercent;
    }

    @Override
    public int findAudioSplitPoint(@Nonnull DiscItemXaAudioStream audio) {
        if (audio.getChannel() != this._iChannel) {
            return -1;
        }
        int iStartSector = this.getStartSector();
        if (audio.getStartSector() < iStartSector - 32 && audio.getEndSector() >= iStartSector) {
            return iStartSector - 1;
        }
        return -1;
    }

    @Override
    @Nonnull
    public FrameNumber getStartFrame() {
        return this._headerFrameNumberFormat.getStartFrame(this._indexSectorFrameNumberFormat);
    }

    @Override
    public FrameNumber getEndFrame() {
        return this._headerFrameNumberFormat.getEndFrame(this._indexSectorFrameNumberFormat);
    }

    @Override
    @Nonnull
    public List<FrameNumber.Type> getFrameNumberTypes() {
        return Arrays.asList(FrameNumber.Type.Index, FrameNumber.Type.Header, FrameNumber.Type.Sector);
    }

    @Override
    public void fpsDump(@Nonnull PrintStream ps) throws CdFileSectorReader.CdReadException {
        SectorClaimSystem it = this.createClaimSystem();
        int iSector = 0;
        while (it.hasNext()) {
            IIdentifiedSector isect = it.next(DebugLogger.Log);
            if (isect instanceof SectorAceCombat3Video) {
                SectorAceCombat3Video vidSect = (SectorAceCombat3Video)isect;
                ps.println(String.format("%-5d %-4d %d/%d", iSector, this._iMaxInvFrame - vidSect.getInvertedFrameNumber(), vidSect.getChunkNumber(), vidSect.getChunksInFrame()));
            } else {
                ps.println(String.format("%-5d X", iSector));
            }
            ++iSector;
        }
    }

    @Override
    @Nonnull
    public ISectorClaimToDemuxedFrame makeDemuxer() {
        return new Demuxer(this._iMaxInvFrame, this._headerFrameNumberFormat.makeFormatter(this._indexSectorFrameNumberFormat), this._iChannel, this.makeSectorRange());
    }

    public static class Demuxer
    implements IdentifiedSectorListener<SectorAceCombat3Video>,
    ISectorClaimToDemuxedFrame,
    SectorAc3VideoToDemuxedAc3Frame.Listener {
        private final int _iEndFrameNumber;
        @Nonnull
        private final IFrameNumberFormatterWithHeader _frameNumberFormatter;
        @Nonnull
        private final SectorAc3VideoToDemuxedAc3Frame _sv2f;
        @CheckForNull
        private IDemuxedFrame.Listener _listener;

        public Demuxer(int iEndFrameNumber, @Nonnull IFrameNumberFormatterWithHeader frameNumberFormatter, int iChannel, @Nonnull SectorRange sectorRange) {
            this._iEndFrameNumber = iEndFrameNumber;
            this._frameNumberFormatter = frameNumberFormatter;
            this._sv2f = new SectorAc3VideoToDemuxedAc3Frame(iChannel, sectorRange, this);
        }

        @Override
        @Nonnull
        public Class<SectorAceCombat3Video> getListeningFor() {
            return SectorAceCombat3Video.class;
        }

        @Override
        public void feedSector(@Nonnull SectorAceCombat3Video idSector, @Nonnull ILocalizedLogger log) throws LoggedFailure {
            this._sv2f.feedSector(idSector, log);
        }

        @Override
        public void endOfFeedSectors(@Nonnull ILocalizedLogger log) throws LoggedFailure {
            this._sv2f.endOfSectors(log);
        }

        @Override
        public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
            scs.addIdListener(this);
        }

        @Override
        public void setFrameListener(@Nonnull IDemuxedFrame.Listener listener) {
            this._listener = listener;
        }

        @Override
        public void frameComplete(@Nonnull DemuxedAc3Frame frame, @Nonnull ILocalizedLogger log) throws LoggedFailure {
            FrameNumber fn = this._frameNumberFormatter.next(frame.getStartSector(), this._iEndFrameNumber - frame.getInvertedHeaderFrameNumber(), log);
            frame.setFrame(fn);
            if (this._listener != null) {
                this._listener.frameComplete(frame);
            }
        }
    }
}

