/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.ac3;

import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.SectorRange;
import jpsxdec.modules.ac3.Ac3AddResult;
import jpsxdec.modules.ac3.DemuxedAc3Frame;
import jpsxdec.modules.ac3.DiscItemAceCombat3VideoStream;
import jpsxdec.modules.ac3.SectorAc3VideoToDemuxedAc3Frame;
import jpsxdec.modules.ac3.SectorAceCombat3Video;
import jpsxdec.modules.video.framenumber.HeaderFrameNumber;
import jpsxdec.modules.video.framenumber.IndexSectorFrameNumber;
import jpsxdec.modules.video.sectorbased.DiscIndexerSectorBasedVideo;
import jpsxdec.modules.video.sectorbased.SectorBasedVideoInfoBuilder;

public class DiscIndexerAceCombat3Video
extends DiscIndexerSectorBasedVideo.SubIndexer
implements IdentifiedSectorListener<SectorAceCombat3Video> {
    @Nonnull
    private final ILocalizedLogger _errLog;
    private final TreeMap<Integer, Ac3Channel> _activeStreams = new TreeMap();

    public DiscIndexerAceCombat3Video(@Nonnull ILocalizedLogger errLog) {
        this._errLog = errLog;
    }

    @Override
    @CheckForNull
    public DiscItem deserializeLineRead(@Nonnull SerializedDiscItem fields) throws LocalizedDeserializationFail {
        if ("AC3Vid".equals(fields.getType())) {
            return new DiscItemAceCombat3VideoStream(this.getCd(), fields);
        }
        return null;
    }

    @Override
    public void attachToSectorClaimer(@Nonnull SectorClaimSystem scs) {
        scs.addIdListener(this);
    }

    @Override
    public Class<SectorAceCombat3Video> getListeningFor() {
        return SectorAceCombat3Video.class;
    }

    @Override
    public void feedSector(@Nonnull SectorAceCombat3Video vidSector, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        int iChannel = vidSector.getChannel();
        Ac3Channel channel = this._activeStreams.get(iChannel);
        if (channel == null) {
            channel = new Ac3Channel(this, iChannel);
            this._activeStreams.put(iChannel, channel);
        }
        channel.feedSector(vidSector);
    }

    @Override
    public void endOfFeedSectors(ILocalizedLogger log) throws LoggedFailure {
        for (Ac3Channel channel : this._activeStreams.values()) {
            channel.endVideo();
        }
        this._activeStreams.clear();
    }

    private static class Ac3Channel
    implements SectorAc3VideoToDemuxedAc3Frame.Listener {
        @Nonnull
        private final DiscIndexerAceCombat3Video _indexer;
        @Nonnull
        private final SectorAc3VideoToDemuxedAc3Frame _sac3v2dac3frame;
        @CheckForNull
        private VidBuilder _videoBuilder;

        public Ac3Channel(@Nonnull DiscIndexerAceCombat3Video indexer, int iChannel) {
            this._indexer = indexer;
            this._sac3v2dac3frame = new SectorAc3VideoToDemuxedAc3Frame(iChannel, SectorRange.ALL, this);
        }

        public void feedSector(@Nonnull SectorAceCombat3Video vidSector) throws LoggedFailure {
            Ac3AddResult result = this._sac3v2dac3frame.feedSector(vidSector, this._indexer._errLog);
            if (result == Ac3AddResult.WrongChannel) {
                throw new RuntimeException("AC3 sector was not accepted for some reason.");
            }
        }

        @Override
        public void frameComplete(@Nonnull DemuxedAc3Frame frame, @Nonnull ILocalizedLogger log) {
            if (this._videoBuilder != null && !this._videoBuilder.addFrame(frame)) {
                this.endVideo();
            }
            if (this._videoBuilder == null) {
                this._videoBuilder = new VidBuilder(frame);
            }
        }

        public void endVideo() {
            if (this._videoBuilder == null) {
                return;
            }
            DiscItemAceCombat3VideoStream video = this._videoBuilder.endOfMovie(this._indexer.getCd());
            this._indexer.addVideo(video);
            this._videoBuilder = null;
        }
    }

    private static class VidBuilder {
        @Nonnull
        private final IndexSectorFrameNumber.Format.Builder _indexSectorFrameNumberBuilder;
        @Nonnull
        private final HeaderFrameNumber.Format.Builder _headerFrameNumberBuilder;
        @Nonnull
        private final SectorBasedVideoInfoBuilder _strInfoBuilder;
        private final int _iEndFrame;
        private final int _iChannel;
        @Nonnull
        private int _iPrevInvertedFrameNumber;

        public VidBuilder(@Nonnull DemuxedAc3Frame firstFrame) {
            this._iEndFrame = this._iPrevInvertedFrameNumber = firstFrame.getInvertedHeaderFrameNumber();
            this._strInfoBuilder = new SectorBasedVideoInfoBuilder(firstFrame.getWidth(), firstFrame.getHeight(), firstFrame.getStartSector(), firstFrame.getEndSector());
            this._iChannel = firstFrame.getChannel();
            this._indexSectorFrameNumberBuilder = new IndexSectorFrameNumber.Format.Builder(firstFrame.getStartSector());
            this._headerFrameNumberBuilder = new HeaderFrameNumber.Format.Builder(this._iEndFrame - firstFrame.getInvertedHeaderFrameNumber());
        }

        public boolean addFrame(@Nonnull DemuxedAc3Frame frame) {
            if (frame.getWidth() != this._strInfoBuilder.getWidth() || frame.getHeight() != this._strInfoBuilder.getHeight() || frame.getStartSector() > this._strInfoBuilder.getEndSector() + 100 || frame.getInvertedHeaderFrameNumber() > this._iPrevInvertedFrameNumber) {
                return false;
            }
            this._iPrevInvertedFrameNumber = frame.getInvertedHeaderFrameNumber();
            this._strInfoBuilder.next(frame.getStartSector(), frame.getEndSector());
            this._indexSectorFrameNumberBuilder.addFrameStartSector(frame.getStartSector());
            this._headerFrameNumberBuilder.addHeaderFrameNumber(this._iEndFrame - frame.getInvertedHeaderFrameNumber());
            return true;
        }

        @Nonnull
        public DiscItemAceCombat3VideoStream endOfMovie(@Nonnull CdFileSectorReader cd) {
            return new DiscItemAceCombat3VideoStream(cd, this._strInfoBuilder.getStartSector(), this._strInfoBuilder.getEndSector(), this._strInfoBuilder.makeDims(), this._indexSectorFrameNumberBuilder.makeFormat(), this._strInfoBuilder.makeStrVidInfo(), this._headerFrameNumberBuilder.makeFormat(), this._iEndFrame, this._iChannel);
        }
    }
}

