/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.ac3;

import java.io.PrintStream;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.ac3.SectorAceCombat3Video;
import jpsxdec.modules.video.IDemuxedFrame;
import jpsxdec.modules.video.framenumber.FrameNumber;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameAnalysis;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameReplace;
import jpsxdec.psxvideo.bitstreams.BitStreamAnalysis;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.util.DemuxedData;
import jpsxdec.util.Fraction;

public class DemuxedAc3Frame
implements IDemuxedFrame {
    private final int _iWidth;
    private final int _iHeight;
    private final int _iInvFrameNumber;
    private final int _iChannel;
    @Nonnull
    private final DemuxedData<SectorAceCombat3Video> _demux;
    @CheckForNull
    private FrameNumber _frameNumber;

    public DemuxedAc3Frame(int iWidth, int iHeight, int iInvFrameNumber, int iChannel, @Nonnull List<SectorAceCombat3Video> demux) {
        this._demux = new DemuxedData<SectorAceCombat3Video>(demux);
        this._iWidth = iWidth;
        this._iHeight = iHeight;
        this._iInvFrameNumber = iInvFrameNumber;
        this._iChannel = iChannel;
    }

    void setFrame(@Nonnull FrameNumber frameNumber) {
        this._frameNumber = frameNumber;
    }

    @Override
    @Nonnull
    public FrameNumber getFrame() {
        if (this._frameNumber == null) {
            throw new IllegalStateException();
        }
        return this._frameNumber;
    }

    @Override
    @CheckForNull
    public MdecInputStream getCustomFrameMdecStream() {
        return null;
    }

    @Override
    public int getWidth() {
        return this._iWidth;
    }

    @Override
    public int getHeight() {
        return this._iHeight;
    }

    @Override
    public int getStartSector() {
        return this._demux.getStartSector();
    }

    @Override
    public int getEndSector() {
        return this._demux.getEndSector();
    }

    @Override
    @Nonnull
    public Fraction getPresentationSector() {
        return new Fraction(this.getEndSector());
    }

    public int getInvertedHeaderFrameNumber() {
        return this._iInvFrameNumber;
    }

    public int getChannel() {
        return this._iChannel;
    }

    @Override
    public int getDemuxSize() {
        return this._demux.getDemuxSize();
    }

    @Override
    @Nonnull
    public byte[] copyDemuxData() {
        return this._demux.copyDemuxData();
    }

    @Override
    public void printSectors(@Nonnull PrintStream ps) {
        for (SectorAceCombat3Video vidSector : this._demux) {
            ps.println(vidSector);
        }
    }

    @Override
    public void writeToSectors(@Nonnull SectorBasedFrameAnalysis existingFrame, @Nonnull BitStreamAnalysis newFrame, @Nonnull CdFileSectorReader cd, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        SectorBasedFrameReplace.writeToSectors(existingFrame, newFrame, cd, log, this._demux);
    }

    public String toString() {
        return String.format("Inv frame %d channel %d sectors %d-%d %dx%d %d chunks %d bytes", this.getInvertedHeaderFrameNumber(), this.getChannel(), this.getStartSector(), this.getEndSector(), this.getWidth(), this.getHeight(), this._demux.getPieceCount(), this._demux.getDemuxSize());
    }
}

