/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules.ac3;

import javax.annotation.Nonnull;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.ac3.Ac3AddResult;
import jpsxdec.modules.ac3.DemuxedAc3Frame;
import jpsxdec.modules.ac3.SectorAceCombat3Video;
import jpsxdec.modules.video.sectorbased.SectorBasedFrameBuilder;

public class Ac3Demuxer {
    private final int _iWidth;
    private final int _iHeight;
    private final int _iChannel;
    @Nonnull
    private final SectorBasedFrameBuilder<SectorAceCombat3Video> _bldr;

    public Ac3Demuxer(SectorAceCombat3Video firstChunk, @Nonnull ILocalizedLogger log) {
        this._iWidth = firstChunk.getWidth();
        this._iHeight = firstChunk.getHeight();
        this._iChannel = firstChunk.getChannel();
        this._bldr = new SectorBasedFrameBuilder<SectorAceCombat3Video>(firstChunk, firstChunk.getChunkNumber(), firstChunk.getChunksInFrame(), firstChunk.getSectorNumber(), firstChunk.getInvertedFrameNumber(), log);
    }

    @Nonnull
    public Ac3AddResult addSector(@Nonnull SectorAceCombat3Video chunk) {
        boolean blnIsPartOfFrame;
        if (chunk.getChannel() != this._iChannel) {
            return Ac3AddResult.WrongChannel;
        }
        boolean bl = blnIsPartOfFrame = chunk.getWidth() == this._iWidth && chunk.getHeight() == this._iHeight && this._bldr.addSectorIfPartOfFrame(chunk, chunk.getChunkNumber(), chunk.getChunksInFrame(), chunk.getSectorNumber(), chunk.getInvertedFrameNumber());
        if (!blnIsPartOfFrame) {
            return Ac3AddResult.WrongFormat;
        }
        return Ac3AddResult.Same;
    }

    public boolean isFrameComplete() {
        return this._bldr.isFrameComplete();
    }

    @Nonnull
    public DemuxedAc3Frame finishFrame(@Nonnull ILocalizedLogger log) {
        return new DemuxedAc3Frame(this._iWidth, this._iHeight, this._bldr.getHeaderFrameNumber(), this._iChannel, this._bldr.getNonNullChunks(log));
    }
}

