/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.UnidentifiedSector;

public class UnidentifiedSectorStreamListener
implements IdentifiedSectorListener<IIdentifiedSector> {
    private final ArrayList<Listener> _listeners = new ArrayList();
    private boolean _blnInUnidentified = false;

    public static void attachToSectorClaimer(@Nonnull SectorClaimSystem scs, @Nonnull Listener listener) {
        UnidentifiedSectorStreamListener thisListener = scs.getIdListener(UnidentifiedSectorStreamListener.class);
        if (thisListener == null) {
            thisListener = new UnidentifiedSectorStreamListener();
            thisListener.addListener(listener);
            scs.addIdListener(thisListener);
        } else {
            thisListener.addListener(listener);
        }
    }

    private void addListener(@Nonnull Listener newListener) {
        for (Listener listener : this._listeners) {
            if (listener != newListener) continue;
            return;
        }
        this._listeners.add(newListener);
    }

    @Override
    @Nonnull
    public Class<IIdentifiedSector> getListeningFor() {
        return IIdentifiedSector.class;
    }

    @Override
    public void feedSector(@Nonnull IIdentifiedSector idSector, @Nonnull ILocalizedLogger log) throws LoggedFailure {
        if (!(idSector instanceof UnidentifiedSector)) {
            if (this._blnInUnidentified) {
                for (Listener listener : this._listeners) {
                    listener.endOfUnidentified();
                }
                this._blnInUnidentified = false;
            }
        } else {
            for (Listener listener : this._listeners) {
                listener.feedSector(idSector.getCdSector());
            }
            this._blnInUnidentified = true;
        }
    }

    @Override
    public void endOfFeedSectors(@Nonnull ILocalizedLogger log) throws LoggedFailure {
        for (Listener listener : this._listeners) {
            listener.endOfUnidentified();
        }
    }

    public static interface Listener {
        public void feedSector(@Nonnull CdSector var1);

        public void endOfUnidentified();
    }
}

