/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.modules.IdentifiedSector;

public class UnidentifiedSector
extends IdentifiedSector {
    public UnidentifiedSector(@Nonnull CdSector cdSector) throws IllegalArgumentException {
        super(cdSector);
        if (cdSector.isCdAudioSector()) {
            throw new IllegalArgumentException();
        }
        this.setProbability(100);
    }

    @Override
    @Nonnull
    public String getTypeName() {
        return "Unknown";
    }

    @Override
    public String toString() {
        CdSector cdSector = this.getCdSector();
        StringBuilder sb = new StringBuilder(" ");
        for (int i = 0; i < 32; ++i) {
            sb.append(String.format("%02x", cdSector.readUserDataByte(i)));
        }
        return this.getTypeName() + " " + this.cdToString() + sb;
    }
}

