/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.IdentifiedSectorListener;
import jpsxdec.modules.UnidentifiedSector;
import jpsxdec.modules.ac3.SectorClaimToSectorAc3Video;
import jpsxdec.modules.cdaudio.SectorClaimToSectorCdAudio;
import jpsxdec.modules.crusader.SectorClaimToSectorCrusader;
import jpsxdec.modules.dredd.SectorClaimToDreddFrame;
import jpsxdec.modules.eavideo.SectorClaimToEAVideo;
import jpsxdec.modules.iso9660.SectorClaimToSectorISO9660;
import jpsxdec.modules.policenauts.SectorClaimToPolicenauts;
import jpsxdec.modules.square.SectorClaimToFF7Sector;
import jpsxdec.modules.square.SectorClaimToSquareAudioSector;
import jpsxdec.modules.strvideo.SectorClaimToStrVideoSector;
import jpsxdec.modules.xa.SectorClaimToSectorXaAudio;
import jpsxdec.util.BufferedIOIterator;
import jpsxdec.util.IOIterator;

public class SectorClaimSystem {
    @Nonnull
    private final CdFileSectorReader _cd;
    @Nonnull
    private final ArrayList<SectorClaimInception> _iterators = new ArrayList();
    @Nonnull
    private final List<IdentifiedSectorListener> _idSectorListeners = new ArrayList<IdentifiedSectorListener>();
    @Nonnull
    private BufferedIOIterator<ClaimableSector> _outerMostIterator;
    @Nonnull
    private ILocalizedLogger _log;

    @Nonnull
    public static SectorClaimSystem create(@Nonnull CdFileSectorReader cd) {
        return SectorClaimSystem.create(cd, 0);
    }

    @Nonnull
    public static SectorClaimSystem create(@Nonnull CdFileSectorReader cd, int iStartSector) {
        return SectorClaimSystem.create(cd, iStartSector, cd.getSectorCount() - 1);
    }

    @Nonnull
    public static SectorClaimSystem create(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSectorInclusive) {
        SectorClaimSystem scs = new SectorClaimSystem(cd, iStartSector, iEndSectorInclusive);
        scs.addClaimer(new SectorClaimToSectorXaAudio());
        scs.addClaimer(new SectorClaimToSectorCdAudio());
        scs.addClaimer(new SectorClaimToSectorISO9660());
        scs.addClaimer(new SectorClaimToFF7Sector());
        scs.addClaimer(new SectorClaimToStrVideoSector());
        scs.addClaimer(new SectorClaimToSquareAudioSector());
        scs.addClaimer(new SectorClaimToSectorAc3Video());
        scs.addClaimer(new SectorClaimToSectorCrusader());
        scs.addClaimer(new SectorClaimToDreddFrame());
        scs.addClaimer(new SectorClaimToPolicenauts());
        scs.addClaimer(new SectorClaimToEAVideo());
        return scs;
    }

    SectorClaimSystem(@Nonnull CdFileSectorReader cd) {
        this(cd, 0, cd.getSectorCount() - 1);
    }

    private SectorClaimSystem(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSectorInclusive) {
        this._cd = cd;
        CoreSectorIterator core = new CoreSectorIterator(cd, iStartSector, iEndSectorInclusive + 1);
        this._outerMostIterator = new BufferedIOIterator<ClaimableSector>(core);
    }

    void addClaimer(@Nonnull SectorClaimer claimer) {
        SectorClaimInception wrapping = new SectorClaimInception(this._outerMostIterator, claimer);
        this._outerMostIterator = new BufferedIOIterator<ClaimableSector>(wrapping);
        this._iterators.add(wrapping);
    }

    public void addIdListener(@Nonnull IdentifiedSectorListener newListener) {
        for (IdentifiedSectorListener listener : this._idSectorListeners) {
            if (listener != newListener) continue;
            return;
        }
        this._idSectorListeners.add(newListener);
    }

    @CheckForNull
    public <T extends IdentifiedSectorListener> T getIdListener(@Nonnull Class<T> clazz) {
        for (IdentifiedSectorListener listener : this._idSectorListeners) {
            if (listener.getClass() != clazz) continue;
            return (T)listener;
        }
        return null;
    }

    @Nonnull
    public File getSourceCdFile() {
        return this._cd.getSourceFile();
    }

    public boolean hasNext() {
        return this._outerMostIterator.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public IIdentifiedSector next(@Nonnull ILocalizedLogger log) throws CdFileSectorReader.CdReadException {
        try {
            ClaimableSector next;
            this._log = log;
            try {
                next = this._outerMostIterator.next();
            }
            catch (LoggedFailureWrapper ex) {
                throw ex;
            }
            catch (IOException ex) {
                if (ex instanceof CdFileSectorReader.CdReadException) {
                    throw (CdFileSectorReader.CdReadException)ex;
                }
                throw new CdFileSectorReader.CdReadException(this.getSourceCdFile(), ex);
            }
            IIdentifiedSector idSector = next.getClaimer();
            if (idSector == null) {
                idSector = new UnidentifiedSector(next.getSector());
            }
            for (IdentifiedSectorListener listener : this._idSectorListeners) {
                try {
                    Class listeningFor = listener.getListeningFor();
                    if (listeningFor != null && !listeningFor.isInstance(idSector)) continue;
                    listener.feedSector(idSector, log);
                }
                catch (LoggedFailure ex) {
                    throw new LoggedFailureWrapper(ex);
                }
            }
            IIdentifiedSector iIdentifiedSector = idSector;
            return iIdentifiedSector;
        }
        finally {
            this._log = null;
        }
    }

    public void close(@Nonnull ILocalizedLogger log) {
        for (SectorClaimInception claimer : this._iterators) {
            try {
                claimer._claimer.endOfSectors(log);
            }
            catch (LoggedFailure ex) {
                throw new LoggedFailureWrapper(ex);
            }
        }
        for (IdentifiedSectorListener listener : this._idSectorListeners) {
            try {
                listener.endOfFeedSectors(log);
            }
            catch (LoggedFailure ex) {
                throw new LoggedFailureWrapper(ex);
            }
        }
    }

    private class SectorClaimInception
    implements IOIterator<ClaimableSector> {
        @Nonnull
        private final BufferedIOIterator<ClaimableSector> _nestedIter;
        @Nonnull
        private final SectorClaimer _claimer;

        public SectorClaimInception(@Nonnull BufferedIOIterator<ClaimableSector> nested, SectorClaimer claimer) {
            this._nestedIter = nested;
            this._claimer = claimer;
        }

        @Override
        public boolean hasNext() {
            return this._nestedIter.hasNext();
        }

        @Override
        @Nonnull
        public ClaimableSector next() throws IOException {
            BufferedIOIterator<ClaimableSector> copy = this._nestedIter.copy();
            ClaimableSector cs = copy.next();
            try {
                this._claimer.sectorRead(cs, copy, SectorClaimSystem.this._log);
            }
            catch (LoggedFailure ex) {
                throw new LoggedFailureWrapper(ex);
            }
            return this._nestedIter.next();
        }
    }

    private static class CoreSectorIterator
    implements IOIterator<ClaimableSector> {
        @Nonnull
        private final CdFileSectorReader _cd;
        private int _iSector;
        private final int _iEndSector;

        public CoreSectorIterator(@Nonnull CdFileSectorReader cd, int iStartSector, int iEndSector) {
            this._cd = cd;
            this._iSector = iStartSector;
            this._iEndSector = iEndSector;
        }

        @Override
        public boolean hasNext() {
            return this._iSector < this._iEndSector;
        }

        @Override
        @Nonnull
        public ClaimableSector next() throws IOException {
            return new ClaimableSector(new InternalSector(this._cd.getSector(this._iSector++)));
        }
    }

    private static class LoggedFailureWrapper
    extends RuntimeException {
        private final LoggedFailure _inner;

        public LoggedFailureWrapper(LoggedFailure inner) {
            super(inner);
            this._inner = inner;
        }
    }

    public static class ClaimableSector {
        @Nonnull
        private final InternalSector _inner;

        private ClaimableSector(@Nonnull InternalSector inner) {
            this._inner = inner;
        }

        @Nonnull
        public CdSector getSector() {
            return this._inner.sector;
        }

        @CheckForNull
        public IIdentifiedSector getClaimer() {
            return this._inner.claimer;
        }

        public boolean isClaimed() {
            return this._inner.claimer != null;
        }

        public void claim(@Nonnull IIdentifiedSector claimer) {
            this._inner.claimer = claimer;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._inner.sector);
            if (this._inner.claimer == null) {
                sb.append(" unclaimed");
            } else {
                sb.append(this._inner.claimer);
            }
            return sb.toString();
        }
    }

    private static class InternalSector {
        @Nonnull
        public final CdSector sector;
        @CheckForNull
        public IIdentifiedSector claimer;

        public InternalSector(CdSector sector) {
            this.sector = sector;
        }
    }

    public static interface SectorClaimer {
        public void sectorRead(@Nonnull ClaimableSector var1, @Nonnull IOIterator<ClaimableSector> var2, @Nonnull ILocalizedLogger var3) throws IOException, LoggedFailure;

        public void endOfSectors(@Nonnull ILocalizedLogger var1) throws LoggedFailure;
    }
}

