/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorXaSubHeader;
import jpsxdec.modules.IIdentifiedSector;

public abstract class IdentifiedSector
implements IIdentifiedSector {
    @Nonnull
    private final CdSector _sourceCdSector;
    private int _iProbability = 1;

    protected final boolean subModeExistsAndMaskEquals(int iMask, int iExpected) {
        CdSectorXaSubHeader sh = this._sourceCdSector.getSubHeader();
        if (sh == null) {
            return false;
        }
        return sh.getSubMode().mask(iMask) == iExpected;
    }

    protected final boolean subModeExistsAndMaskDoesNotEqual(int iMask, int iExpected) {
        CdSectorXaSubHeader sh = this._sourceCdSector.getSubHeader();
        if (sh == null) {
            return false;
        }
        return sh.getSubMode().mask(iMask) != iExpected;
    }

    public IdentifiedSector(@Nonnull CdSector cdSector) {
        this._sourceCdSector = cdSector;
    }

    protected final boolean isSuperInvalidElseReset() {
        if (this._iProbability == 0) {
            return true;
        }
        this._iProbability = 0;
        return false;
    }

    protected final void setProbability(int iProbability) {
        this._iProbability = iProbability;
    }

    @Override
    public final int getProbability() {
        return this._iProbability;
    }

    public String toString() {
        return this._sourceCdSector.toString();
    }

    @Override
    public int getSectorNumber() {
        return this._sourceCdSector.getSectorIndexFromStart();
    }

    @Override
    @Nonnull
    public final CdSector getCdSector() {
        return this._sourceCdSector;
    }

    protected final String cdToString() {
        return this._sourceCdSector.toString();
    }
}

