/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.modules;

import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.util.DemuxedData;

public class CdSectorDemuxPiece
implements DemuxedData.Piece {
    @Nonnull
    private final CdSector _sector;
    private final int _iStartOffset;
    private final int _iEndOffset;

    public CdSectorDemuxPiece(@Nonnull CdSector sector) {
        this(sector, 0, sector.getCdUserDataSize());
    }

    public CdSectorDemuxPiece(@Nonnull CdSector sector, int iStartOffset) {
        this(sector, iStartOffset, sector.getCdUserDataSize());
    }

    public CdSectorDemuxPiece(@Nonnull CdSector sector, int iStartOffset, int iEndOffset) {
        if (iStartOffset < 0 || iEndOffset > sector.getCdUserDataSize()) {
            throw new IllegalArgumentException();
        }
        this._sector = sector;
        this._iStartOffset = iStartOffset;
        this._iEndOffset = iEndOffset;
    }

    @Override
    public int getDemuxPieceSize() {
        return this._iEndOffset - this._iStartOffset;
    }

    @Override
    public byte getDemuxPieceByte(int i) {
        if (i < 0 || this._iStartOffset + i >= this._iEndOffset) {
            throw new IndexOutOfBoundsException();
        }
        return this._sector.readUserDataByte(this._iStartOffset + i);
    }

    @Override
    public void copyDemuxPieceData(@Nonnull byte[] abOut, int iOutPos) {
        this._sector.getCdUserDataCopy(this._iStartOffset, abOut, iOutPos, this.getDemuxPieceSize());
    }

    @Override
    public int getSectorNumber() {
        return this._sector.getSectorIndexFromStart();
    }

    @Nonnull
    public CdSector getSector() {
        return this._sector;
    }

    public String toString() {
        return String.format("%d-%d %s", this._iStartOffset, this._iEndOffset, this._sector);
    }
}

