/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.iso9660;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import jpsxdec.iso9660.DateAndTimeFormat;
import jpsxdec.iso9660.DirectoryRecord;
import jpsxdec.iso9660.ISO9660Struct;
import jpsxdec.util.BinaryDataNotRecognized;

public class VolumePrimaryDescriptor
extends ISO9660Struct {
    public final String system_id;
    public final String volume_id;
    public final long volume_space_size;
    public final long path_table_size;
    public final long type_l_path_table;
    public final long opt_type_l_path_table;
    public final long type_m_path_table;
    public final long opt_type_m_path_table;
    public final DirectoryRecord root_directory_record;
    public final String volume_set_id;
    public final String publisher_id;
    public final String preparer_id;
    public final String application_id;
    public final String copyright_file_id;
    public final String abstract_file_id;
    public final String bibliographic_file_id;
    public final DateAndTimeFormat creation_date;
    public final DateAndTimeFormat modification_date;
    public final DateAndTimeFormat expiration_date;
    public final DateAndTimeFormat effective_date;
    public final byte[] application_data;

    public VolumePrimaryDescriptor(@Nonnull InputStream is) throws EOFException, IOException, BinaryDataNotRecognized {
        VolumePrimaryDescriptor.magic1(is, 1);
        VolumePrimaryDescriptor.magicS(is, "CD001");
        VolumePrimaryDescriptor.magic1(is, 1);
        VolumePrimaryDescriptor.magic1(is, 0);
        this.system_id = VolumePrimaryDescriptor.readS(is, 32);
        this.volume_id = VolumePrimaryDescriptor.readS(is, 32);
        VolumePrimaryDescriptor.magicXzero(is, 8);
        this.volume_space_size = VolumePrimaryDescriptor.read8_bothendian(is);
        VolumePrimaryDescriptor.magicXzero(is, 32);
        VolumePrimaryDescriptor.magic4_bothendian(is, 1);
        VolumePrimaryDescriptor.magic4_bothendian(is, 1);
        VolumePrimaryDescriptor.magic4_bothendian(is, 2048);
        this.path_table_size = VolumePrimaryDescriptor.read8_bothendian(is);
        this.type_l_path_table = VolumePrimaryDescriptor.read4_LE(is);
        this.opt_type_l_path_table = VolumePrimaryDescriptor.read4_LE(is);
        this.type_m_path_table = VolumePrimaryDescriptor.read4_BE(is);
        this.opt_type_m_path_table = VolumePrimaryDescriptor.read4_BE(is);
        this.root_directory_record = new DirectoryRecord(is);
        this.volume_set_id = VolumePrimaryDescriptor.readS(is, 128);
        this.publisher_id = VolumePrimaryDescriptor.readS(is, 128);
        this.preparer_id = VolumePrimaryDescriptor.readS(is, 128);
        this.application_id = VolumePrimaryDescriptor.readS(is, 128);
        this.copyright_file_id = VolumePrimaryDescriptor.readS(is, 37);
        this.abstract_file_id = VolumePrimaryDescriptor.readS(is, 37);
        this.bibliographic_file_id = VolumePrimaryDescriptor.readS(is, 37);
        this.creation_date = new DateAndTimeFormat(is);
        this.modification_date = new DateAndTimeFormat(is);
        this.expiration_date = new DateAndTimeFormat(is);
        this.effective_date = new DateAndTimeFormat(is);
        VolumePrimaryDescriptor.magic1(is, 1);
        VolumePrimaryDescriptor.magic1(is, 0);
        this.application_data = VolumePrimaryDescriptor.readX(is, 512);
    }

    public String toString() {
        return this.system_id.trim() + " " + this.volume_id.trim();
    }
}

