/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.iso9660;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import jpsxdec.iso9660.ISO9660Struct;
import jpsxdec.util.BinaryDataNotRecognized;

public class PathTableRecordBE
extends ISO9660Struct {
    private static final String VALID_CHARACTERS = "[A-Z\\d-_\\.]+";
    public final int index;
    public final long extent;
    public final int parent;
    public final String name;

    public PathTableRecordBE(@Nonnull InputStream is, int index) throws IOException, BinaryDataNotRecognized {
        this.index = index;
        int name_len = PathTableRecordBE.read1(is);
        if (name_len == 0) {
            throw new BinaryDataNotRecognized();
        }
        PathTableRecordBE.magic1(is, 0);
        this.extent = PathTableRecordBE.read4_BE(is);
        if (this.extent < 1L) {
            throw new BinaryDataNotRecognized();
        }
        this.parent = PathTableRecordBE.read2_BE(is);
        if (this.parent < 1) {
            throw new BinaryDataNotRecognized();
        }
        this.name = PathTableRecordBE.readS(is, name_len);
        PathTableRecordBE.magicXzero(is, name_len % 2);
        if (!this.name.matches(VALID_CHARACTERS)) {
            throw new BinaryDataNotRecognized();
        }
    }

    public String toString() {
        return this.name;
    }
}

