/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.iso9660;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;

public abstract class ISO9660Struct {
    protected static final String SEPARATOR1 = Character.toString('.');
    protected static final String SEPARATOR2 = Character.toString(';');

    protected static void magic4_bothendian(@Nonnull InputStream is, int i) throws EOFException, IOException, BinaryDataNotRecognized {
        if (ISO9660Struct.read4_bothendian(is) != i) {
            throw new BinaryDataNotRecognized();
        }
    }

    protected static int read4_bothendian(@Nonnull InputStream is) throws EOFException, IOException, BinaryDataNotRecognized {
        byte[] ab = ISO9660Struct.readX(is, 4);
        if (ab[0] != ab[3] || ab[1] != ab[2]) {
            throw new BinaryDataNotRecognized();
        }
        return (ab[2] & 0xFF) << 8 | ab[3] & 0xFF;
    }

    protected static void magic8_bothendian(@Nonnull InputStream is, long i) throws EOFException, IOException, BinaryDataNotRecognized {
        if (ISO9660Struct.read8_bothendian(is) != i) {
            throw new BinaryDataNotRecognized();
        }
    }

    protected static long read8_bothendian(@Nonnull InputStream is) throws EOFException, IOException, BinaryDataNotRecognized {
        long i = ISO9660Struct.read4_LE(is);
        if (i != ISO9660Struct.read4_BE(is)) {
            throw new BinaryDataNotRecognized();
        }
        return i;
    }

    protected static void magicX(@Nonnull InputStream is, byte[] ab) throws EOFException, IOException, BinaryDataNotRecognized {
        for (int i = 0; i < ab.length; ++i) {
            int b = is.read();
            if (b < 0) {
                throw new EOFException();
            }
            if (ab[i] == b) continue;
            throw new BinaryDataNotRecognized();
        }
    }

    protected static void magicS(@Nonnull InputStream is, String s) throws EOFException, IOException, BinaryDataNotRecognized {
        ISO9660Struct.magicX(is, Misc.stringToAscii(s));
    }

    protected static String readS(@Nonnull InputStream is, int i) throws EOFException, IOException {
        return Misc.asciiToString(ISO9660Struct.readX(is, i));
    }

    protected static int read1(@Nonnull InputStream is) throws EOFException, IOException {
        int i = is.read();
        if (i < 0) {
            throw new EOFException();
        }
        return i;
    }

    protected static void magic1(@Nonnull InputStream is, int b) throws EOFException, IOException, BinaryDataNotRecognized {
        int i = ISO9660Struct.read1(is);
        if (i != b) {
            throw new BinaryDataNotRecognized();
        }
    }

    protected static byte[] readX(@Nonnull InputStream is, int i) throws EOFException, IOException {
        if (i == 0) {
            return new byte[0];
        }
        return IO.readByteArray(is, i);
    }

    protected static void magicXzero(@Nonnull InputStream is, int iCount) throws EOFException, IOException, BinaryDataNotRecognized {
        for (int i = 0; i < iCount; ++i) {
            int b = is.read();
            if (b < 0) {
                throw new EOFException();
            }
            if (b == 0) continue;
            throw new BinaryDataNotRecognized();
        }
    }

    protected static void magic4_LE(@Nonnull InputStream is, long i) throws EOFException, IOException, BinaryDataNotRecognized {
        if (i != ISO9660Struct.read4_LE(is)) {
            throw new BinaryDataNotRecognized();
        }
    }

    protected static void magic4_BE(@Nonnull InputStream is, long i) throws IOException, BinaryDataNotRecognized {
        if (i != ISO9660Struct.read4_BE(is)) {
            throw new BinaryDataNotRecognized();
        }
    }

    protected static long read4_LE(@Nonnull InputStream is) throws EOFException, IOException {
        return IO.readUInt32LE(is);
    }

    protected static long read4_BE(@Nonnull InputStream is) throws EOFException, IOException {
        return IO.readUInt32BE(is);
    }

    protected static int read2_BE(@Nonnull InputStream is) throws EOFException, IOException {
        return IO.readUInt16BE(is);
    }
}

