/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.iso9660;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import jpsxdec.iso9660.ISO9660Struct;
import jpsxdec.iso9660.RecordingDateAndTime;
import jpsxdec.util.BinaryDataNotRecognized;

public class DirectoryRecord
extends ISO9660Struct {
    public final long extent;
    public final long size;
    public final RecordingDateAndTime date;
    public final int flags;
    public final String name;
    public static final String CURRENT_DIRECTORY = ".";
    public static final String PARENT_DIRECTORY = "..";

    public DirectoryRecord(@Nonnull InputStream is) throws EOFException, IOException, BinaryDataNotRecognized {
        int length = DirectoryRecord.read1(is);
        if (length < 1) {
            throw new BinaryDataNotRecognized();
        }
        DirectoryRecord.magic1(is, 0);
        this.extent = DirectoryRecord.read8_bothendian(is);
        this.size = DirectoryRecord.read8_bothendian(is);
        this.date = new RecordingDateAndTime(is);
        this.flags = DirectoryRecord.read1(is);
        if ((this.flags & 2) != 0 && this.size % 2048L != 0L) {
            throw new BinaryDataNotRecognized();
        }
        DirectoryRecord.magic1(is, 0);
        DirectoryRecord.magic1(is, 0);
        DirectoryRecord.magic4_bothendian(is, 1);
        int name_len = DirectoryRecord.read1(is);
        this.name = DirectoryRecord.sanitizeFileOrDirName(DirectoryRecord.readS(is, name_len));
        byte[] name_extra = DirectoryRecord.readX(is, length - 33 - name_len);
    }

    public String toString() {
        return "'" + this.name + "' " + this.size + " bytes " + this.date;
    }

    private static String sanitizeFileOrDirName(String s) {
        if ("\u0000".equals(s)) {
            return CURRENT_DIRECTORY;
        }
        if ("\u0001".equals(s)) {
            return PARENT_DIRECTORY;
        }
        if (s.endsWith(SEPARATOR2 + "1")) {
            s = s.substring(0, s.length() - 2);
        }
        if (s.endsWith(SEPARATOR1)) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static final class FileFlags {
        public static final int Existence = 1;
        public static final int Directory = 2;
        public static final int AssociatedFile = 4;
        public static final int Record = 8;
        public static final int Protection = 16;
        public static final int Reserved1 = 32;
        public static final int Reserved2 = 64;
        public static final int MultiExtent = 128;
    }
}

