/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.indexing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.crusader.DiscIndexerCrusader;
import jpsxdec.modules.eavideo.DiscIndexerEAVideo;
import jpsxdec.modules.iso9660.DiscIndexerISO9660;
import jpsxdec.modules.policenauts.DiscIndexerPolicenauts;
import jpsxdec.modules.square.DiscIndexerSquareAudio;
import jpsxdec.modules.tim.DiscIndexerTim;
import jpsxdec.modules.video.sectorbased.DiscIndexerSectorBasedVideo;
import jpsxdec.modules.xa.DiscIndexerXaAudio;

public abstract class DiscIndexer {
    private static final Logger LOG = Logger.getLogger(DiscIndexer.class.getName());
    @CheckForNull
    private Collection<DiscItem> _mediaList;
    @CheckForNull
    private CdFileSectorReader _sourceCd;

    @Nonnull
    public static List<DiscIndexer> createIndexers(@Nonnull ILocalizedLogger log) {
        DiscIndexer[] coreIndexers = new DiscIndexer[]{new DiscIndexerISO9660(log), new DiscIndexerSquareAudio(log), new DiscIndexerTim(), new DiscIndexerSectorBasedVideo(log), new DiscIndexerXaAudio(log), new DiscIndexerPolicenauts(), new DiscIndexerCrusader(log), new DiscIndexerEAVideo()};
        ArrayList<DiscIndexer> indexers = new ArrayList<DiscIndexer>(Arrays.asList(coreIndexers));
        return indexers;
    }

    final void indexInit(@Nonnull Collection<DiscItem> items, @Nonnull CdFileSectorReader cd) {
        this._mediaList = items;
        this._sourceCd = cd;
    }

    protected final void addDiscItem(@Nonnull DiscItem discItem) {
        LOG.log(Level.INFO, "Adding disc item {0}", discItem);
        this._mediaList.add(discItem);
    }

    @Nonnull
    protected final CdFileSectorReader getCd() {
        if (this._sourceCd == null) {
            throw new IllegalStateException("CD should have been set before use");
        }
        return this._sourceCd;
    }

    public abstract void attachToSectorClaimer(@Nonnull SectorClaimSystem var1);

    @CheckForNull
    public abstract DiscItem deserializeLineRead(@Nonnull SerializedDiscItem var1) throws LocalizedDeserializationFail;

    public abstract void listPostProcessing(@Nonnull Collection<DiscItem> var1);

    public abstract boolean filterChild(@CheckForNull DiscItem var1, @Nonnull DiscItem var2);

    public abstract void indexGenerated(@Nonnull DiscIndex var1);
}

