/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.indexing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.cdreaders.CdSector;
import jpsxdec.cdreaders.CdSectorHeader;
import jpsxdec.cmdline.SectorCounter;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.IndexId;
import jpsxdec.discitems.SerializedDiscItem;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.indexing.DiscIndexer;
import jpsxdec.modules.IIdentifiedSector;
import jpsxdec.modules.SectorClaimSystem;
import jpsxdec.modules.iso9660.DiscItemISO9660File;
import jpsxdec.modules.sharedaudio.DiscItemAudioStream;
import jpsxdec.modules.strvideo.DiscItemStrVideoStream;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;
import jpsxdec.util.TaskCanceledException;

public class DiscIndex
implements Iterable<DiscItem> {
    private static final Logger LOG = Logger.getLogger(DiscIndex.class.getName());
    private static final String COMMENT_LINE_START = ";";
    @Nonnull
    private final CdFileSectorReader _sourceCD;
    @CheckForNull
    private String _sDiscName = null;
    @Nonnull
    private final ArrayList<DiscItem> _root;
    private final List<DiscItem> _iterate = new LinkedList<DiscItem>();
    private final LinkedHashMap<Object, DiscItem> _lookup = new LinkedHashMap();
    private final Comparator<DiscItem> SORT_BY_SECTOR_HIERARHCY = new Comparator<DiscItem>(){

        @Override
        public int compare(DiscItem o1, DiscItem o2) {
            if (o1.getClass() == o2.getClass()) {
                return o1.compareTo(o2);
            }
            if (o1.getStartSector() < o2.getStartSector()) {
                return -1;
            }
            if (o1.getStartSector() > o2.getStartSector()) {
                return 1;
            }
            if (DiscIndex.typeHierarchyLevel(o1) < DiscIndex.typeHierarchyLevel(o2)) {
                return -1;
            }
            if (DiscIndex.typeHierarchyLevel(o1) > DiscIndex.typeHierarchyLevel(o2)) {
                return 1;
            }
            return Misc.intCompare(o2.getEndSector(), o1.getEndSector());
        }
    };

    public DiscIndex(@Nonnull CdFileSectorReader cdReader, @Nonnull ProgressLogger pl) throws TaskCanceledException {
        this._sourceCD = cdReader;
        if (!this._sourceCD.hasSectorHeader()) {
            pl.log(Level.WARNING, I.GUI_DISC_NO_RAW_HEADERS_WARNING());
        }
        List<DiscIndexer> indexers = DiscIndexer.createIndexers(pl);
        for (DiscIndexer indexer : indexers) {
            indexer.indexInit(this._iterate, this._sourceCD);
        }
        SectorHeaderChecker headerChecker = new SectorHeaderChecker(pl);
        int iEndSector = cdReader.getSectorCount() - 1;
        pl.progressStart(iEndSector);
        SectorClaimSystem sectorIter = SectorClaimSystem.create(cdReader);
        for (DiscIndexer indexer : indexers) {
            indexer.attachToSectorClaimer(sectorIter);
        }
        long lngStart = System.currentTimeMillis();
        SectorCounter sectorCounter = new SectorCounter();
        try {
            while (sectorIter.hasNext()) {
                IIdentifiedSector idSector = sectorIter.next(pl);
                headerChecker.indexingSectorRead(idSector.getCdSector());
                sectorCounter.increment(idSector);
                int iSector = idSector.getSectorNumber();
                pl.progressUpdate(iSector);
                if (!pl.isSeekingEvent()) continue;
                pl.event(I.INDEX_SECTOR_ITEM_PROGRESS(iSector, iEndSector, this._iterate.size()));
            }
            sectorIter.close(pl);
        }
        catch (CdFileSectorReader.CdReadException ex) {
            pl.log(Level.SEVERE, I.IO_READING_FROM_FILE_ERROR_NAME(ex.getFile().toString()), ex);
        }
        for (DiscIndexer indexer : indexers) {
            indexer.listPostProcessing(this._iterate);
        }
        Collections.sort(this._iterate, this.SORT_BY_SECTOR_HIERARHCY);
        this._root = DiscIndex.buildTree(this._iterate, indexers);
        int iIndex = 0;
        for (DiscItem item : this._iterate) {
            item.setIndex(iIndex);
            ++iIndex;
            this.addLookupItem(item);
        }
        for (DiscIndexer indexer : indexers) {
            indexer.indexGenerated(this);
        }
        if (pl.isSeekingEvent()) {
            pl.event(I.INDEX_SECTOR_ITEM_PROGRESS(iEndSector, iEndSector, this._iterate.size()));
        }
        long lngEnd = System.currentTimeMillis();
        pl.log(Level.INFO, I.PROCESS_TIME((double)(lngEnd - lngStart) / 1000.0));
        pl.progressEnd();
        for (Map.Entry entry : sectorCounter) {
            String sLog = (String)entry.getKey() + " " + entry.getValue();
            System.out.println(sLog);
            LOG.info(sLog);
        }
    }

    @Nonnull
    private static ArrayList<DiscItem> buildTree(@Nonnull Collection<DiscItem> allItems, @Nonnull Collection<DiscIndexer> indexers) {
        ArrayList<DiscItem> rootItems = new ArrayList<DiscItem>();
        Iterator<DiscItem> iterator = allItems.iterator();
        block0: while (iterator.hasNext()) {
            DiscItem child = iterator.next();
            DiscItem bestParent = null;
            int iBestParentRating = 0;
            for (DiscItem parent : allItems) {
                int iRating = parent.getParentRating(child);
                if (iRating <= iBestParentRating) continue;
                bestParent = parent;
                iBestParentRating = iRating;
            }
            for (DiscIndexer indexer : indexers) {
                if (!indexer.filterChild(bestParent, child)) continue;
                LOG.log(Level.INFO, "Filtered child item {0}", child);
                iterator.remove();
                continue block0;
            }
            if (bestParent == null) {
                rootItems.add(child);
                continue;
            }
            if (bestParent.addChild(child)) continue;
            throw new RuntimeException(bestParent + " should have accepted " + child);
        }
        IndexId id = new IndexId(0);
        for (DiscItem item : rootItems) {
            if (!item.setIndexId(id)) continue;
            id = id.createNext();
        }
        return rootItems;
    }

    private static int typeHierarchyLevel(@Nonnull DiscItem item) {
        if (item instanceof DiscItemISO9660File) {
            return 1;
        }
        if (item instanceof DiscItemStrVideoStream) {
            return 2;
        }
        if (item instanceof DiscItemAudioStream) {
            return 3;
        }
        return 4;
    }

    public DiscIndex(@Nonnull String sIndexFile, @Nonnull ILocalizedLogger errLog) throws IndexNotFoundException, IndexReadException, LocalizedDeserializationFail, CdFileSectorReader.CdFileNotFoundException, CdFileSectorReader.CdReadException {
        this(sIndexFile, null, errLog);
    }

    public DiscIndex(@Nonnull String sIndexFile, boolean blnAllowWrites, @Nonnull ILocalizedLogger errLog) throws IndexNotFoundException, IndexReadException, LocalizedDeserializationFail, CdFileSectorReader.CdFileNotFoundException, CdFileSectorReader.CdReadException {
        this(sIndexFile, null, blnAllowWrites, errLog);
    }

    public DiscIndex(@Nonnull String sIndexFile, @CheckForNull CdFileSectorReader cdReader, @Nonnull ILocalizedLogger errLog) throws IndexNotFoundException, IndexReadException, LocalizedDeserializationFail, CdFileSectorReader.CdFileNotFoundException, CdFileSectorReader.CdReadException {
        this(sIndexFile, cdReader, false, errLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscIndex(@Nonnull String sIndexFile, @CheckForNull CdFileSectorReader cdReader, boolean blnAllowWrites, @Nonnull ILocalizedLogger errLog) throws IndexNotFoundException, IndexReadException, LocalizedDeserializationFail, CdFileSectorReader.CdFileNotFoundException, CdFileSectorReader.CdReadException {
        FileInputStream fis;
        File indexFile = new File(sIndexFile);
        try {
            fis = new FileInputStream(indexFile);
        }
        catch (FileNotFoundException ex) {
            throw new IndexNotFoundException(indexFile, ex);
        }
        String sSourceCdLine = null;
        ArrayList<String> serializedLines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
        try {
            String sLine;
            try {
                sLine = reader.readLine();
            }
            catch (IOException ex) {
                throw new IndexReadException(indexFile, ex);
            }
            if (!"[jPSXdec v1.05 (beta)]".equals(sLine)) {
                throw new LocalizedDeserializationFail(I.INDEX_HEADER_MISSING());
            }
            while (true) {
                try {
                    sLine = reader.readLine();
                }
                catch (IOException ex) {
                    throw new IndexReadException(indexFile, ex);
                }
                if (sLine == null) {
                    break;
                }
                if (sLine.startsWith(COMMENT_LINE_START) || sLine.matches("^\\s*$")) continue;
                if (sLine.startsWith("Filename:")) {
                    if (sSourceCdLine != null) {
                        throw new LocalizedDeserializationFail(I.INDEX_MULTIPLE_CD("Filename:"));
                    }
                    sSourceCdLine = sLine;
                    continue;
                }
                serializedLines.add(sLine);
            }
        }
        finally {
            IO.closeSilently(reader, LOG);
        }
        if (sSourceCdLine == null) {
            throw new LocalizedDeserializationFail(I.INDEX_NO_CD("Filename:"));
        }
        if (cdReader != null) {
            if (!cdReader.matchesSerialization(sSourceCdLine)) {
                errLog.log(Level.WARNING, I.CD_FORMAT_MISMATCH(cdReader.serialize(), sSourceCdLine));
            }
            this._sourceCD = cdReader;
        } else {
            this._sourceCD = CdFileSectorReader.deserialize(sSourceCdLine, blnAllowWrites);
        }
        boolean blnExceptionThrown = true;
        try {
            List<DiscIndexer> indexers = DiscIndexer.createIndexers(errLog);
            for (DiscIndexer indexer : indexers) {
                indexer.indexInit(this._iterate, this._sourceCD);
            }
            for (String sItemLine : serializedLines) {
                SerializedDiscItem deserializedLine;
                try {
                    deserializedLine = new SerializedDiscItem(sItemLine);
                }
                catch (LocalizedDeserializationFail ex) {
                    errLog.log(Level.WARNING, I.INDEX_PARSE_LINE_FAIL(sItemLine, ex.getSourceMessage()), ex);
                    continue;
                }
                boolean blnLineHandled = false;
                for (DiscIndexer indexer : indexers) {
                    try {
                        DiscItem item = indexer.deserializeLineRead(deserializedLine);
                        if (item == null) continue;
                        blnLineHandled = true;
                        if (item.notEntirelyInCd()) {
                            errLog.log(Level.SEVERE, I.NOT_CONTAINED_IN_DISC(item.getIndexId().toString()));
                        }
                        this._iterate.add(item);
                    }
                    catch (LocalizedDeserializationFail ex) {
                        errLog.log(Level.WARNING, I.INDEX_PARSE_LINE_FAIL(sItemLine, ex.getSourceMessage()), ex);
                        blnLineHandled = true;
                    }
                }
                if (blnLineHandled) continue;
                errLog.log(Level.WARNING, I.INDEX_UNHANDLED_LINE(sItemLine));
            }
            this._root = DiscIndex.recreateTree(this._iterate, errLog);
            for (DiscItem item : this._iterate) {
                this.addLookupItem(item);
            }
            for (DiscIndexer indexer : indexers) {
                indexer.indexGenerated(this);
            }
            if (LOG.isLoggable(Level.FINE)) {
                for (DiscItem item : this) {
                    LOG.fine(item.toString());
                }
            }
            blnExceptionThrown = false;
        }
        finally {
            if (blnExceptionThrown && cdReader == null) {
                IO.closeSilently(this._sourceCD, LOG);
            }
        }
    }

    @Nonnull
    private static ArrayList<DiscItem> recreateTree(@Nonnull Collection<DiscItem> allItems, @Nonnull ILocalizedLogger log) {
        ArrayList<DiscItem> rootItems = new ArrayList<DiscItem>();
        block0: for (DiscItem child : allItems) {
            IndexId itemId = child.getIndexId();
            if (itemId.isRoot()) {
                rootItems.add(child);
                continue;
            }
            for (DiscItem possibleParent : allItems) {
                if (possibleParent == child || !itemId.isParent(possibleParent.getIndexId())) continue;
                if (possibleParent.addChild(child)) continue block0;
                log.log(Level.WARNING, I.INDEX_INCONSTSTENCIES());
                LOG.log(Level.WARNING, "{0} rejected {1}", new Object[]{possibleParent, child});
                continue block0;
            }
            rootItems.add(child);
        }
        return rootItems;
    }

    private void addLookupItem(@Nonnull DiscItem item) {
        this._lookup.put(item.getIndex(), item);
        this._lookup.put(item.getIndexId().serialize(), item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeIndex(@Nonnull File file) throws FileNotFoundException {
        PrintStream ps;
        try {
            ps = new PrintStream(file, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Every implementation of the Java platform is required to support UTF-8", ex);
        }
        try {
            this.serializeIndex(ps);
        }
        finally {
            ps.close();
        }
    }

    private void serializeIndex(@Nonnull PrintStream ps) {
        ps.println("[jPSXdec v1.05 (beta)]");
        ps.println(I.INDEX_COMMENT(COMMENT_LINE_START));
        ps.println(this._sourceCD.serialize());
        for (DiscItem item : this) {
            ps.println(item.serialize().serialize());
        }
    }

    public void setDiscName(@Nonnull String sName) {
        this._sDiscName = sName;
    }

    @Nonnull
    public List<DiscItem> getRoot() {
        return this._root;
    }

    @CheckForNull
    public DiscItem getByIndex(int iIndex) {
        return this._lookup.get(iIndex);
    }

    @CheckForNull
    public DiscItem getById(@Nonnull String sId) {
        return this._lookup.get(sId);
    }

    public boolean hasIndex(int iIndex) {
        return this._lookup.containsKey(iIndex);
    }

    @Nonnull
    public CdFileSectorReader getSourceCd() {
        return this._sourceCD;
    }

    public int size() {
        return this._iterate.size();
    }

    @Override
    @Nonnull
    public Iterator<DiscItem> iterator() {
        return this._iterate.iterator();
    }

    public String toString() {
        return String.format("%s (%s) %d items", this._sourceCD.getSourceFile(), this._sDiscName, this._iterate.size());
    }

    private static class SectorHeaderChecker {
        @Nonnull
        private final ILocalizedLogger _log;
        private int _iCurrentHeaderSectorNumber = -1;
        private int _iMode1Count = 0;
        private int _iMode2Count = 0;

        public SectorHeaderChecker(@Nonnull ProgressLogger pl) {
            this._log = pl;
        }

        public void indexingSectorRead(@Nonnull CdSector cdSector) {
            CdSectorHeader h;
            if (cdSector.hasHeaderErrors()) {
                this._log.log(Level.WARNING, I.INDEX_SECTOR_CORRUPTED(cdSector.getSectorIndexFromStart()));
            }
            if ((h = cdSector.getHeader()) != null) {
                int iNewSectNumber = h.calculateSectorNumber();
                if (iNewSectNumber != -1) {
                    if (this._iCurrentHeaderSectorNumber >= 0 && this._iCurrentHeaderSectorNumber + 1 != iNewSectNumber) {
                        this._log.log(Level.WARNING, I.INDEX_SECTOR_CORRUPTED_AT(cdSector.getSectorIndexFromStart()));
                        LOG.log(Level.WARNING, "Non-continuous sector header number: {0} -> {1}", new Object[]{this._iCurrentHeaderSectorNumber, iNewSectNumber});
                    }
                    this._iCurrentHeaderSectorNumber = iNewSectNumber;
                } else {
                    this._iCurrentHeaderSectorNumber = -1;
                }
            } else {
                this._iCurrentHeaderSectorNumber = -1;
            }
            switch (cdSector.getType()) {
                case MODE1: {
                    if (this._iMode1Count < this._iMode2Count) {
                        this._log.log(Level.WARNING, I.INDEX_SECTOR_CORRUPTED_AT(cdSector.getSectorIndexFromStart()));
                        LOG.log(Level.WARNING, "Sector {0} is Mode 1 found among Mode 2 sectors", new Object[]{cdSector.getSectorIndexFromStart()});
                    }
                    ++this._iMode1Count;
                    break;
                }
                case UNKNOWN2048: 
                case MODE2FORM1: 
                case MODE2FORM2: {
                    ++this._iMode2Count;
                    break;
                }
            }
        }
    }

    public static class IndexReadException
    extends IOException {
        @Nonnull
        private final File _file;

        public IndexReadException(@Nonnull File file, IOException ex) {
            super(ex);
            this._file = file;
        }

        @Nonnull
        public File getFile() {
            return this._file;
        }
    }

    public static class IndexNotFoundException
    extends FileNotFoundException {
        @Nonnull
        private final File _file;

        public IndexNotFoundException(@Nonnull File file, FileNotFoundException ex) {
            super(file.getPath());
            this.initCause(ex);
            this._file = file;
        }

        @Nonnull
        public File getFile() {
            return this._file;
        }
    }
}

