/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.i18n.log;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.log.ILocalizedLogger;
import jpsxdec.util.Misc;

public class UserFriendlyLogger
implements ILocalizedLogger,
Closeable {
    private static final Logger LOG = Logger.getLogger(UserFriendlyLogger.class.getName());
    private final DateFormat _dateFormat = DateFormat.getDateTimeInstance();
    @CheckForNull
    private File _file;
    @CheckForNull
    private PrintStream _logStream;
    @Nonnull
    private final String _sBaseName;
    @Nonnull
    private final Logger _javaLogger;
    @CheckForNull
    private OnWarnErr _listener;

    public UserFriendlyLogger(@Nonnull String sBaseName) {
        this._sBaseName = sBaseName;
        this._javaLogger = Logger.getLogger(this._sBaseName);
    }

    public UserFriendlyLogger(@Nonnull String sBaseName, @Nonnull PrintStream ps) {
        this(sBaseName);
        this._logStream = ps;
    }

    public void setListener(@CheckForNull OnWarnErr listener) {
        this._listener = listener;
    }

    @Nonnull
    public String getFileName() {
        if (this._file == null) {
            if (this._logStream == System.out) {
                return "<stdout>";
            }
            if (this._logStream == System.err) {
                return "<stderr>";
            }
            return "<stream>";
        }
        return this._file.toString();
    }

    @Override
    public void log(Level level, @Nonnull ILocalizedMessage msg) {
        this.log(level, msg, null);
    }

    @Override
    public void log(Level level, @Nonnull ILocalizedMessage msg, @CheckForNull Throwable debugException) {
        msg.logEnglish(this._javaLogger, level, debugException);
        if (this._logStream == null) {
            this.openOutputFile();
        }
        if (level == Level.WARNING) {
            if (this._listener != null) {
                this._listener.onWarn(msg);
            }
        } else if (level == Level.SEVERE && this._listener != null) {
            this._listener.onErr(msg);
        }
        this._logStream.println(I.USER_LOG_MESSAGE(level.getLocalizedName(), msg.getLocalizedMessage()));
        this._logStream.flush();
    }

    private void openOutputFile() {
        File file = new File(this._sBaseName + ".log");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException fail) {
            Misc.log(LOG, Level.SEVERE, fail, "Unable to open log file {0}", file);
            try {
                file = File.createTempFile(this._sBaseName, ".log", new File("."));
                fos = new FileOutputStream(file);
            }
            catch (IOException ex) {
                Misc.log(LOG, Level.SEVERE, ex, "Unable to open log file {0}", file);
                this._logStream = System.err;
            }
        }
        if (fos != null) {
            this._file = file;
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            try {
                this._logStream = new PrintStream((OutputStream)bos, true, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                LOG.log(Level.SEVERE, null, ex);
                this._logStream = new PrintStream(bos, true);
            }
            this.writeFileHeader(this._logStream);
        }
    }

    private void writeFileHeader(@Nonnull PrintStream ps) {
        ps.println(I.JPSXDEC_VERSION_NON_COMMERCIAL("1.05 (beta)").getLocalizedMessage());
        ps.print(System.getProperty("os.name"));
        ps.print(' ');
        ps.println(System.getProperty("os.version"));
        ps.print("Java ");
        ps.println(System.getProperty("java.version"));
        ps.println(this._dateFormat.format(Calendar.getInstance().getTime()));
    }

    @Override
    public void close() {
        if (this._file != null) {
            this._logStream.close();
        }
    }

    public static class WarnErrCounter
    implements OnWarnErr {
        private int _iWarnCount = 0;
        private int _iErrCount = 0;

        @Override
        public void onWarn(@Nonnull ILocalizedMessage msg) {
            ++this._iWarnCount;
        }

        @Override
        public void onErr(@Nonnull ILocalizedMessage msg) {
            ++this._iErrCount;
        }

        public int getWarnCount() {
            return this._iWarnCount;
        }

        public int getErrCount() {
            return this._iErrCount;
        }
    }

    public static interface OnWarnErr {
        public void onWarn(@Nonnull ILocalizedMessage var1);

        public void onErr(@Nonnull ILocalizedMessage var1);
    }
}

