/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.i18n.log;

import java.io.PrintStream;
import javax.annotation.Nonnull;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.log.UserFriendlyLogger;
import jpsxdec.util.TaskCanceledException;

public abstract class ProgressLogger
extends UserFriendlyLogger {
    private double _dblMin = 0.0;
    private double _dblMax = 0.0;

    public ProgressLogger(@Nonnull String sBaseName, @Nonnull PrintStream ps) {
        super(sBaseName, ps);
    }

    public ProgressLogger(@Nonnull String sBaseName) {
        super(sBaseName);
    }

    public final void progressStart(double dblMaxValue) throws TaskCanceledException {
        this.progressStart(0.0, dblMaxValue);
    }

    public final void progressStart(double dblMinValue, double dblMaxValue) throws TaskCanceledException {
        if (dblMaxValue < dblMinValue) {
            throw new IllegalArgumentException();
        }
        this._dblMin = dblMinValue;
        this._dblMax = dblMaxValue;
        this.handleProgressStart();
    }

    public final void progressUpdate(double dblProgress) throws TaskCanceledException {
        double dblPercent = dblProgress < this._dblMin ? 0.0 : (dblProgress > this._dblMax ? 1.0 : (dblProgress - this._dblMin) / (this._dblMax - this._dblMin));
        this.handleProgressUpdate(dblPercent);
    }

    public final void progressEnd() throws TaskCanceledException {
        this._dblMax = 0.0;
        this._dblMin = 0.0;
        this.handleProgressEnd();
    }

    protected abstract void handleProgressStart() throws TaskCanceledException;

    protected abstract void handleProgressUpdate(double var1) throws TaskCanceledException;

    protected abstract void handleProgressEnd() throws TaskCanceledException;

    public abstract boolean isSeekingEvent();

    public abstract void event(@Nonnull ILocalizedMessage var1);
}

