/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.i18n.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.log.ILocalizedLogger;

public class DebugLogger
implements ILocalizedLogger {
    public static final ILocalizedLogger Log = new DebugLogger();
    private static final Logger LOG = Logger.getLogger(DebugLogger.class.getName());

    private DebugLogger() {
    }

    @Override
    public void log(@Nonnull Level level, @Nonnull ILocalizedMessage msg) {
        msg.logEnglish(LOG, level);
        System.out.println(msg.getEnglishMessage());
    }

    @Override
    public void log(@Nonnull Level level, @Nonnull ILocalizedMessage msg, @CheckForNull Throwable debugException) {
        msg.logEnglish(LOG, level, debugException);
        System.out.println(msg.getEnglishMessage());
        if (debugException != null) {
            debugException.printStackTrace();
        }
    }
}

