/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.i18n.log;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.Bundle;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.util.Misc;

public class DebugFormatter
extends Formatter {
    @CheckForNull
    private static final ResourceBundle _rootEnglishBundle;
    private static final String LINE_SEPARATOR;
    private final Date _date = new Date();
    private final SimpleDateFormat _timeFormatter = new SimpleDateFormat("HH:mm");

    @Override
    @Nonnull
    public String getHead(@Nonnull Handler h) {
        StringBuilder sb = new StringBuilder();
        sb.append(I.JPSXDEC_VERSION_NON_COMMERCIAL("1.05 (beta)").getEnglishMessage()).append(LINE_SEPARATOR);
        sb.append(System.getProperty("os.name")).append(' ').append(System.getProperty("os.version")).append(LINE_SEPARATOR);
        sb.append("Java ").append(System.getProperty("java.version")).append(LINE_SEPARATOR);
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sb.append(dateFormatter.format(Calendar.getInstance().getTime())).append(LINE_SEPARATOR);
        return sb.toString();
    }

    @Override
    @Nonnull
    public synchronized String format(@Nonnull LogRecord record) {
        StringBuilder sb = new StringBuilder();
        this._date.setTime(record.getMillis());
        sb.append(this._timeFormatter.format(this._date));
        sb.append(' ');
        sb.append(record.getLoggerName());
        sb.append(' ');
        sb.append(record.getLevel().getName());
        sb.append(": ");
        String sMsg = record.getMessage();
        if (sMsg != null) {
            Object[] aoParams;
            if (record.getResourceBundle() != null && _rootEnglishBundle != null) {
                sMsg = _rootEnglishBundle.getString(sMsg);
            }
            if ((aoParams = record.getParameters()) != null && aoParams.length > 0) {
                Object[] aoParamsCopy = new Object[aoParams.length];
                for (int i = 0; i < aoParams.length; ++i) {
                    Object param = aoParams[i];
                    aoParamsCopy[i] = param instanceof ILocalizedMessage ? ((ILocalizedMessage)param).getEnglishMessage() : param;
                }
                sMsg = MessageFormat.format(sMsg, aoParamsCopy);
            }
            sb.append(sMsg);
        }
        sb.append(LINE_SEPARATOR);
        if (record.getThrown() != null) {
            sb.append(Misc.stack2string(record.getThrown()));
        }
        return sb.toString();
    }

    static {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(Bundle.getResourceBundleName(), new Locale(""));
        }
        catch (MissingResourceException ex) {
            Logger.getLogger(DebugFormatter.class.getName()).log(Level.SEVERE, "Unable to load root resource bundle", ex);
        }
        _rootEnglishBundle = rb;
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

