/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.i18n.log;

import java.io.PrintStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.i18n.log.UserFriendlyLogger;

public class ConsoleProgressLogger
extends ProgressLogger
implements UserFriendlyLogger.OnWarnErr {
    private static final int BAR_WIDTH = 20;
    @CheckForNull
    private ILocalizedMessage _lastEvent = null;
    private double _dblNextProgressMark = 0.0;
    private int _iWarnCount = 0;
    private int _iErrCount = 0;
    @Nonnull
    private final PrintStream _progressStream;

    public ConsoleProgressLogger(@Nonnull String sBaseName, @Nonnull PrintStream progressStream) {
        super(sBaseName);
        this._progressStream = progressStream;
        this.setListener(this);
    }

    @Override
    public void onWarn(@Nonnull ILocalizedMessage msg) {
        ++this._iWarnCount;
    }

    @Override
    public void onErr(@Nonnull ILocalizedMessage msg) {
        ++this._iErrCount;
    }

    @Override
    public void event(@Nonnull ILocalizedMessage msg) {
        this._lastEvent = msg;
    }

    @Override
    protected void handleProgressEnd() {
        this._progressStream.println(this.buildProgress(1.0));
        this._dblNextProgressMark = 0.0;
    }

    @Override
    protected void handleProgressStart() {
        this._dblNextProgressMark = 0.0;
        this._iWarnCount = 0;
        this._iErrCount = 0;
        this._lastEvent = null;
    }

    @Override
    protected void handleProgressUpdate(double dblPercentComplete) {
        if (dblPercentComplete < this._dblNextProgressMark) {
            return;
        }
        if (dblPercentComplete > 0.91) {
            return;
        }
        ILocalizedMessage line = this.buildProgress(dblPercentComplete);
        this._progressStream.println(line);
        this._dblNextProgressMark = (double)Math.round((dblPercentComplete + 0.05) * 10.0) / 10.0;
    }

    @Nonnull
    private ILocalizedMessage buildProgress(double dblPercentComplete) {
        StringBuilder progressBar = new StringBuilder();
        for (double dblProgress = 0.0; dblProgress < 1.0; dblProgress += 0.05) {
            if (dblProgress < dblPercentComplete) {
                progressBar.append('=');
                continue;
            }
            progressBar.append('.');
        }
        if (this._lastEvent == null) {
            return I.CMD_PROGRESS(progressBar.toString(), dblPercentComplete, this._iWarnCount, this._iErrCount);
        }
        return I.CMD_PROGRESS_WITH_MSG(progressBar.toString(), dblPercentComplete, this._lastEvent, this._iWarnCount, this._iErrCount);
    }

    @Override
    public boolean isSeekingEvent() {
        return true;
    }
}

