/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.i18n;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.ILocalizedMessage;

class _PlaceholderMessage
implements ILocalizedMessage {
    @Nonnull
    private final String _sMessage;
    @CheckForNull
    private final Object[] _aoArguments;

    public _PlaceholderMessage(@Nonnull String sMessage, Object ... aoArguments) {
        this._sMessage = sMessage;
        this._aoArguments = aoArguments;
    }

    public _PlaceholderMessage(@Nonnull String sMessage) {
        this._sMessage = sMessage;
        this._aoArguments = null;
    }

    @Override
    public void logEnglish(@Nonnull Logger log, @Nonnull Level level) {
        this.logEnglish(log, level, null);
    }

    @Override
    public void logEnglish(@Nonnull Logger log, @Nonnull Level level, @CheckForNull Throwable ex) {
        LogRecord lr = new LogRecord(level, this._sMessage);
        lr.setLoggerName(log.getName());
        if (this._aoArguments != null) {
            lr.setParameters(this._aoArguments);
        }
        if (ex != null) {
            lr.setThrown(ex);
        }
        log.log(lr);
    }

    @Override
    @Nonnull
    public String getEnglishMessage() {
        if (this._aoArguments == null) {
            return this._sMessage;
        }
        Object[] aoArgCopy = new Object[this._aoArguments.length];
        for (int i = 0; i < this._aoArguments.length; ++i) {
            Object arg = this._aoArguments[i];
            aoArgCopy[i] = arg instanceof ILocalizedMessage ? ((ILocalizedMessage)arg).getEnglishMessage() : arg;
        }
        return MessageFormat.format(this._sMessage, aoArgCopy);
    }

    @Override
    @Nonnull
    public String getLocalizedMessage() {
        return this.getEnglishMessage();
    }

    public String toString() {
        return this.getLocalizedMessage();
    }

    @Override
    public boolean equalsIgnoreCase(@Nonnull String s) {
        return this._sMessage.equalsIgnoreCase(s);
    }
}

