/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.i18n;

import java.io.PrintStream;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.util.Misc;

public class TabularFeedback {
    private final ArrayList<ArrayList<Cell>> _rows = new ArrayList();
    private int _iRowSpacing = 0;
    private int _iColSpacing = 2;

    public void setRowSpacing(int i) {
        this._iRowSpacing = i;
    }

    public TabularFeedback() {
        this.newRow();
    }

    @Nonnull
    public TabularFeedback addCell(@Nonnull Cell cell) {
        this.curRow().add(cell);
        return this;
    }

    @Nonnull
    public TabularFeedback addCell(ILocalizedMessage ... aoLines) {
        this.curRow().add(new Cell(aoLines));
        return this;
    }

    public void newRow() {
        this._rows.add(new ArrayList());
    }

    @Nonnull
    private ArrayList<Cell> curRow() {
        return this._rows.get(this._rows.size() - 1);
    }

    public void write(@Nonnull PrintStream ps) {
        int iRowCount = this._rows.size();
        int iColCount = 0;
        for (ArrayList<Cell> row : this._rows) {
            iColCount = Math.max(iColCount, row.size());
        }
        ArrayList[][] aaoCells = new ArrayList[iRowCount][iColCount];
        int[] aiRowHeights = new int[iRowCount];
        for (int iRow = 0; iRow < iRowCount; ++iRow) {
            ArrayList<Cell> row = this._rows.get(iRow);
            for (int iColumn = 0; iColumn < row.size(); ++iColumn) {
                ArrayList cellStingLines;
                aaoCells[iRow][iColumn] = cellStingLines = row.get(iColumn).toLines();
                aiRowHeights[iRow] = Math.max(aiRowHeights[iRow], cellStingLines.size());
            }
        }
        int[] aiColWidths = new int[iColCount];
        for (int iColumn = 0; iColumn < iColCount; ++iColumn) {
            int iColWidth = 0;
            for (int iRow = 0; iRow < iRowCount; ++iRow) {
                ArrayList cellLines = aaoCells[iRow][iColumn];
                int iCellWidth = 0;
                if (cellLines != null) {
                    for (String line : cellLines) {
                        iCellWidth = Math.max(iCellWidth, line.length());
                    }
                }
                iColWidth = Math.max(iColWidth, iCellWidth);
            }
            aiColWidths[iColumn] = iColWidth;
        }
        for (int iRow = 0; iRow < iRowCount; ++iRow) {
            ArrayList[] row = aaoCells[iRow];
            for (int iLine = 0; iLine < aiRowHeights[iRow]; ++iLine) {
                ArrayList cell;
                for (int iColumn = 0; iColumn < iColCount && (cell = row[iColumn]) != null; ++iColumn) {
                    if (iLine < cell.size()) {
                        String sLine = (String)cell.get(iLine);
                        ps.print(sLine);
                        ps.print(Misc.dup(' ', aiColWidths[iColumn] - sLine.length() + this._iColSpacing));
                        continue;
                    }
                    ps.print(Misc.dup(' ', aiColWidths[iColumn] + this._iColSpacing));
                }
                ps.println();
            }
            for (int j = 0; j < this._iRowSpacing; ++j) {
                ps.println();
            }
        }
    }

    public static class Cell {
        private final ArrayList<LineIndentPair> _lines = new ArrayList();

        public Cell() {
        }

        public Cell(ILocalizedMessage ... aoLines) {
            for (ILocalizedMessage line : aoLines) {
                this.addLine(line);
            }
        }

        public final Cell addLine(@Nonnull ILocalizedMessage line) {
            return this.addLine(line, 0);
        }

        public final Cell addLine(@Nonnull ILocalizedMessage line, int iIndent) {
            this._lines.add(new LineIndentPair(iIndent, line));
            return this;
        }

        @Nonnull
        private ArrayList<String> toLines() {
            ArrayList<String> lines = new ArrayList<String>();
            for (LineIndentPair linePair : this._lines) {
                String[] asLines;
                String s = linePair._msg.getLocalizedMessage();
                for (String sLine : asLines = s.split("\\r\\n?|\\n")) {
                    lines.add(Misc.dup(' ', linePair._iIndent) + sLine);
                }
            }
            return lines;
        }
    }

    private static class LineIndentPair {
        public final int _iIndent;
        @Nonnull
        public final ILocalizedMessage _msg;

        public LineIndentPair(int iIndent, @Nonnull ILocalizedMessage msg) {
            this._iIndent = iIndent;
            this._msg = msg;
        }
    }
}

