/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.i18n;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.util.IO;

public class MiscResources
extends ListResourceBundle {
    private static final Logger LOG = Logger.getLogger(MiscResources.class.getName());
    private static final ResourceBundle MISC_RESOURCES;
    static final String MAIN_CMDLINE_HELP = "main_cmdline_help";

    private static String getResource(String sKey) throws MissingResourceException {
        if (MISC_RESOURCES == null) {
            throw new MissingResourceException("MiscResources not loaded", MiscResources.class.getName(), sKey);
        }
        return MISC_RESOURCES.getString(sKey);
    }

    @Nonnull
    public static Iterator<ILocalizedMessage> main_cmdline_help() throws MissingResourceException {
        String sFile = MiscResources.getResource(MAIN_CMDLINE_HELP);
        InputStream is = MiscResources.class.getResourceAsStream(sFile);
        if (is == null) {
            throw new MissingResourceException("Failed to open main help resource " + sFile, MiscResources.class.getName(), MAIN_CMDLINE_HELP);
        }
        try {
            String sLine;
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            ArrayList<UnlocalizedMessage> lines = new ArrayList<UnlocalizedMessage>();
            while ((sLine = br.readLine()) != null) {
                lines.add(new UnlocalizedMessage(sLine));
            }
            Iterator<ILocalizedMessage> iterator = lines.iterator();
            return iterator;
        }
        catch (Throwable cause) {
            MissingResourceException ex = new MissingResourceException("UTF-8 unsupported", MiscResources.class.getName(), MAIN_CMDLINE_HELP);
            ex.initCause(cause);
            throw ex;
        }
        finally {
            IO.closeSilently(is, LOG);
        }
    }

    @Override
    protected Object[][] getContents() {
        return new Object[][]{{MAIN_CMDLINE_HELP, "main_cmdline_help.dat"}};
    }

    static {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(MiscResources.class.getCanonicalName());
        }
        catch (MissingResourceException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        MISC_RESOURCES = rb;
    }
}

