/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.i18n;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.Bundle;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.util.Misc;

class LocalizedMessage
implements ILocalizedMessage {
    private static final Logger LOG = Logger.getLogger(LocalizedMessage.class.getName());
    @Nonnull
    private final String _sKey;
    @Nonnull
    private final String _sEnglishDefault;
    @CheckForNull
    private final Object[] _aoArguments;

    LocalizedMessage(@Nonnull String sKey, @Nonnull String sEnglishDefault, Object ... aoArguments) {
        this._sKey = sKey;
        this._sEnglishDefault = sEnglishDefault;
        this._aoArguments = aoArguments;
    }

    LocalizedMessage(@Nonnull String sKey, @Nonnull String sEnglishDefault) {
        this._sKey = sKey;
        this._sEnglishDefault = sEnglishDefault;
        this._aoArguments = null;
    }

    @Override
    public void logEnglish(@Nonnull Logger log, @Nonnull Level level) {
        this.logEnglish(log, level, null);
    }

    @Override
    public void logEnglish(@Nonnull Logger log, @Nonnull Level level, @CheckForNull Throwable ex) {
        LogRecord lr = new LogRecord(level, this._sEnglishDefault);
        lr.setLoggerName(log.getName());
        if (this._aoArguments != null) {
            lr.setParameters(this._aoArguments);
        }
        if (ex != null) {
            lr.setThrown(ex);
        }
        log.log(lr);
    }

    @Override
    @Nonnull
    public String getEnglishMessage() {
        if (this._aoArguments == null) {
            return this._sEnglishDefault;
        }
        Object[] aoArgCopy = new Object[this._aoArguments.length];
        for (int i = 0; i < this._aoArguments.length; ++i) {
            Object arg = this._aoArguments[i];
            aoArgCopy[i] = arg instanceof ILocalizedMessage ? ((ILocalizedMessage)arg).getEnglishMessage() : arg;
        }
        return MessageFormat.format(this._sEnglishDefault, aoArgCopy);
    }

    @Override
    @Nonnull
    public String getLocalizedMessage() {
        String sMessage = this.lookupValue();
        if (sMessage == null) {
            sMessage = this._sEnglishDefault;
        }
        if (this._aoArguments == null) {
            return sMessage;
        }
        return MessageFormat.format(sMessage, this._aoArguments);
    }

    @CheckForNull
    private String lookupValue() {
        ResourceBundle rb = Bundle.getResourceBundle();
        try {
            if (rb != null) {
                return rb.getString(this._sKey);
            }
        }
        catch (MissingResourceException ex) {
            LOG.log(Level.WARNING, "Missing I18N for {0}", this._sKey);
        }
        return null;
    }

    public String toString() {
        return this.getLocalizedMessage();
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this._sKey != null ? this._sKey.hashCode() : 0);
        hash = 97 * hash + (this._sEnglishDefault != null ? this._sEnglishDefault.hashCode() : 0);
        hash = 97 * hash + Arrays.deepHashCode(this._aoArguments);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocalizedMessage other = (LocalizedMessage)obj;
        if (!Misc.objectEquals(this._sKey, other._sKey)) {
            return false;
        }
        if (!Misc.objectEquals(this._sEnglishDefault, other._sEnglishDefault)) {
            return false;
        }
        return Arrays.deepEquals(this._aoArguments, other._aoArguments);
    }

    @Override
    public boolean equalsIgnoreCase(String s) {
        String sMessage = this.lookupValue();
        return this._sEnglishDefault.equalsIgnoreCase(s) || sMessage != null && sMessage.equalsIgnoreCase(s);
    }
}

