/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.i18n;

import java.io.File;
import java.util.Date;
import javax.annotation.Nonnull;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.LocalizedMessage;
import jpsxdec.i18n._PlaceholderMessage;

public class I {
    private static ILocalizedMessage msg(String sKey, String sEnglishDefault, Object ... args) {
        if (args.length == 0) {
            return new LocalizedMessage(sKey, sEnglishDefault);
        }
        return new LocalizedMessage(sKey, sEnglishDefault, args);
    }

    @Nonnull
    public static ILocalizedMessage JPSXDEC_VERSION_NON_COMMERCIAL(@Nonnull String versionNumber) {
        return I.msg("JPSXDEC_VERSION_NON_COMMERCIAL", "jPSXdec: PSX media decoder (non-commercial) v{0}", versionNumber);
    }

    @Nonnull
    public static ILocalizedMessage CMD_USING_SRC_FILE(@Nonnull File sourceFileName) {
        return I.msg("CMD_USING_SRC_FILE", "Using source file {0}", sourceFileName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_NEED_INPUT_OR_INDEX() {
        return I.msg("CMD_NEED_INPUT_OR_INDEX", "Need a input file and/or index file to load.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DISC_FILE_REQUIRED() {
        return I.msg("CMD_DISC_FILE_REQUIRED", "Input file disc image required for this command.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_INPUT_FILE_REQUIRED() {
        return I.msg("CMD_INPUT_FILE_REQUIRED", "Input file is required for this command.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ITEMS_LOADED(int itemCount) {
        return I.msg("CMD_ITEMS_LOADED", "{0,number,#} items loaded.", itemCount);
    }

    @Nonnull
    public static ILocalizedMessage CMD_READING_INDEX_FILE(@Nonnull String fileName) {
        return I.msg("CMD_READING_INDEX_FILE", "Reading index file {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_INPUT_FILE_NOT_FOUND(@Nonnull File fileName) {
        return I.msg("CMD_INPUT_FILE_NOT_FOUND", "Input file not found {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ITEM_NUMBER_INVALID(@Nonnull String badItemNumber) {
        return I.msg("CMD_ITEM_NUMBER_INVALID", "Invalid item number: {0}", badItemNumber);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ITEM_ID_INVALID(@Nonnull String badItemIdentifier) {
        return I.msg("CMD_ITEM_ID_INVALID", "Invalid item identifier: {0}", badItemIdentifier);
    }

    @Nonnull
    public static ILocalizedMessage CMD_NO_ITEMS_OF_TYPE(@Nonnull String discItemType) {
        return I.msg("CMD_NO_ITEMS_OF_TYPE", "Sorry, couldn''t find any disc items of type {0}", discItemType);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DISC_ITEM_NOT_AUDIO_VIDEO_NO_PLAYER() {
        return I.msg("CMD_DISC_ITEM_NOT_AUDIO_VIDEO_NO_PLAYER", "Disc item is not audio or video. Cannot create player.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DISC_ITEM_NOT_VIDEO() {
        return I.msg("CMD_DISC_ITEM_NOT_VIDEO", "Disc item isn't a video.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DISC_ITEM_VIDEO_FRAME_REPLACE_UNSUPPORTED(@Nonnull String discItemTypeName) {
        return new _PlaceholderMessage("Replacing frames of video type '{0}' is not supported", discItemTypeName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DISC_ITEM_NOT_XA() {
        return I.msg("CMD_DISC_ITEM_NOT_XA", "Disc item isn't a XA stream.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DISC_ITEM_NOT_AUDIO() {
        return new _PlaceholderMessage("Disc item isn't an audio stream.");
    }

    @Nonnull
    public static ILocalizedMessage CMD_DISC_ITEM_NOT_TIM() {
        return I.msg("CMD_DISC_ITEM_NOT_TIM", "Disc item isn't a TIM image.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DISC_ITEM_NOT_FOUND_NUM(int discItemIndex) {
        return I.msg("CMD_DISC_ITEM_NOT_FOUND_NUM", "Could not find disc item {0,number,#}", discItemIndex);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DISC_ITEM_NOT_FOUND_STR(@Nonnull String discItemId) {
        return I.msg("CMD_DISC_ITEM_NOT_FOUND_STR", "Could not find disc item {0}", discItemId);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DETAILED_HELP_FOR() {
        return I.msg("CMD_DETAILED_HELP_FOR", "Detailed help for", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_SAVING(@Nonnull String discItemDescription) {
        return I.msg("CMD_SAVING", "Saving {0}", discItemDescription);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ITEM_COMPLETE() {
        return I.msg("CMD_ITEM_COMPLETE", "Item complete.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ALL_ITEMS_COMPLETE() {
        return I.msg("CMD_ALL_ITEMS_COMPLETE", "All index items complete.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_PROCESS_COMPLETE() {
        return I.msg("CMD_PROCESS_COMPLETE", "Disc decoding/extracting complete.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage PROCESS_TIME(double durationInSeconds) {
        return I.msg("PROCESS_TIME", "Time: {0,number,#.##} sec", durationInSeconds);
    }

    @Nonnull
    public static ILocalizedMessage CMD_NUM_FILES_CREATED(int fileCount) {
        return I.msg("CMD_NUM_FILES_CREATED", "{0,choice,0#No files created|1#1 file created|2#'{0,number,#}' files created}", fileCount);
    }

    @Nonnull
    public static ILocalizedMessage CMD_REOPENING_DISC_WRITE_ACCESS() {
        return I.msg("CMD_REOPENING_DISC_WRITE_ACCESS", "Reopening disc image with write access.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_BACKUP_DISC_IMAGE_WARNING() {
        return I.msg("CMD_BACKUP_DISC_IMAGE_WARNING", "Hope your disc image is backed up because this is irreversible.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_XA_REPLACE_BAD_ITEM_NUM(@Nonnull String badItemNumber) {
        return I.msg("CMD_XA_REPLACE_BAD_ITEM_NUM", "Invalid or missing XA item number {0}", badItemNumber);
    }

    @Nonnull
    public static ILocalizedMessage CMD_CREATING_PLAYER() {
        return I.msg("CMD_CREATING_PLAYER", "Creating player for", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_PLAYER_ERR() {
        return I.msg("CMD_PLAYER_ERR", "Error with player", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_XA_REPLACE_OPENING_PATCH_IDX(@Nonnull String patchIndexFileName) {
        return I.msg("CMD_XA_REPLACE_OPENING_PATCH_IDX", "Opening patch index {0}", patchIndexFileName);
    }

    @Nonnull
    public static ILocalizedMessage SAVE_LOG_FILE_BASE_NAME() {
        return I.msg("SAVE_LOG_FILE_BASE_NAME", "save", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_LOG_FILE_BASE_NAME() {
        return I.msg("INDEX_LOG_FILE_BASE_NAME", "index", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_LOG_FILE_BASE_NAME() {
        return I.msg("REPLACE_LOG_FILE_BASE_NAME", "replace", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage USER_LOG_MESSAGE(@Nonnull String logLevel, @Nonnull String logMessage) {
        return I.msg("USER_LOG_MESSAGE", "[{0}] {1}", logLevel, logMessage);
    }

    @Nonnull
    public static ILocalizedMessage USER_LOG_MESSAGE_EXCEPTION(@Nonnull String logLevel, @Nonnull String logMessage, @Nonnull String exceptionName) {
        return I.msg("USER_LOG_MESSAGE_EXCEPTION", "[{0}] {1} {2}", logLevel, logMessage, exceptionName);
    }

    @Nonnull
    public static ILocalizedMessage USER_LOG_MESSAGE_EXCEPTION_MSG(@Nonnull String logLevel, @Nonnull String logMessage, @Nonnull String exceptionName, @Nonnull String exceptionMessage) {
        return I.msg("USER_LOG_MESSAGE_EXCEPTION_MSG", "[{0}] {1} {2} : {3}", logLevel, logMessage, exceptionName, exceptionMessage);
    }

    @Nonnull
    public static ILocalizedMessage USER_LOG_EXCEPTION(@Nonnull String logLevel, @Nonnull String exceptionName) {
        return I.msg("USER_LOG_EXCEPTION", "[{0}] {1}", logLevel, exceptionName);
    }

    @Nonnull
    public static ILocalizedMessage USER_LOG_EXCEPTION_MSG(@Nonnull String logLevel, @Nonnull String exceptionName, @Nonnull String exceptionMessage) {
        return I.msg("USER_LOG_EXCEPTION_MSG", "[{0}] {1} : {2}", logLevel, exceptionName, exceptionMessage);
    }

    @Nonnull
    public static ILocalizedMessage CMD_SECTOR_RANGE_INVALID(@Nonnull String badSectorRangeString) {
        return I.msg("CMD_SECTOR_RANGE_INVALID", "Invalid sector range: {0}", badSectorRangeString);
    }

    @Nonnull
    public static ILocalizedMessage CMD_COPYING_SECTOR(int startSector, int endSector, @Nonnull String destinationFile) {
        return I.msg("CMD_COPYING_SECTOR", "Copying sectors {0,number,#} - {1,number,#} to {2}", startSector, endSector, destinationFile);
    }

    @Nonnull
    public static ILocalizedMessage CMD_GENERATING_SECTOR_LIST() {
        return I.msg("CMD_GENERATING_SECTOR_LIST", "Generating sector list", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DIM_OPTION_REQURIED() {
        return I.msg("CMD_DIM_OPTION_REQURIED", "-dim option required", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_INVALID_DIMENSIONS(@Nonnull String badDimensionsString) {
        return I.msg("CMD_INVALID_DIMENSIONS", "Invalid dimensions: {0}", badDimensionsString);
    }

    @Nonnull
    public static ILocalizedMessage CMD_QUALITY_INVALID(@Nonnull String badQuality) {
        return I.msg("CMD_QUALITY_INVALID", "Invalid quality {0}", badQuality);
    }

    @Nonnull
    public static ILocalizedMessage CMD_USING_QUALITY(@Nonnull ILocalizedMessage qualityName) {
        return I.msg("CMD_USING_QUALITY", "Using quality {0}", qualityName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_NOT_TIM() {
        return I.msg("CMD_NOT_TIM", "Error: not a Tim image", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_USING_UPSAMPLING(@Nonnull ILocalizedMessage upsampleDescription) {
        return I.msg("CMD_USING_UPSAMPLING", "Using upsampling {0}", upsampleDescription);
    }

    @Nonnull
    public static ILocalizedMessage CMD_TIM_IO_ERR() {
        return I.msg("CMD_TIM_IO_ERR", "Error reading or writing TIM file", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_FORMAT_INVALID(@Nonnull String badFormat) {
        return I.msg("CMD_FORMAT_INVALID", "Invalid format type {0}", badFormat);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ASSERT_DISABLED_NO_DEBUG() {
        return I.msg("CMD_ASSERT_DISABLED_NO_DEBUG", "Unable to enable decoding debug because asserts are disabled.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ASSERT_DISABLED_NO_DEBUG_USE_EA() {
        return I.msg("CMD_ASSERT_DISABLED_NO_DEBUG_USE_EA", "Start java using the -ea option.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_READING_TIM(@Nonnull File timFileName) {
        return I.msg("CMD_READING_TIM", "Reading TIM file {0}", timFileName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_STATIC_TYPE_INVALID(@Nonnull String badStaticTypeName) {
        return I.msg("CMD_STATIC_TYPE_INVALID", "Invalid static type: {0}", badStaticTypeName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_FRAME_CONVERT_OK() {
        return I.msg("CMD_FRAME_CONVERT_OK", "Frame converted successfully.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_READING_STATIC_FILE(@Nonnull File fileName) {
        return I.msg("CMD_READING_STATIC_FILE", "Reading static file {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_IMAGE_CONVERT_OK() {
        return I.msg("CMD_IMAGE_CONVERT_OK", "Image converted successfully", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_SAVING_AS(@Nonnull File fileName) {
        return I.msg("CMD_SAVING_AS", "Saving as: {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_GENERATING_VISUALIZATION() {
        return I.msg("CMD_GENERATING_VISUALIZATION", "Generating visualization", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VISUALIZATION_ERR() {
        return I.msg("CMD_VISUALIZATION_ERR", "Error creating or writing the visualization", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage ERR_LOADING_INDEX_FILE_REASON(@Nonnull ILocalizedMessage localizedDetails) {
        return I.msg("ERR_LOADING_INDEX_FILE_REASON", "Error loading index file: {0}", localizedDetails);
    }

    @Nonnull
    public static ILocalizedMessage CMD_NUM_ITEMS_FOUND(int itemCount) {
        return I.msg("CMD_NUM_ITEMS_FOUND", "{0,number,#} items found", itemCount);
    }

    @Nonnull
    public static ILocalizedMessage CMD_BUILDING_INDEX() {
        return I.msg("CMD_BUILDING_INDEX", "Building index", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DISC_READ_ERROR() {
        return I.msg("CMD_DISC_READ_ERROR", "Disc read error.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VERBOSE_LVL_INVALID_STR(@Nonnull String badVerbosityLevel) {
        return I.msg("CMD_VERBOSE_LVL_INVALID_STR", "Invalid verbosity level {0}", badVerbosityLevel);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VERBOSE_LVL_INVALID_NUM(int badVerbosityNumber) {
        return I.msg("CMD_VERBOSE_LVL_INVALID_NUM", "Invalid verbosity level {0,number,#}", badVerbosityNumber);
    }

    @Nonnull
    public static ILocalizedMessage CMD_SAVING_INDEX(@Nonnull String fileName) {
        return I.msg("CMD_SAVING_INDEX", "Saving index as {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_TRY_HELP() {
        return I.msg("CMD_TRY_HELP", "Try -? for help.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_NOT_SAVING_EMPTY_INDEX() {
        return I.msg("CMD_NOT_SAVING_EMPTY_INDEX", "No items found, not saving index file", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ERR_EX_CLASS(@Nonnull Throwable errorMessage, @Nonnull String exceptionType) {
        return I.msg("CMD_ERR_EX_CLASS", "ERROR: {0} ({1})", errorMessage, exceptionType);
    }

    @Nonnull
    public static ILocalizedMessage CMD_NEED_MAIN_COMMAND() {
        return I.msg("CMD_NEED_MAIN_COMMAND", "Need a main command.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DISC_IDENTIFIED(@Nonnull ILocalizedMessage discFormatDescription) {
        return I.msg("CMD_DISC_IDENTIFIED", "Identified as {0}", discFormatDescription);
    }

    @Nonnull
    public static ILocalizedMessage CMD_COMMAND_NEEDS_DISC() {
        return I.msg("CMD_COMMAND_NEEDS_DISC", "Command needs disc file", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_TOO_MANY_MAIN_COMMANDS() {
        return I.msg("CMD_TOO_MANY_MAIN_COMMANDS", "Too many main commands.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_FILE_NOT_FOUND_FILE(@Nonnull String fileName) {
        return I.msg("CMD_FILE_NOT_FOUND_FILE", "File not found {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_GUI_INDEXING(@Nonnull String cdFileDescription) {
        return I.msg("CMD_GUI_INDEXING", "Indexing {0}", cdFileDescription);
    }

    @Nonnull
    public static ILocalizedMessage CMD_PROGRESS(@Nonnull String progressBar, double percentComplete, int warningCount, int errorCount) {
        return I.msg("CMD_PROGRESS", "[{0}] {1,number,#%}{2,choice,0#|1# '{2,number,#}' '{2,choice,0#warnings|1#warning|1<warnings}'}{3,choice,0#|1# '{3,number,#}' '{3,choice,0#errors|1#error|1<errors}'}", progressBar, percentComplete, warningCount, errorCount);
    }

    @Nonnull
    public static ILocalizedMessage CMD_PROGRESS_WITH_MSG(@Nonnull String progressBar, double percentComplete, @Nonnull ILocalizedMessage message, int warningCount, int errorCount) {
        return I.msg("CMD_PROGRESS_WITH_MSG", "[{0}] {1,number,#%} {2} {3,choice,0#|1# '{3,number,#}' '{3,choice,0#warnings|1#warning|1<warnings}'}{4,choice,0#|1# '{4,number,#}' '{4,choice,0#errors|1#error|1<errors}'}", progressBar, percentComplete, message, warningCount, errorCount);
    }

    @Nonnull
    public static ILocalizedMessage CD_FILE_TOO_SMALL(@Nonnull String fileName) {
        return I.msg("CD_FILE_TOO_SMALL", "{0} is too small to be recognized", fileName);
    }

    @Nonnull
    public static ILocalizedMessage GUI_TITLE_UNSAVED_INDEX() {
        return I.msg("GUI_TITLE_UNSAVED_INDEX", "*Unsaved*", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_OPEN_ANALYZE_DISC_BTN() {
        return I.msg("GUI_OPEN_ANALYZE_DISC_BTN", "Open and Analyze File", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_DISC_NO_RAW_HEADERS_WARNING() {
        return new _PlaceholderMessage("File does not contain raw sector headers -- audio may not be detected. See manual for details.");
    }

    @Nonnull
    public static ILocalizedMessage GUI_DIALOG_COULD_NOT_IDENTIFY_ANYTHING(@Nonnull String fileName) {
        return I.msg("GUI_DIALOG_COULD_NOT_IDENTIFY_ANYTHING", "Could not identify anything in file {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage GUI_OPEN_DISC_DIALOG_TITLE() {
        return I.msg("GUI_OPEN_DISC_DIALOG_TITLE", "Select disc image or media file", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_PLAY_BTN() {
        return I.msg("GUI_PLAY_BTN", "Play", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_OPEN_INDEX_BTN() {
        return I.msg("GUI_OPEN_INDEX_BTN", "Open Index", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_LOAD_INDEX_FILE_DIALOG_TITLE() {
        return I.msg("GUI_LOAD_INDEX_FILE_DIALOG_TITLE", "Load index", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_LOAD_ISSUES_DIALOG_TITLE() {
        return I.msg("GUI_INDEX_LOAD_ISSUES_DIALOG_TITLE", "Issues loading index", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_LOAD_ISSUES(int itemCount) {
        return I.msg("GUI_INDEX_LOAD_ISSUES", "Loaded {0,number,#} items, but with issues.", itemCount);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_LOAD_ISSUES_WARNINGS(int warningCount) {
        return I.msg("GUI_INDEX_LOAD_ISSUES_WARNINGS", "Warnings: {0,number,#}", warningCount);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_LOAD_ISSUES_ERRORS(int errorCount) {
        return I.msg("GUI_INDEX_LOAD_ISSUES_ERRORS", "Errors: {0,number,#}", errorCount);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_LOAD_ISSUES_SEE_FILE(@Nonnull String logFileName) {
        return I.msg("GUI_INDEX_LOAD_ISSUES_SEE_FILE", "See {0} for details.", logFileName);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_INDEX_BTN() {
        return I.msg("GUI_SAVE_INDEX_BTN", "Save Index", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_INDEX_FILE_DIALOG_TITLE() {
        return I.msg("GUI_SAVE_INDEX_FILE_DIALOG_TITLE", "Save index", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_INDEX_ERR() {
        return I.msg("GUI_SAVE_INDEX_ERR", "Error saving index", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_DIRECTORY_LABEL() {
        return I.msg("GUI_DIRECTORY_LABEL", "Directory:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_DIR_CHOOSER_BTN() {
        return I.msg("GUI_DIR_CHOOSER_BTN", "...", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SELECT_BTN() {
        return I.msg("GUI_SELECT_BTN", "Select ...", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_COLLAPSE_ALL_BTN() {
        return I.msg("GUI_COLLAPSE_ALL_BTN", "Collapse All", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_EXPAND_ALL_BTN() {
        return I.msg("GUI_EXPAND_ALL_BTN", "Expand All", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_ALL_SELECTED_BTN() {
        return I.msg("GUI_SAVE_ALL_SELECTED_BTN", "Save All Selected", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_NOTHING_IS_MARKED_FOR_SAVING() {
        return I.msg("GUI_NOTHING_IS_MARKED_FOR_SAVING", "Nothing is marked for saving.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_APPLY_TO_ALL_BTN(@Nonnull ILocalizedMessage itemTypeName) {
        return I.msg("GUI_APPLY_TO_ALL_BTN", "Apply to all {0}", itemTypeName);
    }

    @Nonnull
    public static ILocalizedMessage GUI_APPLIED_SETTINGS(int itemCount) {
        return I.msg("GUI_APPLIED_SETTINGS", "Applied settings to {0,number,#} items.", itemCount);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_INDEX_PROMPT() {
        return I.msg("GUI_SAVE_INDEX_PROMPT", "The index has not been saved. Save index?", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_INDEX_PROMPT_TITLE() {
        return I.msg("GUI_SAVE_INDEX_PROMPT_TITLE", "Save index?", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_PLAY_TAB() {
        return I.msg("GUI_PLAY_TAB", "    Play    ", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_TAB() {
        return I.msg("GUI_SAVE_TAB", "    Save    ", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_PAUSE_BTN() {
        return I.msg("GUI_PAUSE_BTN", "Pause", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_BAD_ERROR() {
        return I.msg("GUI_BAD_ERROR", "Bad error", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage ERR_LOADING_INDEX_FILE() {
        return I.msg("ERR_LOADING_INDEX_FILE", "Error loading index file", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_CD_IMAGE_EXTENSIONS() {
        return I.msg("GUI_CD_IMAGE_EXTENSIONS", "CD images (*.iso, *.bin, *.img, *.mdf)", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_EXTENSION() {
        return I.msg("GUI_INDEX_EXTENSION", "Index files (*.idx)", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_PSX_VIDEO_EXTENSIONS() {
        return I.msg("GUI_PSX_VIDEO_EXTENSIONS", "PlayStation video (*.str, *.mov, *.iki, *.ik2)", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_ALL_COMPATIBLE_EXTENSIONS() {
        return I.msg("GUI_ALL_COMPATIBLE_EXTENSIONS", "All compatible types", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_XA_EXTENSION() {
        return I.msg("GUI_XA_EXTENSION", "PlayStation/CD-i audio (*.xa, *.xai)", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_FILE_EXISTS_REPLACE(@Nonnull String fileName) {
        return I.msg("GUI_FILE_EXISTS_REPLACE", "The file \"{0}\" already exists!\nDo you want to replace it?", fileName);
    }

    @Nonnull
    public static ILocalizedMessage GUI_TREE_NAME_COLUMN() {
        return I.msg("GUI_TREE_NAME_COLUMN", "", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SECTORS_COLUMN() {
        return I.msg("GUI_SECTORS_COLUMN", "Sectors", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_TREE_TYPE_COLUMN() {
        return I.msg("GUI_TREE_TYPE_COLUMN", "Type", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SELECT_NONE() {
        return I.msg("GUI_SELECT_NONE", "none", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SELECT_ALL_VIDEO() {
        return I.msg("GUI_SELECT_ALL_VIDEO", "all Videos", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SELECT_ALL_FILES() {
        return I.msg("GUI_SELECT_ALL_FILES", "all Files", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SELECT_ALL_AUIO_EX_VID() {
        return I.msg("GUI_SELECT_ALL_AUIO_EX_VID", "all Audio (excluding video audio)", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SELECT_ALL_AUDIO_INC_VID() {
        return I.msg("GUI_SELECT_ALL_AUDIO_INC_VID", "all Audio (including video audio)", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SELECT_ALL_IMAGES() {
        return I.msg("GUI_SELECT_ALL_IMAGES", "all Images", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SELECT_ALL_SOUNDS() {
        return I.msg("GUI_SELECT_ALL_SOUNDS", "all Sound clips", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_TREE_DETAILS_COLUMN() {
        return I.msg("GUI_TREE_DETAILS_COLUMN", "Details", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_TREE_SAVE_COLUMN() {
        return I.msg("GUI_TREE_SAVE_COLUMN", "Save", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_TREE_INDEX_NUMBER_COLUMN() {
        return I.msg("GUI_TREE_INDEX_NUMBER_COLUMN", "#", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage UNNAMED_DISC_ITEM() {
        return I.msg("UNNAMED_DISC_ITEM", "Unnamed", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage ID_FORMAT_INVALID(@Nonnull String badIndexId) {
        return I.msg("ID_FORMAT_INVALID", "Invalid id format: {0}", badIndexId);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_WARNINGS_LABEL() {
        return I.msg("GUI_INDEX_WARNINGS_LABEL", "Warnings:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_RESULT_FAILURE(@Nonnull String logFileName) {
        return I.msg("GUI_INDEX_RESULT_FAILURE", "Failure - See {0} for details", logFileName);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_RESULT_CANCELED() {
        return I.msg("GUI_INDEX_RESULT_CANCELED", "Canceled", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_TITLE() {
        return I.msg("GUI_INDEX_TITLE", "Progress...", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_EXCEPTION_DIALOG_TITLE() {
        return I.msg("GUI_INDEX_EXCEPTION_DIALOG_TITLE", "Exception", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_RESULT_OK_MSGS(@Nonnull String logFileName) {
        return I.msg("GUI_INDEX_RESULT_OK_MSGS", "Success with messages - See {0} for details", logFileName);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEXING_LABEL() {
        return I.msg("GUI_INDEXING_LABEL", "Indexing:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_ERRORS_LABEL() {
        return I.msg("GUI_INDEX_ERRORS_LABEL", "Errors:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_INDEX_RESULT_SUCCESS() {
        return I.msg("GUI_INDEX_RESULT_SUCCESS", "Success!", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_CANCEL_BTN() {
        return I.msg("GUI_CANCEL_BTN", "Cancel", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_CLOSE_BTN() {
        return I.msg("GUI_CLOSE_BTN", "Close", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_START_BTN() {
        return I.msg("GUI_START_BTN", "Start", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_UNHANDLED_ERROR() {
        return I.msg("GUI_UNHANDLED_ERROR", "Unhandled error", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_STATUS_OVERALL_COMPLETE(@Nonnull String fileName) {
        return I.msg("GUI_SAVE_STATUS_OVERALL_COMPLETE", "Complete | See {0} for details", fileName);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_STATUS_OVERALL_CANCELED(@Nonnull String fileName) {
        return I.msg("GUI_SAVE_STATUS_OVERALL_CANCELED", "Canceled | See {0} for details", fileName);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_STATUS_FAILED() {
        return I.msg("GUI_SAVE_STATUS_FAILED", "Failed!", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_STATUS_CANCELED() {
        return I.msg("GUI_SAVE_STATUS_CANCELED", "Canceled", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SRC_COLUMN() {
        return I.msg("GUI_SRC_COLUMN", "Source", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_ERR_COLUMN() {
        return I.msg("GUI_ERR_COLUMN", "Err", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_AS_COLUMN() {
        return I.msg("GUI_SAVE_AS_COLUMN", "Save As", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_STATUS_WAITING() {
        return I.msg("GUI_SAVE_STATUS_WAITING", "Waiting", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_MESSAGE_COLUMN() {
        return I.msg("GUI_MESSAGE_COLUMN", "Message", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_STATUS_DONE() {
        return I.msg("GUI_SAVE_STATUS_DONE", "Done", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_PROGRESS_COLUMN() {
        return I.msg("GUI_PROGRESS_COLUMN", "Progress", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_WARN_COLUMN() {
        return I.msg("GUI_WARN_COLUMN", "Warn", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage SECTOR_COUNT_MISMATCH(int serializedCount, int actualCount) {
        return I.msg("SECTOR_COUNT_MISMATCH", "Serialized sector count {0,number,#} does not match actual {1,number,#}", serializedCount, actualCount);
    }

    @Nonnull
    public static ILocalizedMessage CD_DESERIALIZE_FAIL(@Nonnull String badSerializedString) {
        return I.msg("CD_DESERIALIZE_FAIL", "Failed to deserialize CD string: {0}", badSerializedString);
    }

    @Nonnull
    public static ILocalizedMessage CD_FORMAT_2048() {
        return I.msg("CD_FORMAT_2048", ".iso (2048 bytes/sector) format", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CD_FORMAT_2336() {
        return I.msg("CD_FORMAT_2336", "partial header (2336 bytes/sector) format", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CD_FORMAT_2448() {
        return I.msg("CD_FORMAT_2448", "BIN/CUE + Sub Channel (2448 bytes/sector) format", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CD_FORMAT_2352() {
        return I.msg("CD_FORMAT_2352", "BIN/CUE (2352 bytes/sector) format", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FAILED_TO_READ_1_SECTOR() {
        return I.msg("FAILED_TO_READ_1_SECTOR", "Failed to read at least 1 entire sector.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage EMPTY_SERIALIZED_STRING() {
        return I.msg("EMPTY_SERIALIZED_STRING", "Empty serialized string", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage SERIALIZATION_FAILED_TO_CONVERT_TO_INT(@Nonnull String badNumber) {
        return I.msg("SERIALIZATION_FAILED_TO_CONVERT_TO_INT", "Failed to convert serialized field to int: {0}", badNumber);
    }

    @Nonnull
    public static ILocalizedMessage SERIALIZATION_FAILED_TO_CONVERT_TO_LONG(@Nonnull String badNumber) {
        return I.msg("SERIALIZATION_FAILED_TO_CONVERT_TO_LONG", "Failed to convert serialized field to long: {0}", badNumber);
    }

    @Nonnull
    public static ILocalizedMessage SERIALIZATION_FAILED_TO_CONVERT_TO_NUMBER(@Nonnull String badNumber) {
        return I.msg("SERIALIZATION_FAILED_TO_CONVERT_TO_NUMBER", "Failed to convert text to number: {0}", badNumber);
    }

    @Nonnull
    public static ILocalizedMessage SERIALIZATION_FIELD_IMPROPERLY_FORMATTED(@Nonnull String lineFromIndexFile) {
        return I.msg("SERIALIZATION_FIELD_IMPROPERLY_FORMATTED", "Improperly formatted field serialization: {0}", lineFromIndexFile);
    }

    @Nonnull
    public static ILocalizedMessage SERIALIZATION_FAILED_TO_CONVERT_TO_RANGE(@Nonnull String badRange) {
        return I.msg("SERIALIZATION_FAILED_TO_CONVERT_TO_RANGE", "Failed to convert serialized value to range: {0}", badRange);
    }

    @Nonnull
    public static ILocalizedMessage SERIALIZATION_MISSING_REQUIRED_FIELDS(@Nonnull String lineFromIndexFile) {
        return I.msg("SERIALIZATION_MISSING_REQUIRED_FIELDS", "Line missing vital fields {0}", lineFromIndexFile);
    }

    @Nonnull
    public static ILocalizedMessage SERIALIZATION_FIELD_NOT_FOUND(@Nonnull String missingField) {
        return I.msg("SERIALIZATION_FIELD_NOT_FOUND", "{0} field not found.", missingField);
    }

    @Nonnull
    public static ILocalizedMessage CD_FORMAT_MISMATCH(@Nonnull String actualFormatDescription, @Nonnull String expectedFormatDescription) {
        return I.msg("CD_FORMAT_MISMATCH", "Disc format \"{0}\" does not match the format in the index file \"{1}\"", actualFormatDescription, expectedFormatDescription);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_HEADER_MISSING() {
        return I.msg("INDEX_HEADER_MISSING", "Missing proper index header.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage INDEXING_ERROR() {
        return I.msg("INDEXING_ERROR", "Error while indexing disc", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_SECTOR_CORRUPTED(int sectorNumber) {
        return I.msg("INDEX_SECTOR_CORRUPTED", "Detected corruption in sector {0,number,#}. This may affect identification and conversion.", sectorNumber);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_SECTOR_CORRUPTED_AT(int sectorNumber) {
        return I.msg("INDEX_SECTOR_CORRUPTED_AT", "Detected corruption at sector {0,number,#}. This may affect identification and conversion.", sectorNumber);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_SECTOR_HEADER_NUM_BREAK(int previousSectorNumber, int currentSectorNumber) {
        return I.msg("INDEX_SECTOR_HEADER_NUM_BREAK", "Non-continuous sector header number: {0,number,#} -> {1,number,#}", previousSectorNumber, currentSectorNumber);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_MODE1_AMONG_MODE2(int sectorNumber) {
        return I.msg("INDEX_MODE1_AMONG_MODE2", "Sector {0,number,#} is Mode 1 found among Mode 2 sectors", sectorNumber);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_PARSE_LINE_FAIL(@Nonnull String lineFromIndexFile, @Nonnull ILocalizedMessage localizedErrorMessage) {
        return I.msg("INDEX_PARSE_LINE_FAIL", "Failed to parse \"{0}\" because \"{1}\"", lineFromIndexFile, localizedErrorMessage);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_UNHANDLED_LINE(@Nonnull String lineFromIndexFile) {
        return I.msg("INDEX_UNHANDLED_LINE", "Line not recognized {0}", lineFromIndexFile);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_MULTIPLE_CD(@Nonnull String discFileIdentifier) {
        return I.msg("INDEX_MULTIPLE_CD", "Index contains multiple lines that start with \"{0}\"", discFileIdentifier);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_NO_CD(@Nonnull String discFileIdentifier) {
        return I.msg("INDEX_NO_CD", "Index is missing a line that starts with \"{0}\", and no source file was supplied.", discFileIdentifier);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_INCONSTSTENCIES() {
        return I.msg("INDEX_INCONSTSTENCIES", "Found inconsistencies in the index, has it been modified?", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_SECTOR_ITEM_PROGRESS(int currentSectorNumber, int totalSectorCount, int itemsFound) {
        return I.msg("INDEX_SECTOR_ITEM_PROGRESS", "Sector {0,number,#} / {1,number,#} {2,number,#} items found", currentSectorNumber, totalSectorCount, itemsFound);
    }

    @Nonnull
    public static ILocalizedMessage INDEX_COMMENT(@Nonnull String lineCommentCharacter) {
        return I.msg("INDEX_COMMENT", "{0} Lines that begin with {0} are ignored", lineCommentCharacter);
    }

    @Nonnull
    public static ILocalizedMessage IGNORING_SILENT_XA_SECTOR(int sectorNumber, int channelNumber) {
        return I.msg("IGNORING_SILENT_XA_SECTOR", "Ignoring a silent XA audio stream that is only 1 sector long at sector {0,number,#}, channel {1,number,#}", sectorNumber, channelNumber);
    }

    @Nonnull
    public static ILocalizedMessage ITEM_TYPE_VIDEO() {
        return I.msg("ITEM_TYPE_VIDEO", "Video", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage ITEM_TYPE_VIDEO_APPLY() {
        return I.msg("ITEM_TYPE_VIDEO_APPLY", "Videos", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage ITEM_TYPE_FILE() {
        return I.msg("ITEM_TYPE_FILE", "File", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage ITEM_TYPE_FILE_APPLY() {
        return I.msg("ITEM_TYPE_FILE_APPLY", "Files", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage ITEM_TYPE_AUDIO() {
        return I.msg("ITEM_TYPE_AUDIO", "Audio", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage ITEM_TYPE_AUDIO_APPLY() {
        return I.msg("ITEM_TYPE_AUDIO_APPLY", "Audio", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage ITEM_TYPE_IMAGE() {
        return I.msg("ITEM_TYPE_IMAGE", "Image", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage ITEM_TYPE_IMAGE_APPLY() {
        return I.msg("ITEM_TYPE_IMAGE_APPLY", "Images", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage ITEM_TYPE_SOUND() {
        return I.msg("ITEM_TYPE_SOUND", "Sound clip", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage ITEM_TYPE_SOUND_APPLY() {
        return I.msg("ITEM_TYPE_SOUND_APPLY", "Sound clips", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_PACKET_BASED_VID_DETAILS(int videoWidth, int videoHeight, int frameCount, double framesPerSecond, @Nonnull Date duration) {
        return I.msg("GUI_PACKET_BASED_VID_DETAILS", "{0,number,#}x{1,number,#}, {2,number,#} frames, {3,number,#.###} fps = {4,time,m:ss}", videoWidth, videoHeight, frameCount, framesPerSecond, duration);
    }

    @Nonnull
    public static ILocalizedMessage GUI_PACKET_BASED_VID_DETAILS_WITH_AUDIO(int videoWidth, int videoHeight, int frameCount, double framesPerSecond, @Nonnull Date duration, int audioHz) {
        return I.msg("GUI_PACKET_BASED_VID_DETAILS_WITH_AUDIO", "{0,number,#}x{1,number,#}, {2,number,#} frames, {3,number,#.###} fps = {4,time,m:ss}, {5,number,#} Hz", videoWidth, videoHeight, frameCount, framesPerSecond, duration, audioHz);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SQUARE_AUDIO_DETAILS(@Nonnull Date duration, int sampleRate) {
        return I.msg("GUI_SQUARE_AUDIO_DETAILS", "{0,time,m:ss}, {1,number,#} Hz Stereo", duration, sampleRate);
    }

    @Nonnull
    public static ILocalizedMessage GUI_STR_VIDEO_DETAILS_UNKNOWN_FPS(int videoWidth, int videoHeight, int frameCount, double doubleSpeedFramesPerSecond, @Nonnull Date doubleSpeedDuration, double singleSpeedFramesPerSecond, @Nonnull Date singleSpeedDuration) {
        return I.msg("GUI_STR_VIDEO_DETAILS_UNKNOWN_FPS", "{0,number,#}x{1,number,#}, {2,number,#} frames, {3,number,#.###} fps = {4,time,m:ss} (or {5,number,#.###} fps = {6,time,m:ss})", videoWidth, videoHeight, frameCount, doubleSpeedFramesPerSecond, doubleSpeedDuration, singleSpeedFramesPerSecond, singleSpeedDuration);
    }

    @Nonnull
    public static ILocalizedMessage GUI_STR_VIDEO_DETAILS(int videoWidth, int videoHeight, int frameCount, double framesPerSecond, @Nonnull Date duration) {
        return I.msg("GUI_STR_VIDEO_DETAILS", "{0,number,#}x{1,number,#}, {2,number,#} frames, {3,number,#.###} fps = {4,time,m:ss}", videoWidth, videoHeight, frameCount, framesPerSecond, duration);
    }

    @Nonnull
    public static ILocalizedMessage GUI_ISOFILE_DETAILS(long fileSize) {
        return I.msg("GUI_ISOFILE_DETAILS", "{0} bytes", fileSize);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ISOFILE_ISO_HELP(int rawBytesPerSector) {
        return I.msg("CMD_ISOFILE_ISO_HELP", "-raw  save with raw {0,number,#} bytes/sectors (default is 2048 bytes/sector)", rawBytesPerSector);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ISOFILE_HELP_NO_OPTIONS() {
        return I.msg("CMD_ISOFILE_HELP_NO_OPTIONS", "[no options available]", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ISOFILE_SAVING_RAW(int rawBytesPerSector) {
        return I.msg("CMD_ISOFILE_SAVING_RAW", "Saving with raw {0,number,#} bytes/sector", rawBytesPerSector);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ISOFILE_SAVING_2048() {
        return I.msg("CMD_ISOFILE_SAVING_2048", "Saving with normal 2048 bytes/sector", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_ISOFILE_SAVE_2048() {
        return I.msg("GUI_ISOFILE_SAVE_2048", "Normal 2048 bytes/sector", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_ISOFILE_SAVE_RAW() {
        return I.msg("GUI_ISOFILE_SAVE_RAW", "Raw", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_ISOFILE_SAVE_RAW_SIZE(int rawSectorSize) {
        return I.msg("GUI_ISOFILE_SAVE_RAW_SIZE", "Raw {0,number,#} bytes/sector", rawSectorSize);
    }

    @Nonnull
    public static ILocalizedMessage NOT_CONTAINED_IN_DISC(@Nonnull String itemDescription) {
        return I.msg("NOT_CONTAINED_IN_DISC", "{0} is not completely in the bounds of the CD/file, extracting it will cause errors.", itemDescription);
    }

    @Nonnull
    public static ILocalizedMessage ISO_FILE_CORRUPTED_IGNORING(@Nonnull String fileName) {
        return I.msg("ISO_FILE_CORRUPTED_IGNORING", "Disc file {0} information is corrupted, ignoring", fileName);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_AS_LABEL() {
        return I.msg("GUI_SAVE_AS_LABEL", "Save as:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_AUDIO_FORMAT(@Nonnull ILocalizedMessage audioFormat) {
        return I.msg("CMD_AUDIO_FORMAT", "Format: {0}", audioFormat);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VOLUME_PERCENT(double volumeLevelPercent) {
        return new _PlaceholderMessage("Volume: {0,number,#%}", volumeLevelPercent);
    }

    @Nonnull
    public static ILocalizedMessage CMD_FILENAME(@Nonnull File fileName) {
        return I.msg("CMD_FILENAME", "Filename: {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_AUDIO_AF() {
        return I.msg("CMD_AUDIO_AF", "-audfmt,-af <format>", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_AUDIO_AF_HELP(@Nonnull String defaultAudioFormatName) {
        return I.msg("CMD_AUDIO_AF_HELP", "Output audio format (default {0}). Options:", defaultAudioFormatName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_AUDIO_VOL() {
        return I.msg("CMD_AUDIO_VOL", "-vol <0-100>", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_AUDIO_VOL_HELP(int defaultVolumeLevel) {
        return I.msg("CMD_AUDIO_VOL_HELP", "Adjust volume (default {0,number,#}).", defaultVolumeLevel);
    }

    @Nonnull
    public static ILocalizedMessage CMD_IGNORING_INVALID_FORMAT(@Nonnull String invalidFormatName) {
        return I.msg("CMD_IGNORING_INVALID_FORMAT", "Ignoring invalid format {0}", invalidFormatName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_IGNORING_INVALID_VOLUME(@Nonnull String invalidVolume) {
        return I.msg("CMD_IGNORING_INVALID_VOLUME", "Ignoring invalid volume {0}", invalidVolume);
    }

    @Nonnull
    public static ILocalizedMessage CMD_IGNORING_INVALID_DISC_SPEED(@Nonnull String badDiscSpeed) {
        return I.msg("CMD_IGNORING_INVALID_DISC_SPEED", "Ignoring invalid disc speed {0}", badDiscSpeed);
    }

    @Nonnull
    public static ILocalizedMessage GUI_VOLUME_LABEL() {
        return I.msg("GUI_VOLUME_LABEL", "Volume:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage AVI_FILE_IS_CLOSED() {
        return I.msg("AVI_FILE_IS_CLOSED", "Avi file is closed", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage WRITING_SAMPLES_TO_SECTOR(long startOfSamples, @Nonnull String sectorDescription) {
        return I.msg("WRITING_SAMPLES_TO_SECTOR", "Writing samples starting at {0,number,#} to sector sector {1}", startOfSamples, sectorDescription);
    }

    @Nonnull
    public static ILocalizedMessage CMD_PATCHING_SECTOR_NUMBER(int sectorNumber) {
        return I.msg("CMD_PATCHING_SECTOR_NUMBER", "Patching sector {0,number,#}", sectorNumber);
    }

    @Nonnull
    public static ILocalizedMessage CMD_PATCHING_SECTOR_DESCRIPTION(@Nonnull String sectorDescription) {
        return I.msg("CMD_PATCHING_SECTOR_DESCRIPTION", "Patching sector {0}", sectorDescription);
    }

    @Nonnull
    public static ILocalizedMessage CMD_PATCHING_WITH_SECTOR_DESCRIPTION(@Nonnull String otherSectorDescription) {
        return I.msg("CMD_PATCHING_WITH_SECTOR_DESCRIPTION", "with sector {0}", otherSectorDescription);
    }

    @Nonnull
    public static ILocalizedMessage FIELD_HAS_INVALID_VALUE_NUM(@Nonnull String fieldName, int badFieldNumberValue) {
        return I.msg("FIELD_HAS_INVALID_VALUE_NUM", "{0} field has invalid value: {1,number,#}", fieldName, badFieldNumberValue);
    }

    @Nonnull
    public static ILocalizedMessage FIELD_HAS_INVALID_VALUE_STR(@Nonnull String fieldName, @Nonnull String badFieldStringValue) {
        return I.msg("FIELD_HAS_INVALID_VALUE_STR", "{0} field has invalid value: {1}", fieldName, badFieldStringValue);
    }

    @Nonnull
    public static ILocalizedMessage XA_AUDIO_CORRUPTED(int sectorNumber, long firstBadSample) {
        return I.msg("XA_AUDIO_CORRUPTED", "XA audio corrupted at sector {0,number,#} affecting samples after {1,number,#}", sectorNumber, firstBadSample);
    }

    @Nonnull
    public static ILocalizedMessage SPU_ADPCM_CORRUPTED(int approximateSectorNumber, long firstBadSample) {
        return I.msg("SPU_ADPCM_CORRUPTED", "Audio corrupted near sector {0,number,#} affecting samples after {1,number,#}", approximateSectorNumber, firstBadSample);
    }

    @Nonnull
    public static ILocalizedMessage GUI_AUDIO_DESCRIPTION(@Nonnull Date duration, int audioSampleRate, int audioChannelCount) {
        return I.msg("GUI_AUDIO_DESCRIPTION", "{0,time,m:ss}, {1,number,#} Hz {2,choice,1#Mono|2#Stereo}", duration, audioSampleRate, audioChannelCount);
    }

    @Nonnull
    public static ILocalizedMessage CMD_PATCHING_DISC_ITEM(@Nonnull String discItemDescription) {
        return I.msg("CMD_PATCHING_DISC_ITEM", "Patching {0}", discItemDescription);
    }

    @Nonnull
    public static ILocalizedMessage CMD_PATCHING_WITH_DISC_ITEM(@Nonnull String otherDiscItemDescription) {
        return I.msg("CMD_PATCHING_WITH_DISC_ITEM", "with {0}", otherDiscItemDescription);
    }

    @Nonnull
    public static ILocalizedMessage XA_REPLACE_FORMAT_MISMATCH(int newBitsPerSample, long newSampleCount, int newChannelCount, int newSamplesPerSecond, int existingBitsPerSample, long existingSampleCount, int existingChannelCount, int existingSamplesPerSecond) {
        return I.msg("XA_REPLACE_FORMAT_MISMATCH", "XA audio mismatch: new XA audio ({0,number,#} bits/sample, {1,number} {2,choice,1#Mono|2#Stereo} samples at {3,number}Hz) does not match existing XA audio ({4,number,#} bits/sample, {5,number} {6,choice,1#Mono|2#Stereo} samples at {7,number}Hz)", newBitsPerSample, newSampleCount, newChannelCount, newSamplesPerSecond, existingBitsPerSample, existingSampleCount, existingChannelCount, existingSamplesPerSecond);
    }

    @Nonnull
    public static ILocalizedMessage AUDIO_REPLACE_FORMAT_MISMATCH(long newSampleCount, int newChannelCount, float newSampleRate, long existingSamleCount, int existingChannelCount, int existingSampleRate) {
        return I.msg("AUDIO_REPLACE_FORMAT_MISMATCH", "Audio mismatch: new audio ({0,number,#} {1,choice,1#Mono|2#Stereo} samples at {2,number,#.#}Hz) does not match existing audio ({3,number,#} {4,choice,1#Mono|2#Stereo} samples at {5,number,#.#}Hz)", newSampleCount, newChannelCount, Float.valueOf(newSampleRate), existingSamleCount, existingChannelCount, existingSampleRate);
    }

    @Nonnull
    public static ILocalizedMessage XA_COPY_REPLACE_SAMPLE_RATE_MISMATCH(float incompatibleAudioSampleRate, int xaAudioSampleRate) {
        return I.msg("XA_COPY_REPLACE_SAMPLE_RATE_MISMATCH", "Audio file sample rate {0} does not match XA audio rate {1}", Float.valueOf(incompatibleAudioSampleRate), xaAudioSampleRate);
    }

    @Nonnull
    public static ILocalizedMessage XA_COPY_REPLACE_CHANNEL_MISMATCH(int replaceChannelCount, int sourceChannelCount) {
        return I.msg("XA_COPY_REPLACE_CHANNEL_MISMATCH", "Audio file is {0,choice,1#Mono|2#Stereo} and does not match XA audio {1,choice,1#Mono|2#Stereo}", replaceChannelCount, sourceChannelCount);
    }

    @Nonnull
    public static ILocalizedMessage XA_ENCODE_REPLACE_SRC_AUDIO_EXHAUSTED() {
        return I.msg("XA_ENCODE_REPLACE_SRC_AUDIO_EXHAUSTED", "Source audio is exhausted, writing silence", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage XA_COPY_REPLACE_SRC_XA_EXHAUSTED() {
        return I.msg("XA_COPY_REPLACE_SRC_XA_EXHAUSTED", "End of source XA, stopping", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NUM_INVALID(@Nonnull String badFrameNumberString) {
        return I.msg("FRAME_NUM_INVALID", "Invalid frame number {0}", badFrameNumberString);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NUM_FORMAT_INDEX() {
        return I.msg("FRAME_NUM_FORMAT_INDEX", "Index", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NUM_FORMAT_SECTOR() {
        return I.msg("FRAME_NUM_FORMAT_SECTOR", "Sector", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NUM_FORMAT_HEADER() {
        return I.msg("FRAME_NUM_FORMAT_HEADER", "Header", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NUM_FORMATTER_SECTOR(@Nonnull String formattedSectorNumber) {
        return I.msg("FRAME_NUM_FORMATTER_SECTOR", "Sector {0}", formattedSectorNumber);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NUM_FORMATTER_FRAME(@Nonnull String formattedFrameNumber) {
        return I.msg("FRAME_NUM_FORMATTER_FRAME", "Frame {0}", formattedFrameNumber);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NUM_FORMAT_INVALID(@Nonnull String badFrameNumberFormat) {
        return I.msg("FRAME_NUM_FORMAT_INVALID", "Invalid frame number format {0}", badFrameNumberFormat);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_MISSING_FRAME_NUMBER_HEADER(int frameNumber) {
        return I.msg("FRAME_MISSING_FRAME_NUMBER_HEADER", "Frame {0,number,#} missing frame number information", frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage FRAMES_UNEXPECTED_NUMBER() {
        return I.msg("FRAMES_UNEXPECTED_NUMBER", "Found an unexpected number of frames, the frames may be saved in an inconsistent order.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage QUALITY_HIGH_DESCRIPTION() {
        return I.msg("QUALITY_HIGH_DESCRIPTION", "High quality (slower)", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage QUALITY_HIGH_COMMAND() {
        return I.msg("QUALITY_HIGH_COMMAND", "high", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage QUALITY_FAST_DESCRIPTION() {
        return I.msg("QUALITY_FAST_DESCRIPTION", "Fast (lower quality)", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage QUALITY_FAST_COMMAND() {
        return I.msg("QUALITY_FAST_COMMAND", "low", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage QUALITY_PSX_DESCRIPTION() {
        return I.msg("QUALITY_PSX_DESCRIPTION", "Emulate PSX (low) quality", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage QUALITY_PSX_COMMAND() {
        return I.msg("QUALITY_PSX_COMMAND", "psx", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_BICUBIC_DESCRIPTION() {
        return I.msg("CHROMA_UPSAMPLE_BICUBIC_DESCRIPTION", "Bicubic", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_BICUBIC_CMDLINE() {
        return I.msg("CHROMA_UPSAMPLE_BICUBIC_CMDLINE", "Bicubic", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_BELL_DESCRIPTION() {
        return I.msg("CHROMA_UPSAMPLE_BELL_DESCRIPTION", "Bell", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_BELL_CMDLINE() {
        return I.msg("CHROMA_UPSAMPLE_BELL_CMDLINE", "Bell", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_NEAR_NEIGHBOR_DESCRIPTION() {
        return I.msg("CHROMA_UPSAMPLE_NEAR_NEIGHBOR_DESCRIPTION", "Nearest Neighbor", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_NEAR_NEIGHBOR_CMDLINE() {
        return I.msg("CHROMA_UPSAMPLE_NEAR_NEIGHBOR_CMDLINE", "NearestNeighbor", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_LANCZOS3_DESCRIPTION() {
        return I.msg("CHROMA_UPSAMPLE_LANCZOS3_DESCRIPTION", "Lanczos3", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_LANCZOS3_CMDLINE() {
        return I.msg("CHROMA_UPSAMPLE_LANCZOS3_CMDLINE", "Lanczos3", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_MITCHELL_DESCRIPTION() {
        return I.msg("CHROMA_UPSAMPLE_MITCHELL_DESCRIPTION", "Mitchell", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_MITCHELL_CMDLINE() {
        return I.msg("CHROMA_UPSAMPLE_MITCHELL_CMDLINE", "Mitchell", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_HERMITE_DESCRIPTION() {
        return I.msg("CHROMA_UPSAMPLE_HERMITE_DESCRIPTION", "Hermite", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_HERMITE_CMDLINE() {
        return I.msg("CHROMA_UPSAMPLE_HERMITE_CMDLINE", "Hermite", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_BSPLINE_DESCRIPTION() {
        return I.msg("CHROMA_UPSAMPLE_BSPLINE_DESCRIPTION", "BSpline", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_BSPLINE_CMDLINE() {
        return I.msg("CHROMA_UPSAMPLE_BSPLINE_CMDLINE", "BSpline", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_BILINEAR_DESCRIPTION() {
        return I.msg("CHROMA_UPSAMPLE_BILINEAR_DESCRIPTION", "Bilinear", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_BILINEAR_CMDLINE() {
        return I.msg("CHROMA_UPSAMPLE_BILINEAR_CMDLINE", "Bilinear", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CHROMA_UPSAMPLE_CMDLINE_HELP(@Nonnull ILocalizedMessage commandLineId, @Nonnull ILocalizedMessage interplationName) {
        return I.msg("CHROMA_UPSAMPLE_CMDLINE_HELP", "{0} ({1})", commandLineId, interplationName);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_FRAME_DIMENSIONS_MISMATCH(@Nonnull String imageFile, int sourceWidth, int sourceHeight, int replaceWidth, int replaceHeight) {
        return I.msg("REPLACE_FRAME_DIMENSIONS_MISMATCH", "Replacement frame file {0} dimensions {1,number,#}x{2,number,#} do not match frame to replace dimensions {3,number,#}x{4,number,#}", imageFile, sourceWidth, sourceHeight, replaceWidth, replaceHeight);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_BITSTREAM_MISMATCH(@Nonnull File bitstreamFile) {
        return I.msg("REPLACE_BITSTREAM_MISMATCH", "Bitstream frame file {0} type does not match existing frame type", bitstreamFile);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_INCOMPATIBLE_MDEC(@Nonnull String mdecFileName, @Nonnull String frameNumber) {
        return I.msg("REPLACE_INCOMPATIBLE_MDEC", "Incompatible mdec file {0} for frame {1}", mdecFileName, frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_INCOMPLETE_MDEC(@Nonnull String mdecFileName, @Nonnull String frameNumber) {
        return I.msg("REPLACE_INCOMPLETE_MDEC", "Incomplete mdec file {0} for frame {1}", mdecFileName, frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_CORRUPTED_MDEC(@Nonnull String mdecFileName, @Nonnull String frameNumber) {
        return I.msg("REPLACE_CORRUPTED_MDEC", "Corrupted mdec file {0} for frame {1}", mdecFileName, frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_INVALID_IMAGE_FORMAT(@Nonnull String badFormatName) {
        return I.msg("REPLACE_INVALID_IMAGE_FORMAT", "Invalid replacement image format {0}", badFormatName);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_FILE_NOT_JAVA_IMAGE(@Nonnull File fileName) {
        return I.msg("REPLACE_FILE_NOT_JAVA_IMAGE", "Unable to read {0} as an image. Did you forget ''format'' option in the XML?", fileName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_UNABLE_TO_IDENTIFY_FRAME_TYPE() {
        return I.msg("CMD_UNABLE_TO_IDENTIFY_FRAME_TYPE", "Unable to identify frame type", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_UNABLE_TO_COMPRESS_FRAME_SMALL_ENOUGH(@Nonnull String frameNumber, int maxSize) {
        return I.msg("CMD_UNABLE_TO_COMPRESS_FRAME_SMALL_ENOUGH", "Unable to compress frame {0} small enough to fit in {1,number,#} bytes", frameNumber, maxSize);
    }

    @Nonnull
    public static ILocalizedMessage CMD_NO_DIFFERENCE_SKIPPING(@Nonnull String frameNumber) {
        return I.msg("CMD_NO_DIFFERENCE_SKIPPING", "No differences found in frame {0}, skipping.", frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage CMD_REPLACE_FOUND_DIFFERENT_MACRO_BLOCKS(int differenceCount) {
        return I.msg("CMD_REPLACE_FOUND_DIFFERENT_MACRO_BLOCKS", "Found {0,number,#} different macroblocks (16x16)", differenceCount);
    }

    @Nonnull
    public static ILocalizedMessage CMD_ENTIRE_FRAME_DIFFERENT() {
        return I.msg("CMD_ENTIRE_FRAME_DIFFERENT", "Warning: Entire frame is different.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_UNABLE_READ_IMAGE(@Nonnull String fileName) {
        return I.msg("REPLACE_UNABLE_READ_IMAGE", "Unable to load {0} as image", fileName);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_FRAME_DIMENSIONS_TOO_SMALL(int newWidth, int newHeight, int existingWidth, int existingHeight) {
        return I.msg("REPLACE_FRAME_DIMENSIONS_TOO_SMALL", "Replacement frame dimensions {0,number,#}x{1,number,#} are smaller than source frame {2,number,#}x{3,number,#}", newWidth, newHeight, existingWidth, existingHeight);
    }

    @Nonnull
    public static ILocalizedMessage CMD_REPLACING_FRAME_WITH_FILE(@Nonnull String frameNumber, @Nonnull File fileName) {
        return I.msg("CMD_REPLACING_FRAME_WITH_FILE", "Replacing frame {0} with {1}", frameNumber, fileName);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_FRAME_XML_ERROR(@Nonnull String xmlErrorInEnglish) {
        return I.msg("REPLACE_FRAME_XML_ERROR", "Error with frame replacement xml: {0}", xmlErrorInEnglish);
    }

    @Nonnull
    public static ILocalizedMessage CMD_REPLACE_XML_INVALID_ROOT_NODE(@Nonnull String xmlRootNodeName) {
        return I.msg("CMD_REPLACE_XML_INVALID_ROOT_NODE", "Invalid root node {0}", xmlRootNodeName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_REPLACE_XML_INVALID_VERSION(@Nonnull String versionNumber) {
        return I.msg("CMD_REPLACE_XML_INVALID_VERSION", "Invalid version {0}", versionNumber);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_FRAME_TYPE_NOT_V2_V3() {
        return I.msg("REPLACE_FRAME_TYPE_NOT_V2_V3", "Frame type is not STRv2 or STRv3", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_FRAME_TYPE_NOT_V2() {
        return I.msg("REPLACE_FRAME_TYPE_NOT_V2", "Frame type is not STRv2", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_FRAME_TYPE_NOT_IKI() {
        return I.msg("REPLACE_FRAME_TYPE_NOT_IKI", "Frame type is not iki", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NOT_IKI() {
        return I.msg("FRAME_NOT_IKI", "Frame is not Iki format", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NOT_LAIN() {
        return I.msg("FRAME_NOT_LAIN", "Frame is not Lain format", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NOT_STRV1() {
        return I.msg("FRAME_NOT_STRV1", "Frame is not STRv1 format", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NOT_STRV2() {
        return I.msg("FRAME_NOT_STRV2", "Frame is not STRv2 format", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NOT_STRV3() {
        return I.msg("FRAME_NOT_STRV3", "Frame is not STRv3 format", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_IS_NOT_BITSTREAM_FORMAT(@Nonnull String frameFormatName) {
        return I.msg("FRAME_IS_NOT_BITSTREAM_FORMAT", "Frame is not {0} format", frameFormatName);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_FRAME_IKI_DIMENSIONS_MISMATCH(int sourceWidth, int sourceHeight, int replaceWidth, int replaceHeight) {
        return I.msg("REPLACE_FRAME_IKI_DIMENSIONS_MISMATCH", "Iki frame dimensions do not match sector dimensions: {0,number,#}x{1,number,#} != {2,number,#}x{3,number,#}", sourceWidth, sourceHeight, replaceWidth, replaceHeight);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_FRAME_TYPE_NOT_LAIN() {
        return I.msg("REPLACE_FRAME_TYPE_NOT_LAIN", "Incompatible frame data for Lain", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage UNEXPECTED_END_OF_AUDIO() {
        return I.msg("UNEXPECTED_END_OF_AUDIO", "Unexpected end of audio data", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage IKI_REDUCING_QSCALE_OF_MB_TO_VAL(int macroBlockX, int macroBlockY, int quantizationScale) {
        return I.msg("IKI_REDUCING_QSCALE_OF_MB_TO_VAL", "Trying to reduce quantization scale of macroblock ({0,number,#},{1,number,#}) to {2,number,#}", macroBlockX, macroBlockY, quantizationScale);
    }

    @Nonnull
    public static ILocalizedMessage IKI_NEW_FRAME_GT_SRC_STOPPING(@Nonnull String frameNumber, int demuxSize, int sourceSize) {
        return I.msg("IKI_NEW_FRAME_GT_SRC_STOPPING", "New frame {0} demux size {1,number,#} > max source {2,number,#}, so stopping", frameNumber, demuxSize, sourceSize);
    }

    @Nonnull
    public static ILocalizedMessage NEW_FRAME_FITS(@Nonnull String frameNumber, int demuxSize, int sourceSize) {
        return I.msg("NEW_FRAME_FITS", "New frame {0} replacement size {1,number,#} fits within the existing available size {2,number,#}", frameNumber, demuxSize, sourceSize);
    }

    @Nonnull
    public static ILocalizedMessage TRYING_QSCALE(int quantizationScale) {
        return I.msg("TRYING_QSCALE", "Trying {0,number,#}", quantizationScale);
    }

    @Nonnull
    public static ILocalizedMessage END_OF_STREAM() {
        return I.msg("END_OF_STREAM", "End of stream", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage TRYING_LUMA_CHROMA(int lumaQuantizationScale, int chromaQuantizationScale) {
        return I.msg("TRYING_LUMA_CHROMA", "Trying to compress with luma quantization scale {0,number,#} and chroma quantization scale {1,number,#}", lumaQuantizationScale, chromaQuantizationScale);
    }

    @Nonnull
    public static ILocalizedMessage NEW_FRAME_DOES_NOT_FIT(@Nonnull String frameNumber, int newFrameSize, int sourceFrameSize) {
        return I.msg("NEW_FRAME_DOES_NOT_FIT", "New frame {0} replacement size {1,number,#} does not fit in the existing available size {2,number,#}", frameNumber, newFrameSize, sourceFrameSize);
    }

    @Nonnull
    public static ILocalizedMessage COMPRESS_TOO_MUCH_ENERGY(@Nonnull String frameNumber) {
        return I.msg("COMPRESS_TOO_MUCH_ENERGY", "Replacement image for frame {0} is too detailed to compress", frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage INCONSISTENT_WIDTH(int currentWidth, int newWidth) {
        return I.msg("INCONSISTENT_WIDTH", "Inconsistent width {0,number,#} != {1,number,#}", currentWidth, newWidth);
    }

    @Nonnull
    public static ILocalizedMessage INCONSISTENT_HEIGHT(int currentHeight, int newHeight) {
        return I.msg("INCONSISTENT_HEIGHT", "Inconsistent height {0,number,#} != {1,number,#}", currentHeight, newHeight);
    }

    @Nonnull
    public static ILocalizedMessage CMD_EMBEDDED_PACKET_BASED_AUDIO_HZ(int audioSampleRate) {
        return I.msg("CMD_EMBEDDED_PACKET_BASED_AUDIO_HZ", "Embedded audio {0,number,#} Hz", audioSampleRate);
    }

    @Nonnull
    public static ILocalizedMessage CRUSADER_VIDEO_CORRUPTED() {
        return I.msg("CRUSADER_VIDEO_CORRUPTED", "Crusader: No Remorse video is corrupted", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage POLICENAUTS_DATA_CORRUPTION() {
        return I.msg("POLICENAUTS_DATA_CORRUPTION", "Policenauts data corruption", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage EA_VIDEO_DATA_CORRUPTION() {
        return new _PlaceholderMessage("EA video data corruption");
    }

    @Nonnull
    public static ILocalizedMessage CRUSADER_AUDIO_CORRUPTED() {
        return I.msg("CRUSADER_AUDIO_CORRUPTED", "Crusader: No Remorse audio is corrupted", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage MISSING_CHUNK(@Nonnull String frameNumber, int chunkNumber) {
        return I.msg("MISSING_CHUNK", "Frame {0} chunk {1,number,#} missing.", frameNumber, chunkNumber);
    }

    @Nonnull
    public static ILocalizedMessage DEMUX_FRAME_CHUNKS_CHANGED_FROM_TO(int sectorNumber, int currentChunkCount, int newChunkCount) {
        return I.msg("DEMUX_FRAME_CHUNKS_CHANGED_FROM_TO", "Sector {0,number,#} chunks in frame changed from {1,number,#} to {2,number,#}", sectorNumber, currentChunkCount, newChunkCount);
    }

    @Nonnull
    public static ILocalizedMessage DEMUX_CHUNK_NUM_GTE_CHUNKS_IN_FRAME(int sectorNumber, int chunkNumber, int chunksInFrame) {
        return I.msg("DEMUX_CHUNK_NUM_GTE_CHUNKS_IN_FRAME", "Sector {0,number,#} chunk number {1,number,#} >= chunks in frame {2,number,#}", sectorNumber, chunkNumber, chunksInFrame);
    }

    @Nonnull
    public static ILocalizedMessage MISSING_CHUNK_FRAME_IN_SECTORS(int frameStartSector, int frameEndSector, int chunkNumber) {
        return I.msg("MISSING_CHUNK_FRAME_IN_SECTORS", "Frame in sectors {0,number,#}-{1,number,#} is missing chunk {2,number,#}", frameStartSector, frameEndSector, chunkNumber);
    }

    @Nonnull
    public static ILocalizedMessage CMD_FRAME_TO_REPLACE_MISSING_CHUNKS() {
        return I.msg("CMD_FRAME_TO_REPLACE_MISSING_CHUNKS", "Trying to replace an existing corrupted frame", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NUM_CORRUPTED(@Nonnull String frameNumber) {
        return I.msg("FRAME_NUM_CORRUPTED", "Error with frame {0}: Frame is corrupted", frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_CORRUPTED() {
        return I.msg("FRAME_CORRUPTED", "Error: Frame is corrupted", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NUM_INCOMPLETE(@Nonnull String frameNumber) {
        return I.msg("FRAME_NUM_INCOMPLETE", "Error with frame {0}: Frame is incomplete", frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_INCOMPLETE() {
        return I.msg("FRAME_INCOMPLETE", "Error: Frame is incomplete", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage UNABLE_TO_DETERMINE_FRAME_TYPE_FRM(@Nonnull String frameNumber) {
        return I.msg("UNABLE_TO_DETERMINE_FRAME_TYPE_FRM", "Error with frame {0}: Unable to determine frame type.", frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage UNABLE_TO_DETERMINE_FRAME_TYPE() {
        return I.msg("UNABLE_TO_DETERMINE_FRAME_TYPE", "Error: Unable to determine frame type.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_NUM_AHEAD_OF_READING(@Nonnull String frameNumber, int frameCount) {
        return I.msg("FRAME_NUM_AHEAD_OF_READING", "Presentation time of frame {0} in video file will be {1,number,#} {1,choice,1#frame|2#frames} ahead of original timing", frameNumber, frameCount);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_AHEAD_OF_READING(int frameCount) {
        return I.msg("FRAME_AHEAD_OF_READING", "Presentation time of frame in video file will be {0,number,#} {0,choice,1#frame|2#frames} ahead of original timing", frameCount);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_FILE_WRITE_UNABLE(@Nonnull String fileName, @Nonnull String frameNumber) {
        return I.msg("FRAME_FILE_WRITE_UNABLE", "Unable to write frame file {0} for frame {1}", fileName, frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage VIDEO_FMT_IDENTIFIED(@Nonnull String formatIdentifier) {
        return I.msg("VIDEO_FMT_IDENTIFIED", "Video format identified as {0}", formatIdentifier);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_UNCOMPRESS_ERR(@Nonnull String frameNumber) {
        return I.msg("FRAME_UNCOMPRESS_ERR", "Error uncompressing frame {0}", frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage JPEG_ENCODER_FRAME_FAIL(@Nonnull String frameNumber) {
        return I.msg("JPEG_ENCODER_FRAME_FAIL", "The simple jPSXdec JPEG encoder can''t handle frame {0}. Please save in a different format.", frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage JPEG_ENCODER_FRAME_FAIL_NO_FRAME() {
        return I.msg("JPEG_ENCODER_FRAME_FAIL_NO_FRAME", "The simple jPSXdec JPEG encoder can't handle frame. Please save in a different format.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage WRITING_BLANK_FRAMES_TO_ALIGN_AV(int frameCount) {
        return I.msg("WRITING_BLANK_FRAMES_TO_ALIGN_AV", "Writing {0,number,#} blank {0,choice,1#frame|2#frames} to align audio/video playback.", frameCount);
    }

    @Nonnull
    public static ILocalizedMessage WRITING_DUP_FRAMES_TO_ALIGN_AV(int frameCount) {
        return I.msg("WRITING_DUP_FRAMES_TO_ALIGN_AV", "Writing {0,number,#} duplicate {0,choice,1#frame|2#frames} to align audio/video playback.", frameCount);
    }

    @Nonnull
    public static ILocalizedMessage FRAME_WRITE_ERR(@Nonnull File fileName, @Nonnull String frameNumber) {
        return I.msg("FRAME_WRITE_ERR", "Error writing file {0} for frame {1}", fileName, frameNumber);
    }

    @Nonnull
    public static ILocalizedMessage WRITING_SILECE_TO_SYNC_AV(long sampleCount) {
        return I.msg("WRITING_SILECE_TO_SYNC_AV", "Writing {0,number,#} samples of silence to align audio/video playback.", sampleCount);
    }

    @Nonnull
    public static ILocalizedMessage WRITING_SILENCE_TO_KEEP_AV_SYNCED(long sampleCount) {
        return I.msg("WRITING_SILENCE_TO_KEEP_AV_SYNCED", "Adding {0,number,#} samples to keep audio in sync.", sampleCount);
    }

    @Nonnull
    public static ILocalizedMessage VID_IMG_SEQ_PNG_DESCRIPTION() {
        return I.msg("VID_IMG_SEQ_PNG_DESCRIPTION", "Image sequence: png", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_IMG_SEQ_PNG_COMMAND() {
        return I.msg("VID_IMG_SEQ_PNG_COMMAND", "png", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_AVI_MJPG_DESCRIPTION() {
        return I.msg("VID_AVI_MJPG_DESCRIPTION", "AVI: Compressed (MJPG)", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_AVI_MJPG_COMMAND() {
        return I.msg("VID_AVI_MJPG_COMMAND", "avi:mjpg", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_AVI_RGB_DESCRIPTION() {
        return I.msg("VID_AVI_RGB_DESCRIPTION", "AVI: Uncompressed RGB", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_AVI_RGB_COMMAND() {
        return I.msg("VID_AVI_RGB_COMMAND", "avi:rgb", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_IMG_SEQ_BMP_DESCRIPTION() {
        return I.msg("VID_IMG_SEQ_BMP_DESCRIPTION", "Image sequence: bmp", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_IMG_SEQ_BMP_COMMAND() {
        return I.msg("VID_IMG_SEQ_BMP_COMMAND", "bmp", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_IMG_SEQ_MDEC_DESCRIPTION() {
        return I.msg("VID_IMG_SEQ_MDEC_DESCRIPTION", "Image sequence: mdec", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_IMG_SEQ_MDEC_COMMAND() {
        return I.msg("VID_IMG_SEQ_MDEC_COMMAND", "mdec", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_IMG_SEQ_TIFF_COMMAND() {
        return new _PlaceholderMessage("tiff");
    }

    @Nonnull
    public static ILocalizedMessage VID_IMG_SEQ_TIFF_DESCRIPTION() {
        return new _PlaceholderMessage("Image sequence: tiff");
    }

    @Nonnull
    public static ILocalizedMessage VID_AVI_JYUV_DESCRIPTION() {
        return I.msg("VID_AVI_JYUV_DESCRIPTION", "AVI: YUV with [0-255] range", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_AVI_JYUV_COMMAND() {
        return I.msg("VID_AVI_JYUV_COMMAND", "avi:jyuv", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_IMG_SEQ_JPG_DESCRIPTION() {
        return I.msg("VID_IMG_SEQ_JPG_DESCRIPTION", "Image sequence: jpg", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_IMG_SEQ_JPG_COMMAND() {
        return I.msg("VID_IMG_SEQ_JPG_COMMAND", "jpg", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_IMG_SEQ_BS_DESCRIPTION() {
        return I.msg("VID_IMG_SEQ_BS_DESCRIPTION", "Image sequence: bitstream", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_IMG_SEQ_BS_COMMAND() {
        return I.msg("VID_IMG_SEQ_BS_COMMAND", "bs", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_AVI_YUV_DESCRIPTION() {
        return I.msg("VID_AVI_YUV_DESCRIPTION", "AVI: YUV", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_AVI_YUV_COMMAND() {
        return I.msg("VID_AVI_YUV_COMMAND", "avi:yuv", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VID_RANGE_OF_FILES_TO_SAVE(@Nonnull File startFileName, @Nonnull File endFileName) {
        return I.msg("VID_RANGE_OF_FILES_TO_SAVE", "{0}-{1}", startFileName, endFileName);
    }

    @Nonnull
    public static ILocalizedMessage SPU_EXTENSION_DESCRIPTION() {
        return I.msg("SPU_EXTENSION_DESCRIPTION", ".spu (vag without header = raw SPU data)", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage VAG_EXTENSION_DESCRIPTION() {
        return I.msg("VAG_EXTENSION_DESCRIPTION", ".vag ('Very Audio Good' format)", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DECODE_QUALITY(@Nonnull String qualityDescription) {
        return I.msg("CMD_DECODE_QUALITY", "Decode quality: {0}", qualityDescription);
    }

    @Nonnull
    public static ILocalizedMessage CMD_OUTPUT_FILES(@Nonnull File startFileName, @Nonnull File endFileName) {
        return I.msg("CMD_OUTPUT_FILES", "Output files: {0}-{1}", startFileName, endFileName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_SAVING_WITH_AUDIO_ITEMS() {
        return I.msg("CMD_SAVING_WITH_AUDIO_ITEMS", "With audio item(s):", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_EMULATE_PSX_AV_SYNC_NY(int willEmulate) {
        return I.msg("CMD_EMULATE_PSX_AV_SYNC_NY", "Emulate PSX audio/video sync: {0,choice,0#No|1#Yes}", willEmulate);
    }

    @Nonnull
    public static ILocalizedMessage CMD_NO_AUDIO() {
        return I.msg("CMD_NO_AUDIO", "No audio", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_UPSAMPLE_QUALITY(@Nonnull String upsampleDescription) {
        return I.msg("CMD_UPSAMPLE_QUALITY", "Chroma upsampling: {0}", upsampleDescription);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_FORMAT(@Nonnull String videoFormatDescription) {
        return I.msg("CMD_VIDEO_FORMAT", "Video format: {0}", videoFormatDescription);
    }

    @Nonnull
    public static ILocalizedMessage CMD_FRAME_RANGE_BEFORE(@Nonnull String startFrame) {
        return I.msg("CMD_FRAME_RANGE_BEFORE", "Skip frames before {0}", startFrame);
    }

    @Nonnull
    public static ILocalizedMessage CMD_FRAME_RANGE_AFTER(@Nonnull String endFrame) {
        return I.msg("CMD_FRAME_RANGE_AFTER", "Skip frames after {0}", endFrame);
    }

    @Nonnull
    public static ILocalizedMessage CMD_CROPPING(int willCrop) {
        return I.msg("CMD_CROPPING", "Cropping: {0,choice,0#No|1#Yes}", willCrop);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_MUST_HAVE_EVEN_DIMS(@Nonnull String videoFormatDescription) {
        return I.msg("CMD_VIDEO_MUST_HAVE_EVEN_DIMS", "Video must have even dimensions to save as {0}, increasing size by 1 pixel", videoFormatDescription);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DIMENSIONS(int width, int height) {
        return I.msg("CMD_DIMENSIONS", "Dimensions: {0,number,#}x{1,number,#}", width, height);
    }

    @Nonnull
    public static ILocalizedMessage AVI_CLOSE_ERR() {
        return I.msg("AVI_CLOSE_ERR", "Error closing AVI", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_OUTPUT_FILE(@Nonnull File fileName) {
        return I.msg("CMD_OUTPUT_FILE", "Output file: {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DISC_SPEED(int discSpeed, double framesPerSecond) {
        return I.msg("CMD_DISC_SPEED", "Disc speed: {0,choice,1#1x|2#2x} ({1,number,#.###} fps)", discSpeed, framesPerSecond);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_DS() {
        return I.msg("CMD_VIDEO_DS", "-ds <disc speed>", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_DS_HELP() {
        return I.msg("CMD_VIDEO_DS_HELP", "Specify 1 or 2 if disc speed is unknown.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_UP() {
        return I.msg("CMD_VIDEO_UP", "-up <upsampling>", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_UP_HELP(@Nonnull ILocalizedMessage defaultUpsamplingMethod) {
        return I.msg("CMD_VIDEO_UP_HELP", "Chroma upsampling method\n(default {0}). Options:", defaultUpsamplingMethod);
    }

    @Nonnull
    public static ILocalizedMessage CMD_UPSAMPLE_QUALITY_INVALID(@Nonnull String badQualityName) {
        return I.msg("CMD_UPSAMPLE_QUALITY_INVALID", "Invalid upsample quality {0}", badQualityName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_DECODE_QUALITY_INVALID(@Nonnull String badQualityName) {
        return I.msg("CMD_DECODE_QUALITY_INVALID", "Invalid decode quality {0}", badQualityName);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_QUALITY() {
        return I.msg("CMD_VIDEO_QUALITY", "-quality,-q <quality>", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_QUALITY_HELP(@Nonnull ILocalizedMessage defaultQuality) {
        return I.msg("CMD_VIDEO_QUALITY_HELP", "Decoding quality (default {0}). Options:", defaultQuality);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_NOCROP() {
        return I.msg("CMD_VIDEO_NOCROP", "-nocrop", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_NOCROP_HELP() {
        return I.msg("CMD_VIDEO_NOCROP_HELP", "Don't crop data around unused frame edges.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_FRAME_NUMBER_TYPE_INVALID(@Nonnull String badFrameNumberType) {
        return I.msg("CMD_FRAME_NUMBER_TYPE_INVALID", "Invalid frame number type {0}", badFrameNumberType);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_FRAMES() {
        return I.msg("CMD_VIDEO_FRAMES", "-start #, -end #", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_FRAMES_HELP() {
        return I.msg("CMD_VIDEO_FRAMES_HELP", "Process only frames in range.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_NUM() {
        return I.msg("CMD_VIDEO_NUM", "-num <type>", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_NUM_HELP(@Nonnull ILocalizedMessage frameNumberType) {
        return I.msg("CMD_VIDEO_NUM_HELP", "Frame number to use when saving image sequence\n(default {0}). Options:", frameNumberType);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_FORMAT_INVALID(@Nonnull String badFormatString) {
        return I.msg("CMD_VIDEO_FORMAT_INVALID", "Invalid video format {0}", badFormatString);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_VF() {
        return I.msg("CMD_VIDEO_VF", "-vidfmt,-vf <format>", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_VF_HELP(@Nonnull ILocalizedMessage defaultVideoFormat) {
        return I.msg("CMD_VIDEO_VF_HELP", "Output video format (default {0}).\nOptions:", defaultVideoFormat);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_HEADER_FRAME_NUMBER_UNSUPPORTED() {
        return I.msg("CMD_VIDEO_HEADER_FRAME_NUMBER_UNSUPPORTED", "Video does not support indexing frames by header frame number, -start -end -num ignored", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_FRAME_RANGE_INVALID(@Nonnull String badFrameNumberString) {
        return I.msg("CMD_FRAME_RANGE_INVALID", "Invalid frame(s) {0}", badFrameNumberString);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_NOAUD() {
        return I.msg("CMD_VIDEO_NOAUD", "-noaud", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_NOAUD_HELP() {
        return I.msg("CMD_VIDEO_NOAUD_HELP", "Don't save audio.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_SAVE_AUDIO_LABEL() {
        return I.msg("GUI_SAVE_AUDIO_LABEL", "Save audio:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_DECODE_QUALITY_LABEL() {
        return I.msg("GUI_DECODE_QUALITY_LABEL", "Decode quality:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_FPS_LABLE_WHOLE_NUMBER(long framesPerSecond) {
        return I.msg("GUI_FPS_LABLE_WHOLE_NUMBER", "{0,number,#} fps", framesPerSecond);
    }

    @Nonnull
    public static ILocalizedMessage GUI_FPS_LABEL_FRACTION(double decimalFramesPerSecond, long framesPerSecondNumerator, long framesPerSecondDenominator) {
        return I.msg("GUI_FPS_LABEL_FRACTION", "{0,number,#.###} ({1,number,#}/{2,number,#}) fps", decimalFramesPerSecond, framesPerSecondNumerator, framesPerSecondDenominator);
    }

    @Nonnull
    public static ILocalizedMessage GUI_DIMENSIONS_LABEL() {
        return I.msg("GUI_DIMENSIONS_LABEL", "Dimensions:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_DIMENSIONS_WIDTH_X_HEIGHT_LABEL(int width, int height) {
        return I.msg("GUI_DIMENSIONS_WIDTH_X_HEIGHT_LABEL", "{0,number,#}x{1,number,#}", width, height);
    }

    @Nonnull
    public static ILocalizedMessage GUI_OUTPUT_VIDEO_FILE_RANGE(@Nonnull File startFileName, @Nonnull File endFileName) {
        return I.msg("GUI_OUTPUT_VIDEO_FILE_RANGE", "{0}\nto: {1}", startFileName, endFileName);
    }

    @Nonnull
    public static ILocalizedMessage GUI_DISC_SPEED_LABEL() {
        return I.msg("GUI_DISC_SPEED_LABEL", "Disc speed:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage DISC_SPEED_1X() {
        return I.msg("DISC_SPEED_1X", "1x", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage DISC_SPEED_2X() {
        return I.msg("DISC_SPEED_2X", "2x", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_AUDIO_VOLUME_LABEL() {
        return I.msg("GUI_AUDIO_VOLUME_LABEL", "Audio volume:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_VIDEO_FORMAT_LABEL() {
        return I.msg("GUI_VIDEO_FORMAT_LABEL", "Video format:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_CROP_CHECKBOX() {
        return I.msg("GUI_CROP_CHECKBOX", "Crop", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_CHROMA_UPSAMPLING_LABEL() {
        return I.msg("GUI_CHROMA_UPSAMPLING_LABEL", "Chroma upsampling:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_PSXAV() {
        return I.msg("CMD_VIDEO_PSXAV", "-psxav", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_VIDEO_PSXAV_HELP() {
        return I.msg("CMD_VIDEO_PSXAV_HELP", "Emulate PSX audio/video timing.", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_EMULATE_PSX_AV_SYNC_LABEL() {
        return I.msg("GUI_EMULATE_PSX_AV_SYNC_LABEL", "Emulate PSX a/v sync:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_VID_AUDIO_SAVE_ID_COLUMN() {
        return I.msg("GUI_VID_AUDIO_SAVE_ID_COLUMN", "", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_COPY_TO_CLIPBOARD_TOOLTIP() {
        return I.msg("GUI_COPY_TO_CLIPBOARD_TOOLTIP", "Copy to clipboard", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_PALETTE_IMAGE_SAVE_FAIL(@Nonnull File outputFile, int paletteIndex) {
        return I.msg("CMD_PALETTE_IMAGE_SAVE_FAIL", "Unable to write image file {0} for palette {1,number,#}", outputFile, paletteIndex);
    }

    @Nonnull
    public static ILocalizedMessage CMD_TIM_SAVE_FORMAT(@Nonnull String fileFormat) {
        return I.msg("CMD_TIM_SAVE_FORMAT", "Format: {0}", fileFormat);
    }

    @Nonnull
    public static ILocalizedMessage CMD_TIM_SAVE_FORMAT_INVALID(@Nonnull String badFileFormat) {
        return I.msg("CMD_TIM_SAVE_FORMAT_INVALID", "Invalid format {0}", badFileFormat);
    }

    @Nonnull
    public static ILocalizedMessage CMD_TIM_PALETTE_LIST_INVALID(@Nonnull String badPaletteList) {
        return I.msg("CMD_TIM_PALETTE_LIST_INVALID", "Invalid list of palettes {0}", badPaletteList);
    }

    @Nonnull
    public static ILocalizedMessage CMD_TIM_PAL() {
        return I.msg("CMD_TIM_PAL", "-pal <#,#-#>", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_TIM_PAL_HELP() {
        return I.msg("CMD_TIM_PAL_HELP", "Palettes to save (default all).", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_TIM_IF() {
        return I.msg("CMD_TIM_IF", "-imgfmt,-if <format>", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_TIM_IF_HELP(@Nonnull String defaultImageFormat) {
        return I.msg("CMD_TIM_IF_HELP", "Output image format (default {0}). Options:", defaultImageFormat);
    }

    @Nonnull
    public static ILocalizedMessage CMD_TIM_PALETTE_FILES(@Nonnull ILocalizedMessage ouputFiles) {
        return I.msg("CMD_TIM_PALETTE_FILES", "Palette files: {0}", ouputFiles);
    }

    @Nonnull
    public static ILocalizedMessage TIM_OUTPUT_FILES(int fileCount, @Nonnull String startFileName, @Nonnull String endFileName) {
        return I.msg("TIM_OUTPUT_FILES", "{0,number,#} files between {1}-{2}", fileCount, startFileName, endFileName);
    }

    @Nonnull
    public static ILocalizedMessage TIM_OUTPUT_FILES_NONE() {
        return I.msg("TIM_OUTPUT_FILES_NONE", "None", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage TIM_DATA_NOT_FOUND() {
        return I.msg("TIM_DATA_NOT_FOUND", "TIM image data not found", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_TIM_SAVE_FORMAT_LABEL() {
        return I.msg("GUI_TIM_SAVE_FORMAT_LABEL", "Format:", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage GUI_TIM_ERR_READING_PREVIEW(@Nonnull String listOfSourceCodeLineNumbers) {
        return I.msg("GUI_TIM_ERR_READING_PREVIEW", "Error reading TIM preview\n{0}", listOfSourceCodeLineNumbers);
    }

    @Nonnull
    public static ILocalizedMessage CMD_TIM_REPLACE_SECTOR_BYTES(int byteCount, int sectorNumber) {
        return I.msg("CMD_TIM_REPLACE_SECTOR_BYTES", "Writing {0,number,#} bytes to sector {1,number,#}", byteCount, sectorNumber);
    }

    @Nonnull
    public static ILocalizedMessage GUI_TIM_IMAGE_DETAILS(int timWidth, int timHeight, int paletteCount) {
        return I.msg("GUI_TIM_IMAGE_DETAILS", "{0,number,#}x{1,number,#}, Palettes: {2,number,#}", timWidth, timHeight, paletteCount);
    }

    @Nonnull
    public static ILocalizedMessage TIM_INCOMPATIBLE(@Nonnull String newTimFormatDescription, @Nonnull String existingFormatDescription) {
        return I.msg("TIM_INCOMPATIBLE", "New TIM format \"{0}\" does not match existing TIM format \"{1}\"", newTimFormatDescription, existingFormatDescription);
    }

    @Nonnull
    public static ILocalizedMessage TIM_REPLACE_MULTI_CLUT_UNABLE() {
        return I.msg("TIM_REPLACE_MULTI_CLUT_UNABLE", "Unable to replace a multi-paletted TIM with a simple image", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage CMD_INVALID_VALUE_FOR_CMD(@Nonnull String invalidValue, @Nonnull String command) {
        return I.msg("CMD_INVALID_VALUE_FOR_CMD", "Invalid value \"{0}\" for {1}", invalidValue, command);
    }

    @Nonnull
    public static ILocalizedMessage CMD_IGNORING_INVALID_VALUE_FOR_CMD(@Nonnull String invalidValue, @Nonnull String command) {
        return I.msg("CMD_IGNORING_INVALID_VALUE_FOR_CMD", "Ignoring invalid value \"{0}\" for {1}", invalidValue, command);
    }

    @Nonnull
    public static ILocalizedMessage IO_OPENING_FILE(@Nonnull String fileName) {
        return I.msg("IO_OPENING_FILE", "Opening file {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage IO_OPENING_FILE_NOT_FOUND() {
        return I.msg("IO_OPENING_FILE_NOT_FOUND", "File not found", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage IO_OPENING_FILE_NOT_FOUND_NAME(@Nonnull String fileName) {
        return I.msg("IO_OPENING_FILE_NOT_FOUND_NAME", "File not found {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage IO_OPENING_FILE_ERROR() {
        return I.msg("IO_OPENING_FILE_ERROR", "Failed to open file", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage IO_OPENING_FILE_ERROR_NAME(@Nonnull String fileName) {
        return I.msg("IO_OPENING_FILE_ERROR_NAME", "Failed to open file {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage IO_READING_FILE_ERROR() {
        return I.msg("IO_READING_FILE_ERROR", "Error reading file", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage IO_READING_FILE_ERROR_NAME(@Nonnull String fileName) {
        return I.msg("IO_READING_FILE_ERROR_NAME", "Error reading file {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage IO_READING_FROM_FILE_ERROR() {
        return I.msg("IO_READING_FROM_FILE_ERROR", "Error reading from file", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage IO_READING_FROM_FILE_ERROR_NAME(@Nonnull String fileName) {
        return I.msg("IO_READING_FROM_FILE_ERROR_NAME", "Error reading from file {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage IO_WRITING_FILE(@Nonnull String fileName) {
        return I.msg("IO_WRITING_FILE", "Writing file {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage IO_WRITING_FILE_ERROR() {
        return I.msg("IO_WRITING_FILE_ERROR", "Error writing file", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage IO_WRITING_FILE_ERROR_NAME(@Nonnull String fileName) {
        return I.msg("IO_WRITING_FILE_ERROR_NAME", "Error writing file {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage IO_WRITING_TO_FILE_ERROR() {
        return I.msg("IO_WRITING_TO_FILE_ERROR", "Error writing to file", new Object[0]);
    }

    @Nonnull
    public static ILocalizedMessage IO_WRITING_TO_FILE_ERROR_NAME(@Nonnull String fileName) {
        return I.msg("IO_WRITING_TO_FILE_ERROR_NAME", "Error writing to file {0}", fileName);
    }

    @Nonnull
    public static ILocalizedMessage CANNOT_CREATE_DIR_OVER_FILE(@Nonnull File existingFileName) {
        return I.msg("CANNOT_CREATE_DIR_OVER_FILE", "Cannot create directory over a file {0}", existingFileName);
    }

    @Nonnull
    public static ILocalizedMessage UNABLE_TO_CREATE_DIR(@Nonnull File directoryName) {
        return I.msg("UNABLE_TO_CREATE_DIR", "Unable to create directory {0}", directoryName);
    }

    @Nonnull
    public static ILocalizedMessage DIR_DOES_NOT_EXIST(@Nonnull String directoryName) {
        return I.msg("DIR_DOES_NOT_EXIST", "Directory {0} does not exist.", directoryName);
    }

    @Nonnull
    public static ILocalizedMessage REPLACE_XML_INVALID_SIZE_LIMIT(@Nonnull String invalidSize, @Nonnull String expectedSize) {
        return new _PlaceholderMessage("Invalid size \"{0}\", expected \"{1}\"", invalidSize, expectedSize);
    }

    @Nonnull
    public static ILocalizedMessage TIM_HAS_ISSUES_CAN_BE_EXTRACTED(@Nonnull String timDescription) {
        return new _PlaceholderMessage("This Tim image contains inconsistant data, but can still be extracted: {0}", timDescription);
    }

    @Nonnull
    public static ILocalizedMessage CMD_REPLACEXA_MISSING_XA_OPTION() {
        return new _PlaceholderMessage("-replacexa option missing -xa option");
    }
}

