/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.i18n;

import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.log.ILocalizedLogger;

public class FeedbackStream {
    private static final Logger LOG = Logger.getLogger(FeedbackStream.class.getName());
    public static final int MORE = 4;
    public static final int NORM = 3;
    public static final int WARN = 2;
    public static final int ERR = 1;
    public static final int NONE = 0;
    private int _iVerboseLevel;
    private final PrintStream _ps;

    public FeedbackStream() {
        this(System.out, 3);
    }

    public FeedbackStream(@Nonnull PrintStream ps, int iVerboseLevel) {
        this._ps = ps;
        this._iVerboseLevel = iVerboseLevel;
    }

    public void println() {
        if (this._iVerboseLevel >= 3) {
            this._ps.println();
        }
    }

    public void printSpaces(int iCount) {
        if (this._iVerboseLevel >= 3) {
            for (int i = 0; i < iCount; ++i) {
                this._ps.print(' ');
            }
        }
    }

    public void print(@Nonnull ILocalizedMessage s) {
        if (this._iVerboseLevel >= 3) {
            this._ps.print(s.getLocalizedMessage());
        }
    }

    public void println(@Nonnull ILocalizedMessage s) {
        if (this._iVerboseLevel >= 3) {
            this._ps.println(s.getLocalizedMessage());
        }
    }

    public void printMore(@Nonnull ILocalizedMessage s) {
        if (this._iVerboseLevel >= 4) {
            this._ps.print(s.getLocalizedMessage());
        }
    }

    public void printlnMore(@Nonnull ILocalizedMessage s) {
        if (this._iVerboseLevel >= 4) {
            this._ps.println(s.getLocalizedMessage());
        }
    }

    public void printWarn(@Nonnull ILocalizedMessage s) {
        if (this._iVerboseLevel >= 2) {
            this._ps.print(s.getLocalizedMessage());
        }
    }

    public void printlnWarn(@Nonnull ILocalizedMessage s) {
        if (this._iVerboseLevel >= 2) {
            this._ps.println(s.getLocalizedMessage());
        }
    }

    public void printErr(@Nonnull ILocalizedMessage s) {
        if (this._iVerboseLevel >= 1) {
            this._ps.print(s.getLocalizedMessage());
        }
    }

    public void printlnErr(@Nonnull ILocalizedMessage s) {
        if (this._iVerboseLevel >= 1) {
            this._ps.println(s.getLocalizedMessage());
        }
    }

    public void setLevel(int iMore) {
        this._iVerboseLevel = iMore;
    }

    public int getLevel() {
        return this._iVerboseLevel;
    }

    @Nonnull
    public PrintStream getUnderlyingStream() {
        return this._ps;
    }

    @Nonnull
    public ILocalizedLogger makeLogger() {
        return new FbsLogger();
    }

    private class FbsLogger
    implements ILocalizedLogger {
        private FbsLogger() {
        }

        @Override
        public void log(@Nonnull Level level, @Nonnull ILocalizedMessage msg) {
            this.log(level, msg, null);
        }

        @Override
        public void log(@Nonnull Level level, @Nonnull ILocalizedMessage msg, @CheckForNull Throwable debugException) {
            LOG.log(level, msg.getEnglishMessage(), debugException);
            if (level.intValue() < Level.INFO.intValue() || level.intValue() == Level.ALL.intValue() || level.intValue() == Level.CONFIG.intValue()) {
                FeedbackStream.this.printlnMore(msg);
            } else if (level.intValue() < Level.WARNING.intValue()) {
                FeedbackStream.this.println(msg);
            } else if (level.intValue() < Level.SEVERE.intValue()) {
                FeedbackStream.this.printlnWarn(msg);
            } else if (level.intValue() >= Level.SEVERE.intValue() && level.intValue() != Level.OFF.intValue()) {
                FeedbackStream.this.printlnErr(msg);
            }
        }
    }
}

