/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.gui;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.gui.SavingGuiTable;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.exception.LoggedFailure;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.i18n.log.UserFriendlyLogger;
import jpsxdec.util.TaskCanceledException;
import org.jdesktop.swingworker.SwingWorker;

public class SavingGuiTask
extends SwingWorker<Void, Event_Message>
implements UserFriendlyLogger.OnWarnErr {
    public static final String ALL_DONE = "alldone";
    @Nonnull
    private final ArrayList<SavingGuiTable.Row> _rows;
    @CheckForNull
    private final File _outputDir;
    @CheckForNull
    private SavingGuiTable.Row _currentRow;
    final ProgressLogger _progressLog = new ProgressLogger(I.SAVE_LOG_FILE_BASE_NAME().getLocalizedMessage()){

        @Override
        protected void handleProgressStart() throws TaskCanceledException {
            if (SavingGuiTask.this.isCancelled()) {
                throw new TaskCanceledException();
            }
            if (SavingGuiTask.this._currentRow != null) {
                EventQueue.invokeLater(new Event_Progress(SavingGuiTask.this._currentRow, 0));
            }
        }

        @Override
        protected void handleProgressEnd() throws TaskCanceledException {
            if (SavingGuiTask.this._currentRow != null) {
                EventQueue.invokeLater(new Event_Progress(SavingGuiTask.this._currentRow, 100));
            }
        }

        @Override
        protected void handleProgressUpdate(double dblPercentComplete) throws TaskCanceledException {
            if (SavingGuiTask.this.isCancelled()) {
                throw new TaskCanceledException();
            }
            if (SavingGuiTask.this._currentRow != null) {
                EventQueue.invokeLater(new Event_Progress(SavingGuiTask.this._currentRow, (int)Math.round(dblPercentComplete * 100.0)));
            }
        }

        @Override
        public void event(@Nonnull ILocalizedMessage msg) {
            if (SavingGuiTask.this._currentRow != null) {
                SavingGuiTask.this.publish(new Event_Message[]{new Event_Message(SavingGuiTask.this._currentRow, msg)});
            }
        }

        @Override
        public boolean isSeekingEvent() {
            return true;
        }
    };

    public SavingGuiTask(@Nonnull ArrayList<SavingGuiTable.Row> rows, @Nonnull String sCd, @CheckForNull File outputDir) {
        this._rows = rows;
        this._outputDir = outputDir;
        this._progressLog.log(Level.INFO, new UnlocalizedMessage(sCd));
        this._progressLog.setListener(this);
    }

    @Override
    public void onWarn(@Nonnull ILocalizedMessage msg) {
        if (this._currentRow != null) {
            EventQueue.invokeLater(new Event_Warning(this._currentRow));
        }
    }

    @Override
    public void onErr(@Nonnull ILocalizedMessage msg) {
        if (this._currentRow != null) {
            EventQueue.invokeLater(new Event_Error(this._currentRow));
        }
    }

    @Override
    protected Void doInBackground() {
        Iterator<SavingGuiTable.Row> i$ = this._rows.iterator();
        while (i$.hasNext()) {
            SavingGuiTable.Row row;
            this._currentRow = row = i$.next();
            try {
                this._progressLog.log(Level.INFO, new UnlocalizedMessage(row._builder.getDiscItem().toString()));
                row._builder.startSave(this._progressLog, this._outputDir);
            }
            catch (TaskCanceledException ex) {
                EventQueue.invokeLater(new Event_Progress(row, -2));
                break;
            }
            catch (LoggedFailure ex) {
                EventQueue.invokeLater(new Event_Progress(row, -3));
                continue;
            }
            catch (Throwable ex) {
                this._progressLog.log(Level.SEVERE, I.GUI_UNHANDLED_ERROR(), ex);
                EventQueue.invokeLater(new Event_Progress(row, -3));
                if (!(ex instanceof InterruptedException)) continue;
                break;
            }
            EventQueue.invokeLater(new Event_Progress(row, 100));
        }
        this.firePropertyChange(ALL_DONE, null, null);
        this._progressLog.close();
        return null;
    }

    @Override
    protected final void process(@Nonnull List<Event_Message> events) {
        events.get(events.size() - 1).run();
    }

    public static class Event_Message
    extends Event {
        @Nonnull
        private final ILocalizedMessage _val;

        public Event_Message(@Nonnull SavingGuiTable.Row row, @Nonnull ILocalizedMessage val) {
            super(row);
            this._val = val;
        }

        @Override
        public void run() {
            this._row.setMessage(this._val.getLocalizedMessage());
        }
    }

    private static class Event_Progress
    extends Event {
        private final int _val;

        public Event_Progress(@Nonnull SavingGuiTable.Row row, int val) {
            super(row);
            this._val = val;
        }

        @Override
        public void run() {
            this._row.setProgress(this._val);
        }
    }

    private class Event_Error
    extends Event {
        public Event_Error(SavingGuiTable.Row row) {
            super(row);
        }

        @Override
        public void run() {
            this._row.incErr();
        }
    }

    private class Event_Warning
    extends Event {
        public Event_Warning(SavingGuiTable.Row row) {
            super(row);
        }

        @Override
        public void run() {
            this._row.incWarn();
        }
    }

    private static abstract class Event
    implements Runnable {
        @Nonnull
        protected final SavingGuiTable.Row _row;

        public Event(@Nonnull SavingGuiTable.Row row) {
            this._row = row;
        }

        @Override
        public abstract void run();
    }
}

