/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.gui;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;

public class SavingGuiTable
extends AbstractTableModel {
    public static final int PROGRESS_FAILED = -3;
    public static final int PROGRESS_CANCELED = -2;
    public static final int PROGRESS_WAITING = -1;
    public static final int PROGRESS_DONE = 100;
    public static final int PROGRESS_STARTED = 0;
    public final ArrayList<Row> _rows = new ArrayList();

    public SavingGuiTable(@Nonnull List<DiscItemSaverBuilder> builders, @Nonnull JTable table) {
        for (DiscItemSaverBuilder builder : builders) {
            this._rows.add(new Row(builder));
        }
        table.setModel(this);
        table.getColumnModel().getColumn(COLUMNS.Progress.ordinal()).setCellRenderer(new ProgressRenderer());
        table.getColumnModel().getColumn(COLUMNS.Warn.ordinal()).setCellRenderer(new WarnErrRenderer());
        table.getColumnModel().getColumn(COLUMNS.Err.ordinal()).setCellRenderer(new WarnErrRenderer());
        SavingGuiTable.autoResizeColWidth(table);
    }

    private void update(@Nonnull Row row, @Nonnull COLUMNS col) {
        this.fireTableCellUpdated(this._rows.indexOf(row), col.ordinal());
    }

    @Override
    public int getRowCount() {
        return this._rows.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.values().length;
    }

    @Override
    @CheckForNull
    public Object getValueAt(int rowIndex, int columnIndex) {
        return COLUMNS.values()[columnIndex].val(this._rows.get(rowIndex));
    }

    @Override
    @Nonnull
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMNS.values()[columnIndex]._type;
    }

    @Override
    @Nonnull
    public String getColumnName(int column) {
        return COLUMNS.values()[column]._name.getLocalizedMessage();
    }

    public static void autoResizeColWidth(@Nonnull JTable table) {
        table.setAutoResizeMode(0);
        int margin = 5;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int vColIndex = i;
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
            TableColumn col = colModel.getColumn(vColIndex);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            for (int r = 0; r < table.getRowCount(); ++r) {
                renderer = table.getCellRenderer(r, vColIndex);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            col.setPreferredWidth(width += 2 * margin);
        }
        ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        table.getTableHeader().setReorderingAllowed(false);
    }

    public class Row {
        @Nonnull
        public final DiscItemSaverBuilder _builder;
        private int Progress = 0;
        private int Warnings = 0;
        private int Errors = 0;
        @CheckForNull
        private String Message;

        private Row(DiscItemSaverBuilder builder) {
            this._builder = builder;
        }

        public void setProgress(int i) {
            if (i != this.Progress) {
                this.Progress = i;
                SavingGuiTable.this.update(this, COLUMNS.Progress);
            }
        }

        public void setMessage(@Nonnull String s) {
            if (!s.equals(this.Message)) {
                this.Message = s;
                SavingGuiTable.this.update(this, COLUMNS.Message);
            }
        }

        public void incWarn() {
            ++this.Warnings;
            SavingGuiTable.this.update(this, COLUMNS.Warn);
        }

        public void incErr() {
            ++this.Errors;
            SavingGuiTable.this.update(this, COLUMNS.Err);
        }
    }

    private static class ProgressRenderer
    extends DefaultTableCellRenderer {
        private final JProgressBar _bar = new JProgressBar(0, 100);

        public ProgressRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, @Nonnull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ILocalizedMessage text;
            int i = (Integer)value;
            if (i == -3) {
                text = I.GUI_SAVE_STATUS_FAILED();
            } else if (i == -2) {
                text = I.GUI_SAVE_STATUS_CANCELED();
            } else if (i == -1) {
                text = I.GUI_SAVE_STATUS_WAITING();
            } else if (i >= 100) {
                text = I.GUI_SAVE_STATUS_DONE();
            } else {
                this._bar.setValue(i);
                return this._bar;
            }
            return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
        }
    }

    private static class WarnErrRenderer
    extends DefaultTableCellRenderer {
        private WarnErrRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, @Nonnull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if ((Integer)value > 0) {
                this.setForeground(Color.red);
            }
            this.setHorizontalAlignment(0);
            return c;
        }
    }

    private static enum COLUMNS {
        Source((Class)String.class, I.GUI_SRC_COLUMN()){

            @Override
            Object val(Row row) {
                return row._builder.getInput();
            }
        }
        ,
        SaveAs((Class)String.class, I.GUI_SAVE_AS_COLUMN()){

            @Override
            Object val(Row row) {
                return row._builder.getOutputSummary();
            }
        }
        ,
        Progress((Class)Integer.class, I.GUI_PROGRESS_COLUMN()){

            @Override
            Object val(Row row) {
                return row.Progress;
            }
        }
        ,
        Message((Class)String.class, I.GUI_MESSAGE_COLUMN()){

            @Override
            Object val(Row row) {
                return row.Message;
            }
        }
        ,
        Warn((Class)Integer.class, I.GUI_WARN_COLUMN()){

            @Override
            Object val(Row row) {
                return row.Warnings;
            }
        }
        ,
        Err((Class)Integer.class, I.GUI_ERR_COLUMN()){

            @Override
            Object val(Row row) {
                return row.Errors;
            }
        };

        @Nonnull
        private final Class<?> _type;
        @Nonnull
        private final ILocalizedMessage _name;

        private COLUMNS(Class<?> type, ILocalizedMessage name) {
            this._type = type;
            this._name = name;
        }

        @CheckForNull
        abstract Object val(Row var1);

        public final String toString() {
            return this._name.getLocalizedMessage();
        }
    }
}

