/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.gui.SavingGuiTable;
import jpsxdec.gui.SavingGuiTask;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;

public class SavingGui
extends JDialog
implements PropertyChangeListener {
    private STATES _eState = STATES.NotStarted;
    @Nonnull
    private SavingGuiTask _saveAll;
    private JLabel _guiResultLbl;
    private JButton _guiStartCancelCloseBtn;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public SavingGui(@Nonnull Dialog parent, @Nonnull List<DiscItemSaverBuilder> builders, @Nonnull String sCd, @CheckForNull File outputDir) {
        super(parent, true);
        this.sharedConstructor(parent, builders, sCd, outputDir);
    }

    public SavingGui(@Nonnull Frame parent, @Nonnull List<DiscItemSaverBuilder> builders, @Nonnull String sCd, @CheckForNull File outputDir) {
        super(parent, true);
        this.sharedConstructor(parent, builders, sCd, outputDir);
    }

    private void sharedConstructor(@Nonnull Window parent, @Nonnull List<DiscItemSaverBuilder> builders, @Nonnull String sCd, @CheckForNull File outputDir) {
        this.initComponents();
        SavingGuiTable model = new SavingGuiTable(builders, this.jTable1);
        this.validate();
        this.pack();
        this.jScrollPane1.setPreferredSize(new Dimension(this.jTable1.getWidth() + 20, this.jScrollPane1.getHeight()));
        this.validate();
        this.pack();
        this.setLocationRelativeTo(parent);
        this._saveAll = new SavingGuiTask(model._rows, sCd, outputDir);
        this._saveAll.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(@Nonnull PropertyChangeEvent evt) {
        if ("alldone".equals(evt.getPropertyName())) {
            this._eState = STATES.Ended;
            this._guiStartCancelCloseBtn.setText(I.GUI_CLOSE_BTN().getLocalizedMessage());
            this._guiStartCancelCloseBtn.setEnabled(true);
            ILocalizedMessage result = this._saveAll.isCancelled() ? I.GUI_SAVE_STATUS_OVERALL_CANCELED(this._saveAll._progressLog.getFileName()) : I.GUI_SAVE_STATUS_OVERALL_COMPLETE(this._saveAll._progressLog.getFileName());
            this._guiResultLbl.setText(result.getLocalizedMessage());
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this._guiResultLbl = new JLabel();
        this._guiStartCancelCloseBtn = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SavingGui.this.formWindowClosing(evt);
            }
        });
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.setFocusable(false);
        this.jTable1.setSelectionMode(0);
        this.jTable1.setShowHorizontalLines(false);
        this.jTable1.setShowVerticalLines(false);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this._guiResultLbl.setText(" ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this._guiResultLbl, gridBagConstraints);
        this._guiStartCancelCloseBtn.setText(I.GUI_START_BTN().getLocalizedMessage());
        this._guiStartCancelCloseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavingGui.this._guiStartCancelCloseBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this._guiStartCancelCloseBtn, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void _guiStartCancelCloseBtnActionPerformed(ActionEvent evt) {
        switch (this._eState) {
            case NotStarted: {
                this._eState = STATES.Running;
                this._saveAll.execute();
                this._guiStartCancelCloseBtn.setText(I.GUI_CANCEL_BTN().getLocalizedMessage());
                break;
            }
            case Running: {
                this._eState = STATES.Canceling;
                this._saveAll.cancel(false);
                this._guiStartCancelCloseBtn.setEnabled(false);
                break;
            }
            case Canceling: {
                break;
            }
            case Ended: {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this._saveAll.cancel(true);
    }

    private static enum STATES {
        NotStarted,
        Running,
        Canceling,
        Ended;

    }
}

