/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.log.ProgressLogger;
import jpsxdec.i18n.log.UserFriendlyLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.util.TaskCanceledException;
import org.jdesktop.swingworker.SwingWorker;

public class IndexingGui
extends JDialog
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(IndexingGui.class.getName());
    @Nonnull
    private ProgresGuiTask _task;
    @CheckForNull
    private Throwable _exception;
    private int _iWarningCount;
    private int _iErrorCount;
    @CheckForNull
    public DiscIndex _index;
    @Nonnull
    public CdFileSectorReader _cd;
    @Nonnull
    private State _eState = State.NOT_STARTED;
    private JPanel _guiBottomPanel;
    private JButton _guiCancelBtn;
    private JLabel _guiErrorsCount;
    private JLabel _guiErrorsLbl;
    private JLabel _guiItemName;
    private JPanel _guiMarginPanel;
    private JProgressBar _guiProgress;
    private JLabel _guiProgressDescription;
    private JLabel _guiResultLbl;
    private JLabel _guiSavingLbl;
    private JLabel _guiWarningsCount;
    private JLabel _guiWarningsLbl;

    public IndexingGui(@Nonnull Dialog parent, @Nonnull CdFileSectorReader cd) {
        super(parent, true);
        this.sharedConstructor(parent, cd);
    }

    public IndexingGui(@Nonnull Frame parent, @Nonnull CdFileSectorReader cd) {
        super(parent, true);
        this.sharedConstructor(parent, cd);
    }

    private void sharedConstructor(@Nonnull Window parent, @Nonnull CdFileSectorReader cd) {
        this.initComponents();
        this.setMinimumSize(new Dimension(this.getWidth(), this.getHeight()));
        this.setPreferredSize(this.getMinimumSize());
        this.setLocationRelativeTo(parent);
        this._cd = cd;
        this._guiItemName.setText(cd.getSourceFile().getPath());
        this._guiResultLbl.setText("");
        this._task = new ProgresGuiTask();
        this._task.addPropertyChangeListener(this);
        this._guiCancelBtnActionPerformed(null);
    }

    @Override
    public void propertyChange(@Nonnull PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            this._guiProgress.setValue((Integer)evt.getNewValue());
        } else if ("exception".equals(evt.getPropertyName())) {
            this._exception = (Throwable)evt.getNewValue();
            this._exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, this._exception.toString(), I.GUI_INDEX_EXCEPTION_DIALOG_TITLE().getLocalizedMessage(), 0);
            this.taskComplete();
        } else if ("done".equals(evt.getPropertyName())) {
            this.taskComplete();
        }
    }

    private void taskComplete() {
        this._eState = State.ENDED;
        this._guiCancelBtn.setEnabled(true);
        this._guiCancelBtn.setText(I.GUI_CLOSE_BTN().getLocalizedMessage());
        if (this.wasCanceled()) {
            this._guiResultLbl.setText(I.GUI_INDEX_RESULT_CANCELED().getLocalizedMessage());
            this._guiResultLbl.setForeground(Color.orange);
        } else if (this.getException() != null) {
            this._guiResultLbl.setText(I.GUI_INDEX_RESULT_FAILURE(this._task.__progressLog.getFileName()).getLocalizedMessage());
            this._guiResultLbl.setForeground(Color.red);
        } else if (this._iWarningCount > 0 || this._iErrorCount > 0) {
            this._guiResultLbl.setText(I.GUI_INDEX_RESULT_OK_MSGS(this._task.__progressLog.getFileName()).getLocalizedMessage());
        } else {
            this._guiResultLbl.setText(I.GUI_INDEX_RESULT_SUCCESS().getLocalizedMessage());
        }
    }

    public boolean wasCanceled() {
        return this._task.isCancelled();
    }

    @CheckForNull
    public Throwable getException() {
        return this._exception;
    }

    @CheckForNull
    public DiscIndex getIndex() {
        return this._index;
    }

    private void initComponents() {
        this._guiMarginPanel = new JPanel();
        this._guiSavingLbl = new JLabel();
        this._guiItemName = new JLabel();
        this._guiProgressDescription = new JLabel();
        this._guiProgress = new JProgressBar();
        this._guiBottomPanel = new JPanel();
        this._guiWarningsLbl = new JLabel();
        this._guiWarningsCount = new JLabel();
        this._guiErrorsLbl = new JLabel();
        this._guiErrorsCount = new JLabel();
        this._guiCancelBtn = new JButton();
        this._guiResultLbl = new JLabel();
        this.setTitle(I.GUI_INDEX_TITLE().getLocalizedMessage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                IndexingGui.this.formWindowClosing(evt);
            }
        });
        this._guiMarginPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._guiMarginPanel.setLayout(new GridBagLayout());
        this._guiSavingLbl.setText(I.GUI_INDEXING_LABEL().getLocalizedMessage());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this._guiMarginPanel.add((Component)this._guiSavingLbl, gridBagConstraints);
        this._guiItemName.setText("1123456789012345678901234567890123456789012345678901234567890234567890");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this._guiMarginPanel.add((Component)this._guiItemName, gridBagConstraints);
        this._guiProgressDescription.setText("Doing something");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(17, 0, 5, 0);
        this._guiMarginPanel.add((Component)this._guiProgressDescription, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this._guiMarginPanel.add((Component)this._guiProgress, gridBagConstraints);
        this._guiBottomPanel.setLayout(new GridBagLayout());
        this._guiWarningsLbl.setHorizontalAlignment(4);
        this._guiWarningsLbl.setText(I.GUI_INDEX_WARNINGS_LABEL().getLocalizedMessage());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this._guiBottomPanel.add((Component)this._guiWarningsLbl, gridBagConstraints);
        this._guiWarningsCount.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this._guiBottomPanel.add((Component)this._guiWarningsCount, gridBagConstraints);
        this._guiErrorsLbl.setHorizontalAlignment(4);
        this._guiErrorsLbl.setText(I.GUI_INDEX_ERRORS_LABEL().getLocalizedMessage());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this._guiBottomPanel.add((Component)this._guiErrorsLbl, gridBagConstraints);
        this._guiErrorsCount.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this._guiBottomPanel.add((Component)this._guiErrorsCount, gridBagConstraints);
        this._guiCancelBtn.setText(I.GUI_START_BTN().getLocalizedMessage());
        this._guiCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndexingGui.this._guiCancelBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        this._guiBottomPanel.add((Component)this._guiCancelBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this._guiMarginPanel.add((Component)this._guiBottomPanel, gridBagConstraints);
        this._guiResultLbl.setText(I.GUI_INDEX_RESULT_SUCCESS().getLocalizedMessage());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this._guiMarginPanel.add((Component)this._guiResultLbl, gridBagConstraints);
        this.getContentPane().add((Component)this._guiMarginPanel, "Center");
        this.pack();
    }

    private void _guiCancelBtnActionPerformed(ActionEvent evt) {
        switch (this._eState) {
            case NOT_STARTED: {
                this._guiCancelBtn.setText(I.GUI_CANCEL_BTN().getLocalizedMessage());
                this._task.execute();
                this._eState = State.RUNNING;
                break;
            }
            case RUNNING: {
                this._task.cancel(false);
                this._guiCancelBtn.setEnabled(false);
                this._eState = State.CANCELING;
                break;
            }
            case ENDED: {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this._task.cancel(true);
    }

    private class ProgresGuiTask
    extends SwingWorker<Void, ILocalizedMessage>
    implements UserFriendlyLogger.OnWarnErr {
        public static final String PROGRESS_VALUE = "progress";
        public static final String EXCEPTION = "exception";
        public static final String DONE = "done";
        private final ProgressLogger __progressLog = new ProgressLogger("index"){

            @Override
            protected void handleProgressStart() throws TaskCanceledException {
                if (ProgresGuiTask.this.isCancelled()) {
                    throw new TaskCanceledException();
                }
                ProgresGuiTask.this.setProgress(0);
            }

            @Override
            protected void handleProgressEnd() throws TaskCanceledException {
                ProgresGuiTask.this.setProgress(100);
            }

            @Override
            protected void handleProgressUpdate(double dblPercentComplete) throws TaskCanceledException {
                if (ProgresGuiTask.this.isCancelled()) {
                    throw new TaskCanceledException();
                }
                ProgresGuiTask.this.setProgress((int)Math.round(dblPercentComplete * 100.0));
            }

            @Override
            public void event(@Nonnull ILocalizedMessage msg) {
                ProgresGuiTask.this.publish(new ILocalizedMessage[]{msg});
            }

            @Override
            public boolean isSeekingEvent() {
                return true;
            }
        };

        public ProgresGuiTask() {
            this.__progressLog.setListener(this);
            this.__progressLog.log(Level.INFO, I.CMD_GUI_INDEXING(IndexingGui.this._cd.toString()));
        }

        @Override
        public void onWarn(@Nonnull ILocalizedMessage msg) {
            EventQueue.invokeLater(new ExceptionLater(true));
        }

        @Override
        public void onErr(@Nonnull ILocalizedMessage msg) {
            EventQueue.invokeLater(new ExceptionLater(false));
        }

        @Override
        protected final void process(@Nonnull List<ILocalizedMessage> chunks) {
            IndexingGui.this._guiProgressDescription.setText(chunks.get(chunks.size() - 1).getLocalizedMessage());
        }

        @Override
        @CheckForNull
        protected final Void doInBackground() {
            try {
                IndexingGui.this._index = new DiscIndex(IndexingGui.this._cd, this.__progressLog);
            }
            catch (TaskCanceledException ex) {
            }
            catch (Throwable ex) {
                IndexingGui.this._exception = ex;
                this.firePropertyChange(EXCEPTION, null, ex);
                this.__progressLog.log(Level.SEVERE, I.GUI_UNHANDLED_ERROR(), ex);
                return null;
            }
            this.firePropertyChange(DONE, null, null);
            this.__progressLog.close();
            return null;
        }

        private class ExceptionLater
        implements Runnable {
            private final boolean __blnWarn;

            public ExceptionLater(boolean blnWarn) {
                this.__blnWarn = blnWarn;
            }

            @Override
            public void run() {
                if (this.__blnWarn) {
                    IndexingGui.this._iWarningCount++;
                    IndexingGui.this._guiWarningsCount.setText(String.valueOf(IndexingGui.this._iWarningCount));
                    IndexingGui.this._guiWarningsCount.setForeground(Color.red);
                } else {
                    IndexingGui.this._iErrorCount++;
                    IndexingGui.this._guiErrorsCount.setText(String.valueOf(IndexingGui.this._iErrorCount));
                    IndexingGui.this._guiErrorsCount.setForeground(Color.red);
                }
            }
        }
    }

    private static enum State {
        NOT_STARTED,
        RUNNING,
        CANCELING,
        ENDED;

    }
}

