/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.modules.sharedaudio.DiscItemAudioStream;
import jpsxdec.modules.video.DiscItemVideoStream;
import jpsxdec.util.player.PlayController;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.renderer.CheckBoxProvider;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class GuiTree
extends JXTreeTable {
    public static final Icon FILE_ICON = new ImageIcon(GuiTree.class.getResource("layer-new-3.png"));
    public static final Icon FOLDER_ICON = UIManager.getIcon("FileView.folderIcon");
    public static final ImageIcon VIDEO_ICON = new ImageIcon(GuiTree.class.getResource("film.png"));
    public static final ImageIcon AUDIO_ICON = new ImageIcon(GuiTree.class.getResource("knotify.png"));
    public static final ImageIcon IMAGE_ICON = new ImageIcon(GuiTree.class.getResource("image-x-generic.png"));
    public static final ImageIcon SOUND_ICON = new ImageIcon(GuiTree.class.getResource("audio-volume-medium-right.png"));
    @CheckForNull
    private RootTreeItem _root;

    public void formatTreeTable(@Nonnull DiscIndex index) {
        this._root = GuiTree.buildTree(index.getRoot());
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int iSectorWidth = fm.stringWidth("999999-999999");
        int iNumberWidth = fm.stringWidth(String.valueOf(index.size()) + "99");
        int iNameWidth = fm.stringWidth("MMMMMMMM.MMM[99.9.9]") + 75;
        int iTypeWidth = fm.stringWidth(DiscItem.GeneralType.Sound.getName().toString());
        this.setDefaultRenderer(Boolean.class, new OptionalBooleanTableCellRenderer());
        this.setTreeCellRenderer(new TreeIconRenderer());
        this.setSelectionMode(0);
        this.setTreeTableModel(new DiscTreeModel(this._root));
        this.packAll();
        TableColumnModel colMod = this.getColumnModel();
        colMod.getColumn(COLUMNS.Name.ordinal()).setPreferredWidth(iNameWidth + 10);
        colMod.getColumn(COLUMNS.Num.ordinal()).setPreferredWidth(iNumberWidth + 10);
        colMod.getColumn(COLUMNS.Sectors.ordinal()).setPreferredWidth(iSectorWidth + 10);
        colMod.getColumn(COLUMNS.Type.ordinal()).setPreferredWidth(iTypeWidth + 10);
        TableColumn detailsCol = colMod.getColumn(COLUMNS.Details.ordinal());
        detailsCol.setPreferredWidth(Math.max(250, detailsCol.getWidth()));
    }

    @CheckForNull
    public TreeItem getTreeTblSelection() {
        return (TreeItem)this.getValueAt(this.getSelectedRow(), this.convertColumnIndexToView(COLUMNS.Name.ordinal()));
    }

    public void selectAllType(@Nonnull Select cmd) {
        this._root.selectAllType(cmd);
        this.repaint();
    }

    public int applySettings(@Nonnull DiscItemSaverBuilder builder) {
        return this._root.applySettings(builder);
    }

    @Nonnull
    public ArrayList<DiscItemSaverBuilder> collectSelected() {
        ArrayList<DiscItemSaverBuilder> builders = new ArrayList<DiscItemSaverBuilder>();
        this._root.collectSelected(builders);
        return builders;
    }

    @Nonnull
    private static RootTreeItem buildTree(@Nonnull List<DiscItem> discItems) {
        RootTreeItem root = new RootTreeItem();
        for (DiscItem item : discItems) {
            File file = item.getIndexId().getFile();
            if (file != null) {
                String[] asDirs = GuiTree.splitFileDirs(file);
                RootTreeItem tree = root;
                for (String sDir : asDirs) {
                    tree = ((TreeItem)tree).getOrCreateDir(sDir);
                }
                tree.addKid(new DiscItemTreeItem(item));
                continue;
            }
            root.addKid(new DiscItemTreeItem(item));
        }
        return root;
    }

    @Nonnull
    private static String[] splitFileDirs(@Nonnull File file) {
        File parent;
        ArrayList<String> dirs = new ArrayList<String>();
        while ((parent = file.getParentFile()) != null) {
            dirs.add(parent.getName());
            file = parent;
        }
        Collections.reverse(dirs);
        return dirs.toArray(new String[dirs.size()]);
    }

    private static class OptionalBooleanTableCellRenderer
    extends DefaultTableRenderer {
        private final DefaultTableRenderer _blank = new DefaultTableRenderer();

        public OptionalBooleanTableCellRenderer() {
            super(new CheckBoxProvider());
        }

        @Override
        @Nonnull
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return this._blank.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class CenteredIntegerTableCellRenderer
    extends DefaultTableCellRenderer {
        private CenteredIntegerTableCellRenderer() {
        }

        @Override
        @Nonnull
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                ((JLabel)c).setHorizontalAlignment(0);
            }
            return c;
        }
    }

    private static class TreeIconRenderer
    extends DefaultTreeCellRenderer {
        private TreeIconRenderer() {
        }

        @Override
        @Nonnull
        public Component getTreeCellRendererComponent(JTree tree, @Nonnull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Icon ico = ((TreeItem)value).getIcon();
            if (ico != null) {
                this.setIcon(ico);
            }
            return this;
        }
    }

    private static class DiscTreeModel
    implements TreeTableModel {
        @Nonnull
        private final TreeItem _treeRoot;

        public DiscTreeModel(@Nonnull TreeItem treeRoot) {
            this._treeRoot = treeRoot;
        }

        @Override
        public int getHierarchicalColumn() {
            return COLUMNS.Name.ordinal();
        }

        @Override
        @Nonnull
        public TreeItem getRoot() {
            return this._treeRoot;
        }

        @Override
        @Nonnull
        public TreeItem getChild(@Nonnull Object parent, int index) {
            return ((TreeItem)parent).getKid(index);
        }

        @Override
        public int getChildCount(@Nonnull Object parent) {
            return ((TreeItem)parent).kidCount();
        }

        @Override
        public boolean isLeaf(@Nonnull Object node) {
            return ((TreeItem)node).kidCount() == 0;
        }

        @Override
        public int getIndexOfChild(@Nonnull Object parent, @Nonnull Object child) {
            return ((TreeItem)parent).indexOf(child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public boolean isCellEditable(@Nonnull Object o, int i) {
            return i == COLUMNS.Save.ordinal() && o instanceof DiscItemTreeItem;
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.values().length;
        }

        @Override
        @Nonnull
        public Class<?> getColumnClass(int i) {
            return COLUMNS.values()[i]._type;
        }

        @Override
        @Nonnull
        public String getColumnName(int i) {
            return COLUMNS.values()[i]._str.getLocalizedMessage();
        }

        @Override
        @CheckForNull
        public Object getValueAt(@Nonnull Object o, int i) {
            return COLUMNS.values()[i].val((TreeItem)o);
        }

        @Override
        public void setValueAt(@Nonnull Object value, @Nonnull Object node, int i) {
            assert (i == COLUMNS.Save.ordinal());
            ((DiscItemTreeItem)node).setSave((Boolean)value);
        }
    }

    private static class DiscItemTreeItem
    extends TreeItem {
        @Nonnull
        private final DiscItem _item;
        @CheckForNull
        private DiscItemSaverBuilder _builder;
        private boolean _blnSave = false;

        public DiscItemTreeItem(@Nonnull DiscItem item) {
            this._item = item;
            if (item.getChildCount() > 0) {
                for (DiscItem discItem : item.getChildren()) {
                    this._kids.add(new DiscItemTreeItem(discItem));
                }
            }
        }

        @Override
        @Nonnull
        public DiscItem getItem() {
            return this._item;
        }

        @Override
        @Nonnull
        public DiscItemSaverBuilder getBuilder() {
            if (this._builder == null) {
                this._builder = this._item.makeSaverBuilder();
            }
            return this._builder;
        }

        @Override
        @CheckForNull
        public Icon getIcon() {
            switch (this._item.getType()) {
                case Audio: {
                    return AUDIO_ICON;
                }
                case File: {
                    return FILE_ICON;
                }
                case Image: {
                    return IMAGE_ICON;
                }
                case Video: {
                    return VIDEO_ICON;
                }
                case Sound: {
                    return SOUND_ICON;
                }
            }
            return null;
        }

        public String toString() {
            return this._item.getIndexId().getTopLevel();
        }

        @Override
        @Nonnull
        public String getIndexNum() {
            return String.valueOf(this._item.getIndex());
        }

        @Override
        @Nonnull
        public DiscItem.GeneralType getType() {
            return this._item.getType();
        }

        @Override
        @Nonnull
        public ILocalizedMessage getDetails() {
            return this._item.getInterestingDescription();
        }

        @Override
        @CheckForNull
        public Boolean getSave() {
            return this._blnSave;
        }

        @Override
        @Nonnull
        public String getSectorRange() {
            return this._item.getStartSector() + "-" + this._item.getEndSector();
        }

        public void setSave(boolean value) {
            this._blnSave = value;
        }

        @Override
        @CheckForNull
        public PlayController getPlayer() {
            if (this._item instanceof DiscItemVideoStream) {
                return ((DiscItemVideoStream)this._item).makePlayController();
            }
            if (this._item instanceof DiscItemAudioStream) {
                return ((DiscItemAudioStream)this._item).makePlayController();
            }
            return null;
        }

        @Override
        public boolean canPlay() {
            return this._item instanceof DiscItemVideoStream || this._item instanceof DiscItemAudioStream;
        }

        @Override
        public void selectAllType(@Nonnull Select cmd) {
            if (cmd == Select.NONE) {
                this._blnSave = false;
            } else if (cmd == Select.ALL_VIDEO) {
                this._blnSave = this._blnSave || this.getItem().getType() == DiscItem.GeneralType.Video;
            } else if (cmd == Select.ALL_AUDIO) {
                this._blnSave = this._blnSave || this.getItem() instanceof DiscItemAudioStream && !((DiscItemAudioStream)this.getItem()).isPartOfVideo();
            } else if (cmd == Select.ALL_AUDIO_VIDEO) {
                this._blnSave = this._blnSave || this.getItem().getType() == DiscItem.GeneralType.Audio;
            } else if (cmd == Select.ALL_FILES) {
                this._blnSave = this._blnSave || this.getItem().getType() == DiscItem.GeneralType.File;
            } else if (cmd == Select.ALL_IMAGES) {
                this._blnSave = this._blnSave || this.getItem().getType() == DiscItem.GeneralType.Image;
            } else if (cmd == Select.ALL_SOUND) {
                this._blnSave = this._blnSave || this.getItem().getType() == DiscItem.GeneralType.Sound;
            }
            super.selectAllType(cmd);
        }
    }

    private static class DirectoryTreeItem
    extends RootTreeItem {
        @Nonnull
        private final String _sDirName;

        public DirectoryTreeItem(@Nonnull String sDirName) {
            this._sDirName = sDirName;
        }

        @Nonnull
        private Object getName() {
            return this._sDirName;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public String toString() {
            return this._sDirName + "/";
        }
    }

    private static class RootTreeItem
    extends TreeItem {
        private RootTreeItem() {
        }

        @Override
        public DiscItemSaverBuilder getBuilder() {
            return null;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        public String toString() {
            return "[ROOT]";
        }

        @Override
        public ILocalizedMessage getDetails() {
            return null;
        }

        @Override
        public String getIndexNum() {
            return "";
        }

        @Override
        public DiscItem.GeneralType getType() {
            return null;
        }

        @Override
        public String getSectorRange() {
            return "";
        }

        @Override
        public PlayController getPlayer() {
            return null;
        }

        @Override
        public DiscItem getItem() {
            return null;
        }

        @Override
        public boolean canPlay() {
            return false;
        }

        @Override
        public Boolean getSave() {
            return null;
        }
    }

    public static abstract class TreeItem {
        protected ArrayList<TreeItem> _kids = new ArrayList();

        @Nonnull
        public TreeItem getKid(int childIndex) {
            return this._kids.get(childIndex);
        }

        public int kidCount() {
            return this._kids.size();
        }

        public int indexOf(@Nonnull Object node) {
            return this._kids.indexOf(node);
        }

        public void addKid(@Nonnull TreeItem kid) {
            this._kids.add(kid);
        }

        @Nonnull
        public Iterator<TreeItem> iterator() {
            return this._kids.iterator();
        }

        @Nonnull
        private DirectoryTreeItem getOrCreateDir(@Nonnull String sName) {
            for (TreeItem node : this._kids) {
                DirectoryTreeItem dirNode;
                if (!(node instanceof DirectoryTreeItem) || !(dirNode = (DirectoryTreeItem)node).getName().equals(sName)) continue;
                return dirNode;
            }
            DirectoryTreeItem dirNode = new DirectoryTreeItem(sName);
            this._kids.add(dirNode);
            return dirNode;
        }

        @CheckForNull
        public abstract Icon getIcon();

        @CheckForNull
        public abstract DiscItemSaverBuilder getBuilder();

        @Nonnull
        public abstract String getIndexNum();

        @CheckForNull
        public abstract DiscItem.GeneralType getType();

        @CheckForNull
        public abstract ILocalizedMessage getDetails();

        @Nonnull
        public abstract String getSectorRange();

        public abstract boolean canPlay();

        @CheckForNull
        public abstract PlayController getPlayer();

        @CheckForNull
        public abstract DiscItem getItem();

        @CheckForNull
        public abstract Boolean getSave();

        public void collectSelected(@Nonnull ArrayList<DiscItemSaverBuilder> builders) {
            DiscItemSaverBuilder thisBuilder;
            Boolean oblnSave = this.getSave();
            if (oblnSave != null && oblnSave.booleanValue() && (thisBuilder = this.getBuilder()) != null) {
                builders.add(thisBuilder);
            }
            for (int i = 0; i < this.kidCount(); ++i) {
                this.getKid(i).collectSelected(builders);
            }
        }

        public int applySettings(@Nonnull DiscItemSaverBuilder otherBuilder) {
            int iCount = 0;
            DiscItemSaverBuilder thisBuilder = this.getBuilder();
            if (thisBuilder != null && otherBuilder.copySettingsTo(thisBuilder)) {
                ++iCount;
            }
            for (int i = 0; i < this.kidCount(); ++i) {
                iCount += this.getKid(i).applySettings(otherBuilder);
            }
            return iCount;
        }

        public void selectAllType(@Nonnull Select cmd) {
            for (int i = 0; i < this.kidCount(); ++i) {
                this.getKid(i).selectAllType(cmd);
            }
        }
    }

    private static enum COLUMNS {
        Num((Class)Integer.class, I.GUI_TREE_INDEX_NUMBER_COLUMN()){

            @Override
            String val(TreeItem item) {
                return item.getIndexNum();
            }
        }
        ,
        Save((Class)Boolean.class, I.GUI_TREE_SAVE_COLUMN()){

            @Override
            Boolean val(TreeItem item) {
                return item.getSave();
            }
        }
        ,
        Name((Class)TreeItem.class, I.GUI_TREE_NAME_COLUMN()){

            @Override
            TreeItem val(TreeItem item) {
                return item;
            }
        }
        ,
        Type((Class)String.class, I.GUI_TREE_TYPE_COLUMN()){

            @Override
            String val(TreeItem item) {
                DiscItem.GeneralType type = item.getType();
                if (type == null) {
                    return null;
                }
                return type.getName().getLocalizedMessage();
            }
        }
        ,
        Sectors((Class)String.class, I.GUI_SECTORS_COLUMN()){

            @Override
            String val(TreeItem item) {
                return item.getSectorRange();
            }
        }
        ,
        Details((Class)String.class, I.GUI_TREE_DETAILS_COLUMN()){

            @Override
            String val(TreeItem item) {
                ILocalizedMessage details = item.getDetails();
                return details == null ? null : details.getLocalizedMessage();
            }
        };

        @Nonnull
        private final Class<?> _type;
        @Nonnull
        private final ILocalizedMessage _str;

        private COLUMNS(Class<?> type, ILocalizedMessage str) {
            this._type = type;
            this._str = str;
        }

        @CheckForNull
        abstract Object val(@Nonnull TreeItem var1);

        public String toString() {
            return this._str.getLocalizedMessage();
        }
    }

    public static enum Select {
        NONE(I.GUI_SELECT_NONE()),
        ALL_VIDEO(I.GUI_SELECT_ALL_VIDEO()),
        ALL_AUDIO(I.GUI_SELECT_ALL_AUIO_EX_VID()),
        ALL_AUDIO_VIDEO(I.GUI_SELECT_ALL_AUDIO_INC_VID()),
        ALL_FILES(I.GUI_SELECT_ALL_FILES()),
        ALL_IMAGES(I.GUI_SELECT_ALL_IMAGES()),
        ALL_SOUND(I.GUI_SELECT_ALL_SOUNDS());

        @Nonnull
        private final ILocalizedMessage _str;

        public static Select[] getAvailableValues() {
            Select[] aoValues = Select.values();
            return Arrays.copyOfRange(aoValues, 0, aoValues.length - 1);
        }

        private Select(ILocalizedMessage str) {
            this._str = str;
        }

        public String toString() {
            return this._str.getLocalizedMessage();
        }
    }
}

