/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.util.IO;

public class GuiSettings {
    private static final Logger LOG = Logger.getLogger(GuiSettings.class.getName());
    private static final String INI_FILE_NAME = "jpsxdec.ini";
    private static final String SAVING_DIR_KEY = "SavingDir";
    @CheckForNull
    private String _sSavingDir;
    private static final String IMAGE_DIR_KEY = "ImageDir";
    @CheckForNull
    private String _sImageDir;
    private static final String INDEX_DIR_KEY = "IndexDir";
    @CheckForNull
    private String _sIndexDir;
    private static final String PREVIOUS_IMAGE_KEY = "PreviousImage";
    private final LinkedList<String> _previousImages = new LinkedList();
    private static final String PREVIOUS_IMAGE_COUNT_KEY = "PrevousImageCount";
    private int _iPreviousImageCount;
    private static final String PREVIOUS_INDEX_KEY = "PreviousIndex";
    private final LinkedList<String> _previousIndexes = new LinkedList();
    private static final String PREVIOUS_INDEX_COUNT_KEY = "PreviousIndexCount";
    private int _iPreviousIndexCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load() {
        String s;
        int i;
        Properties prop = new Properties();
        FileInputStream propFile = null;
        try {
            propFile = new FileInputStream(INI_FILE_NAME);
            prop.load(propFile);
        }
        catch (FileNotFoundException ex) {
            LOG.log(Level.INFO, "ini file not found", ex);
            IO.closeSilently(propFile, LOG);
        }
        catch (Throwable ex2) {
            LOG.log(Level.WARNING, "Error loading ini file", ex2);
            {
                catch (Throwable throwable) {
                    IO.closeSilently(propFile, LOG);
                    throw throwable;
                }
            }
            IO.closeSilently(propFile, LOG);
        }
        IO.closeSilently(propFile, LOG);
        this._sSavingDir = prop.getProperty(SAVING_DIR_KEY, new File("").getAbsolutePath());
        this._sImageDir = prop.getProperty(IMAGE_DIR_KEY, new File("").getAbsolutePath());
        this._sIndexDir = prop.getProperty(INDEX_DIR_KEY, new File("").getAbsolutePath());
        try {
            this._iPreviousImageCount = Integer.parseInt(prop.getProperty(PREVIOUS_IMAGE_COUNT_KEY, "10"));
            if (this._iPreviousImageCount < 0) {
                this._iPreviousImageCount = 10;
            }
        }
        catch (NumberFormatException ex) {
            this._iPreviousImageCount = 10;
        }
        try {
            this._iPreviousIndexCount = Integer.parseInt(prop.getProperty(PREVIOUS_INDEX_COUNT_KEY, "10"));
            if (this._iPreviousIndexCount < 0) {
                this._iPreviousIndexCount = 10;
            }
        }
        catch (NumberFormatException ex) {
            this._iPreviousIndexCount = 10;
        }
        for (i = this._iPreviousImageCount - 1; i >= 0; --i) {
            s = prop.getProperty(PREVIOUS_IMAGE_KEY + i);
            if (s == null) continue;
            this.addPreviousImage(s);
        }
        for (i = this._iPreviousIndexCount - 1; i >= 0; --i) {
            s = prop.getProperty(PREVIOUS_INDEX_KEY + i);
            if (s == null) continue;
            this.addPreviousIndex(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        int i;
        Properties prop = new Properties();
        if (this._sSavingDir != null) {
            prop.setProperty(SAVING_DIR_KEY, this._sSavingDir);
        }
        if (this._sImageDir != null) {
            prop.setProperty(IMAGE_DIR_KEY, this._sImageDir);
        }
        if (this._sIndexDir != null) {
            prop.setProperty(INDEX_DIR_KEY, this._sIndexDir);
        }
        prop.setProperty(PREVIOUS_IMAGE_COUNT_KEY, String.valueOf(this._iPreviousImageCount));
        for (i = 0; i < this._previousImages.size(); ++i) {
            prop.setProperty(PREVIOUS_IMAGE_KEY + i, this._previousImages.get(i));
        }
        prop.setProperty(PREVIOUS_INDEX_COUNT_KEY, String.valueOf(this._iPreviousIndexCount));
        for (i = 0; i < this._previousIndexes.size(); ++i) {
            prop.setProperty(PREVIOUS_INDEX_KEY + i, this._previousIndexes.get(i));
        }
        FileOutputStream fos = new FileOutputStream(INI_FILE_NAME);
        boolean blnException = true;
        try {
            prop.store(fos, I.JPSXDEC_VERSION_NON_COMMERCIAL("1.05 (beta)").getEnglishMessage());
            blnException = false;
        }
        finally {
            if (blnException) {
                IO.closeSilently(fos, LOG);
            } else {
                fos.close();
            }
        }
    }

    public int getPreviousImageCount() {
        return this._iPreviousImageCount;
    }

    public void setPreviousImageCount(int iPreviousImageCount) {
        this._iPreviousImageCount = iPreviousImageCount;
    }

    public int getPreviousIndexCount() {
        return this._iPreviousIndexCount;
    }

    public void setPreviousIndexCount(int iPreviousIndexCount) {
        this._iPreviousIndexCount = iPreviousIndexCount;
    }

    @Nonnull
    public List<String> getPreviousImages() {
        return this._previousImages;
    }

    public void addPreviousImage(@Nonnull String sImagePath) {
        this._previousImages.remove(sImagePath);
        this._previousImages.addFirst(sImagePath);
        while (this._previousImages.size() >= this._iPreviousImageCount) {
            this._previousImages.removeLast();
        }
    }

    public void removePreviousImage(@Nonnull String sImagePath) {
        this._previousImages.remove(sImagePath);
    }

    @Nonnull
    public List<String> getPreviousIndexes() {
        return this._previousIndexes;
    }

    public void addPreviousIndex(@Nonnull String sIndexPath) {
        this._previousIndexes.remove(sIndexPath);
        this._previousIndexes.addFirst(sIndexPath);
        while (this._previousIndexes.size() >= this._iPreviousIndexCount) {
            this._previousIndexes.removeLast();
        }
    }

    public void removePreviousIndex(@Nonnull String sIndexPath) {
        this._previousIndexes.remove(sIndexPath);
    }

    @CheckForNull
    public String getImageDir() {
        return this._sImageDir;
    }

    public void setImageDir(@Nonnull String sImageDir) {
        this._sImageDir = sImageDir;
    }

    @CheckForNull
    public String getIndexDir() {
        return this._sIndexDir;
    }

    public void setIndexDir(@Nonnull String sIndexDir) {
        this._sIndexDir = sIndexDir;
    }

    @CheckForNull
    public String getSavingDir() {
        return this._sSavingDir;
    }

    public void setSavingDir(@Nonnull String sSavingDir) {
        this._sSavingDir = sSavingDir;
    }
}

