/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.gui;

import java.io.File;
import javax.annotation.Nonnull;
import javax.swing.filechooser.FileFilter;
import jpsxdec.gui.BetterFileChooser;
import jpsxdec.i18n.I;

public class GuiFileFilters {
    public static final BetterFileChooser.SaveFileFilter INDEX_FILE_FILTER = new BetterFileChooser.SaveFileFilter(){

        @Override
        public boolean accept(@Nonnull File f) {
            return f.isFile() ? f.getName().toLowerCase().endsWith(this.getExtension().toLowerCase()) : true;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return I.GUI_INDEX_EXTENSION().getLocalizedMessage();
        }

        @Override
        @Nonnull
        public String getExtension() {
            return ".idx";
        }
    };
    static final FileFilter[] DISC_OPEN_FILTERS = new FileFilter[]{new FileFilter(){

        @Override
        public String getDescription() {
            return I.GUI_ALL_COMPATIBLE_EXTENSIONS().getLocalizedMessage();
        }

        @Override
        public boolean accept(File f) {
            String s = f.getName().toLowerCase();
            return f.isDirectory() || s.endsWith(".iso") || s.endsWith(".bin") || s.endsWith(".img") || s.endsWith(".mdf") || s.endsWith(".str") || s.endsWith(".iki") || s.endsWith(".xa");
        }
    }, new FileFilter(){

        @Override
        public String getDescription() {
            return I.GUI_CD_IMAGE_EXTENSIONS().getLocalizedMessage();
        }

        @Override
        public boolean accept(File f) {
            String s = f.getName().toLowerCase();
            return f.isDirectory() || s.endsWith(".iso") || s.endsWith(".bin") || s.endsWith(".img") || s.endsWith(".mdf");
        }
    }, new FileFilter(){

        @Override
        public String getDescription() {
            return I.GUI_PSX_VIDEO_EXTENSIONS().getLocalizedMessage();
        }

        @Override
        public boolean accept(File f) {
            String s = f.getName().toLowerCase();
            return f.isDirectory() || s.endsWith(".str") || s.endsWith(".mov") || s.endsWith(".iki") || s.endsWith(".ik2");
        }
    }, new FileFilter(){

        @Override
        public String getDescription() {
            return I.GUI_XA_EXTENSION().getLocalizedMessage();
        }

        @Override
        public boolean accept(File f) {
            String s = f.getName().toLowerCase();
            return f.isDirectory() || s.endsWith(".xa");
        }
    }};
}

