/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.gui;

import com.l2fprod.common.swing.JDirectoryChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import jpsxdec.Main;
import jpsxdec.cdreaders.CdFileSectorReader;
import jpsxdec.discitems.DiscItem;
import jpsxdec.discitems.DiscItemSaverBuilder;
import jpsxdec.discitems.DiscItemSaverBuilderGui;
import jpsxdec.gui.BetterFileChooser;
import jpsxdec.gui.GuiFileFilters;
import jpsxdec.gui.GuiSettings;
import jpsxdec.gui.GuiTree;
import jpsxdec.gui.IndexingGui;
import jpsxdec.gui.SavingGui;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;
import jpsxdec.i18n.UnlocalizedMessage;
import jpsxdec.i18n.exception.LocalizedDeserializationFail;
import jpsxdec.i18n.log.UserFriendlyLogger;
import jpsxdec.indexing.DiscIndex;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;
import jpsxdec.util.player.PlayController;
import jpsxdec.util.player.PlayerException;
import org.openide.awt.DropDownButtonFactory;

public class Gui
extends JFrame {
    private static final Logger LOG = Logger.getLogger(Gui.class.getName());
    @CheckForNull
    private transient DiscIndex _index;
    @CheckForNull
    private transient PlayController _currentPlayer;
    private final ArrayList<DiscItemSaverBuilderGui> _saverGuis = new ArrayList();
    @Nonnull
    private final transient GuiSettings _settings;
    @CheckForNull
    private String _sCommandLineFile;
    private final transient PlayController.PlayerListener _playerListener = new PlayController.PlayerListener(){

        @Override
        public void event(final @Nonnull PlayController.Event eEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (eEvent) {
                        case End: {
                            Gui.this._guiPlayPauseBtn.setEnabled(false);
                            break;
                        }
                        case Pause: {
                            Gui.this._guiPlayPauseBtn.setText(I.GUI_PLAY_BTN().getLocalizedMessage());
                            break;
                        }
                        case Play: {
                            Gui.this._guiPlayPauseBtn.setText(I.GUI_PAUSE_BTN().getLocalizedMessage());
                        }
                    }
                }
            });
        }
    };
    private JButton _guiApplyAll;
    private JButton _guiChooseDir;
    private JButton _guiCollapseAll;
    private JPanel _guiDirChooserContainer;
    private JTextField _guiDirectory;
    private JLabel _guiDirectoryLbl;
    private JPanel _guiDiscInfoContainer;
    private JLabel _guiDiscInfoLine1;
    private JLabel _guiDiscInfoLine2;
    private GuiTree _guiDiscTree;
    private JScrollPane _guiDiscTreeScroll;
    private JButton _guiExpandAll;
    private JSplitPane _guiMainSplit;
    private JButton _guiOpenDisc;
    private JButton _guiOpenIndex;
    private JButton _guiPlayPauseBtn;
    private JPanel _guiPreviewContainer;
    private JPanel _guiPreviewPanel;
    private JButton _guiSaveAll;
    private JPanel _guiSaveBtnContainer;
    private JPanel _guiSaveContainer;
    private JButton _guiSaveIndex;
    private JPanel _guiSavePanel;
    private JButton _guiSelectAll;
    private JComboBox _guiSelectAllType;
    private JTabbedPane _guiTab;
    private JPanel _guiTabContainer;
    private JToolBar _guiToolbar;
    private JToolBar.Separator _guiToolbarSeparator1;
    private JToolBar.Separator _guiToolbarSeparator2;
    private JPanel _guiTopPanel;
    private JPanel _guiTreeButtonContainer;
    private JPanel _guiTreeContainer;

    public Gui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Error setting system L&F", ex);
        }
        this.setTitle(I.JPSXDEC_VERSION_NON_COMMERCIAL("1.05 (beta)").getLocalizedMessage());
        this.initComponents();
        this._guiTab.setEnabledAt(1, false);
        this.setLocationRelativeTo(null);
        this._settings = new GuiSettings();
        this._settings.load();
        this._guiDirectory.setText(this._settings.getSavingDir());
        this.convertToolbar();
        Image icon16 = Toolkit.getDefaultToolkit().createImage(Gui.class.getResource("icon16.png"));
        Image icon32 = Toolkit.getDefaultToolkit().createImage(Gui.class.getResource("icon32.png"));
        Image icon48 = Toolkit.getDefaultToolkit().createImage(Gui.class.getResource("icon48.png"));
        this.setIconImages(Arrays.asList(icon16, icon32, icon48));
    }

    public void setCommandLineFile(@Nonnull String sCmdLineFile) {
        this._sCommandLineFile = sCmdLineFile;
    }

    private void convertToolbar() {
        this._guiToolbar.removeAll();
        this._guiOpenDisc = Gui.convertButton(this._guiOpenDisc, new DiscMenu());
        this._guiOpenIndex = Gui.convertButton(this._guiOpenIndex, new IndexMenu());
        this._guiToolbar.add(this._guiOpenDisc);
        this._guiToolbar.add(this._guiToolbarSeparator1);
        this._guiToolbar.add(this._guiOpenIndex);
        this._guiToolbar.add(this._guiToolbarSeparator2);
        this._guiToolbar.add(this._guiSaveIndex);
        this._guiToolbar.validate();
    }

    @Nonnull
    private static JButton convertButton(@Nonnull JButton oldButton, @Nonnull JPopupMenu menu) {
        JButton newButton = DropDownButtonFactory.createDropDownButton(oldButton.getIcon(), menu);
        newButton.setText(oldButton.getText());
        newButton.setHorizontalTextPosition(2);
        newButton.setMargin(oldButton.getMargin());
        for (ActionListener listener : oldButton.getActionListeners()) {
            newButton.addActionListener(listener);
        }
        return newButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openIndex(@Nonnull File indexFile) {
        File dir = indexFile.getParentFile();
        if (dir != null) {
            this._settings.setIndexDir(dir.getAbsolutePath());
        }
        UserFriendlyLogger log = new UserFriendlyLogger(I.INDEX_LOG_FILE_BASE_NAME().getLocalizedMessage());
        try {
            UserFriendlyLogger.WarnErrCounter warnErrCount = new UserFriendlyLogger.WarnErrCounter();
            log.setListener(warnErrCount);
            log.log(Level.INFO, I.IO_OPENING_FILE(indexFile.toString()));
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setIndex(new DiscIndex(indexFile.getPath(), log), indexFile.getName());
            this._settings.addPreviousIndex(indexFile.getAbsolutePath());
            this._guiSaveIndex.setEnabled(false);
            if (warnErrCount.getWarnCount() > 0 || warnErrCount.getErrCount() > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(I.GUI_INDEX_LOAD_ISSUES(this._index.size()));
                sb.append('\n');
                if (warnErrCount.getWarnCount() > 0) {
                    sb.append(I.GUI_INDEX_LOAD_ISSUES_WARNINGS(warnErrCount.getWarnCount())).append('\n');
                }
                if (warnErrCount.getErrCount() > 0) {
                    sb.append(I.GUI_INDEX_LOAD_ISSUES_ERRORS(warnErrCount.getErrCount())).append('\n');
                }
                sb.append(I.GUI_INDEX_LOAD_ISSUES_SEE_FILE(log.getFileName()));
                JOptionPane.showMessageDialog(this, sb.toString(), I.GUI_INDEX_LOAD_ISSUES_DIALOG_TITLE().getLocalizedMessage(), 2);
            }
        }
        catch (LocalizedDeserializationFail ex) {
            JOptionPane.showMessageDialog(this, ex.getSourceMessage().getLocalizedMessage(), I.ERR_LOADING_INDEX_FILE().getLocalizedMessage(), 2);
        }
        catch (CdFileSectorReader.CdFileNotFoundException ex) {
            ILocalizedMessage msg = I.IO_OPENING_FILE_NOT_FOUND_NAME(ex.getFile().toString());
            log.log(Level.SEVERE, msg, ex);
            JOptionPane.showMessageDialog(this, msg, I.IO_OPENING_FILE_ERROR().getLocalizedMessage(), 2);
        }
        catch (FileNotFoundException ex) {
            ILocalizedMessage msg = I.IO_OPENING_FILE_NOT_FOUND_NAME(indexFile.toString());
            log.log(Level.SEVERE, msg, ex);
            JOptionPane.showMessageDialog(this, msg.getLocalizedMessage(), I.IO_OPENING_FILE_ERROR().getLocalizedMessage(), 2);
            this._settings.removePreviousIndex(indexFile.getAbsolutePath());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            ILocalizedMessage msg = I.GUI_BAD_ERROR();
            log.log(Level.SEVERE, msg, ex);
            JOptionPane.showMessageDialog(this, ex, msg.getLocalizedMessage(), 0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            log.close();
        }
    }

    private void setIndex(@Nonnull DiscIndex index, @CheckForNull String sIndexFile) {
        final CdFileSectorReader oldCd = this._index == null ? null : this._index.getSourceCd();
        this._index = index;
        this.setDisc(this._index.getSourceCd());
        this._saverGuis.clear();
        this._guiSaveAll.setEnabled(true);
        this._guiSelectAll.setEnabled(true);
        this._guiDiscTree.formatTreeTable(this._index);
        if (sIndexFile == null) {
            sIndexFile = I.GUI_TITLE_UNSAVED_INDEX().getLocalizedMessage();
        }
        this.setIndexTitle(sIndexFile);
        this._currentPlayer = null;
        if (oldCd != null) {
            Timer t = new Timer(5000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    System.out.println("Closing closed disc");
                    IO.closeSilently(oldCd, LOG);
                }
            });
            t.setRepeats(false);
            t.start();
        }
    }

    private void setIndexTitle(@Nonnull String sFile) {
        this.setTitle(sFile + " - " + I.JPSXDEC_VERSION_NON_COMMERCIAL("1.05 (beta)").getLocalizedMessage());
    }

    private boolean saveIndex() {
        if (this._index == null) {
            return true;
        }
        BetterFileChooser fc = new BetterFileChooser(this._settings.getIndexDir());
        fc.setDialogType(1);
        fc.setAcceptAllFileFilterUsed(true);
        fc.setDialogTitle(I.GUI_SAVE_INDEX_FILE_DIALOG_TITLE().getLocalizedMessage());
        fc.addChoosableFileFilter(GuiFileFilters.INDEX_FILE_FILTER);
        fc.setFileFilter(GuiFileFilters.INDEX_FILE_FILTER);
        int iResult = fc.showSaveDialog(this);
        if (iResult != 0) {
            return false;
        }
        this._settings.setIndexDir(fc.getCurrentDirectory().getPath());
        try {
            File selection = fc.getSelectedFile();
            this._index.serializeIndex(selection);
            this._settings.addPreviousIndex(selection.getAbsolutePath());
            this._guiSaveIndex.setEnabled(false);
            this.setIndexTitle(selection.getName());
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            LOG.log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, ex, I.GUI_SAVE_INDEX_ERR().getLocalizedMessage(), 0);
            return false;
        }
    }

    private void setDisc(@Nonnull CdFileSectorReader cd) {
        this._guiDiscInfoLine1.setText(cd.getSourceFile().getAbsoluteFile().getPath());
        this._guiDiscInfoLine2.setText(cd.getTypeDescription().getLocalizedMessage());
        this._settings.addPreviousImage(cd.getSourceFile().getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openDisc(@Nonnull File file) {
        File dir = file.getParentFile();
        if (dir != null) {
            this._settings.setImageDir(dir.getAbsolutePath());
        }
        try {
            CdFileSectorReader cd = CdFileSectorReader.open(file);
            if (!cd.hasSectorHeader()) {
                JOptionPane.showMessageDialog(this, I.GUI_DISC_NO_RAW_HEADERS_WARNING());
            }
            IndexingGui gui = new IndexingGui((Frame)this, cd);
            gui.setVisible(true);
            DiscIndex generatedIndex = gui.getIndex();
            if (generatedIndex == null) {
                cd.close();
            } else if (generatedIndex.size() == 0) {
                JOptionPane.showMessageDialog(this, I.GUI_DIALOG_COULD_NOT_IDENTIFY_ANYTHING(file.toString()).getLocalizedMessage());
            } else {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.setIndex(generatedIndex, null);
                this._guiSaveIndex.setEnabled(true);
            }
        }
        catch (FileNotFoundException ex) {
            LOG.log(Level.WARNING, null, ex);
            JOptionPane.showMessageDialog(this, I.IO_OPENING_FILE_NOT_FOUND_NAME(file.toString()), I.IO_OPENING_FILE_ERROR().getLocalizedMessage(), 2);
            this._settings.removePreviousImage(file.getAbsolutePath());
        }
        catch (CdFileSectorReader.FileTooSmallToIdentifyException ex) {
            LOG.log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, I.CD_FILE_TOO_SMALL(file.toString()), I.IO_OPENING_FILE_ERROR().getLocalizedMessage(), 0);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            LOG.log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, ex, I.GUI_BAD_ERROR().getLocalizedMessage(), 0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void initComponents() {
        this._guiTopPanel = new JPanel();
        this._guiToolbar = new JToolBar();
        this._guiOpenDisc = new JButton();
        this._guiToolbarSeparator1 = new JToolBar.Separator();
        this._guiOpenIndex = new JButton();
        this._guiToolbarSeparator2 = new JToolBar.Separator();
        this._guiSaveIndex = new JButton();
        this._guiDiscInfoContainer = new JPanel();
        this._guiDiscInfoLine1 = new JLabel();
        this._guiDiscInfoLine2 = new JLabel();
        this._guiMainSplit = new JSplitPane();
        this._guiTreeContainer = new JPanel();
        this._guiDiscTreeScroll = new JScrollPane();
        this._guiDiscTree = new GuiTree();
        this._guiTreeButtonContainer = new JPanel();
        this._guiSelectAll = new JButton();
        this._guiSelectAllType = new JComboBox();
        this._guiExpandAll = new JButton();
        this._guiCollapseAll = new JButton();
        this._guiTabContainer = new JPanel();
        this._guiTab = new JTabbedPane();
        this._guiSaveContainer = new JPanel();
        this._guiDirChooserContainer = new JPanel();
        this._guiDirectoryLbl = new JLabel();
        this._guiDirectory = new JTextField();
        this._guiChooseDir = new JButton();
        this._guiSavePanel = new JPanel();
        this._guiSaveBtnContainer = new JPanel();
        this._guiApplyAll = new JButton();
        this._guiSaveAll = new JButton();
        this._guiPreviewContainer = new JPanel();
        this._guiPlayPauseBtn = new JButton();
        this._guiPreviewPanel = new JPanel();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Gui.this.formWindowClosing(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                Gui.this.formWindowOpened(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this._guiTopPanel.setLayout(new BorderLayout());
        this._guiToolbar.setFloatable(false);
        this._guiToolbar.setRollover(true);
        this._guiOpenDisc.setIcon(new ImageIcon(this.getClass().getResource("/jpsxdec/gui/media-optical-5.png")));
        this._guiOpenDisc.setText(I.GUI_OPEN_ANALYZE_DISC_BTN().getLocalizedMessage());
        this._guiOpenDisc.setHorizontalTextPosition(2);
        this._guiOpenDisc.setMargin(new Insets(5, 10, 5, 10));
        this._guiOpenDisc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Gui.this._guiOpenDiscActionPerformed(evt);
            }
        });
        this._guiToolbar.add(this._guiOpenDisc);
        this._guiToolbar.add(this._guiToolbarSeparator1);
        this._guiOpenIndex.setIcon(new ImageIcon(this.getClass().getResource("/jpsxdec/gui/insert-numbers.png")));
        this._guiOpenIndex.setText(I.GUI_OPEN_INDEX_BTN().getLocalizedMessage());
        this._guiOpenIndex.setFocusable(false);
        this._guiOpenIndex.setHorizontalTextPosition(2);
        this._guiOpenIndex.setMargin(new Insets(5, 10, 5, 10));
        this._guiOpenIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Gui.this._guiOpenIndexActionPerformed(evt);
            }
        });
        this._guiToolbar.add(this._guiOpenIndex);
        this._guiToolbar.add(this._guiToolbarSeparator2);
        this._guiSaveIndex.setIcon(new ImageIcon(this.getClass().getResource("/jpsxdec/gui/3floppy_unmount.png")));
        this._guiSaveIndex.setText(I.GUI_SAVE_INDEX_BTN().getLocalizedMessage());
        this._guiSaveIndex.setEnabled(false);
        this._guiSaveIndex.setFocusable(false);
        this._guiSaveIndex.setHorizontalTextPosition(2);
        this._guiSaveIndex.setMargin(new Insets(5, 10, 5, 10));
        this._guiSaveIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Gui.this._guiSaveIndexActionPerformed(evt);
            }
        });
        this._guiToolbar.add(this._guiSaveIndex);
        this._guiTopPanel.add((Component)this._guiToolbar, "North");
        this._guiDiscInfoContainer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._guiDiscInfoContainer.setLayout(new BoxLayout(this._guiDiscInfoContainer, 3));
        this._guiDiscInfoLine1.setText("  ");
        this._guiDiscInfoContainer.add(this._guiDiscInfoLine1);
        this._guiDiscInfoLine2.setText("  ");
        this._guiDiscInfoContainer.add(this._guiDiscInfoLine2);
        this._guiTopPanel.add((Component)this._guiDiscInfoContainer, "South");
        this.getContentPane().add((Component)this._guiTopPanel, "North");
        this._guiMainSplit.setDividerLocation(500);
        this._guiMainSplit.setResizeWeight(1.0);
        this._guiTreeContainer.setLayout(new BorderLayout(5, 5));
        this._guiDiscTreeScroll.setPreferredSize(new Dimension(500, 300));
        this._guiDiscTree.setAutoResizeMode(0);
        this._guiDiscTree.setMinimumSize(new Dimension(200, 0));
        this._guiDiscTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                Gui.this._guiDiscTreeValueChanged(evt);
            }
        });
        this._guiDiscTreeScroll.setViewportView(this._guiDiscTree);
        this._guiTreeContainer.add((Component)this._guiDiscTreeScroll, "Center");
        this._guiTreeButtonContainer.setLayout(new GridBagLayout());
        this._guiSelectAll.setText(I.GUI_SELECT_BTN().getLocalizedMessage());
        this._guiSelectAll.setEnabled(false);
        this._guiSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Gui.this._guiSelectAllActionPerformed(evt);
            }
        });
        this._guiTreeButtonContainer.add((Component)this._guiSelectAll, new GridBagConstraints());
        this._guiSelectAllType.setModel(new DefaultComboBoxModel<GuiTree.Select>(GuiTree.Select.getAvailableValues()));
        this._guiTreeButtonContainer.add((Component)this._guiSelectAllType, new GridBagConstraints());
        this._guiExpandAll.setText(I.GUI_EXPAND_ALL_BTN().getLocalizedMessage());
        this._guiExpandAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Gui.this._guiExpandAllActionPerformed(evt);
            }
        });
        this._guiTreeButtonContainer.add((Component)this._guiExpandAll, new GridBagConstraints());
        this._guiCollapseAll.setText(I.GUI_COLLAPSE_ALL_BTN().getLocalizedMessage());
        this._guiCollapseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Gui.this._guiCollapseAllActionPerformed(evt);
            }
        });
        this._guiTreeButtonContainer.add((Component)this._guiCollapseAll, new GridBagConstraints());
        this._guiTreeContainer.add((Component)this._guiTreeButtonContainer, "South");
        this._guiMainSplit.setLeftComponent(this._guiTreeContainer);
        this._guiTabContainer.setLayout(new BorderLayout(5, 5));
        this._guiTab.setMinimumSize(new Dimension(400, 5));
        this._guiTab.setPreferredSize(new Dimension(400, 500));
        this._guiTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Gui.this._guiTabStateChanged(evt);
            }
        });
        this._guiSaveContainer.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._guiSaveContainer.setMinimumSize(new Dimension(0, 500));
        this._guiSaveContainer.setPreferredSize(new Dimension(0, 500));
        this._guiSaveContainer.setLayout(new BorderLayout());
        this._guiDirChooserContainer.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this._guiDirChooserContainer.setLayout(new BorderLayout(2, 0));
        this._guiDirectoryLbl.setText(I.GUI_DIRECTORY_LABEL().getLocalizedMessage());
        this._guiDirChooserContainer.add((Component)this._guiDirectoryLbl, "West");
        this._guiDirChooserContainer.add((Component)this._guiDirectory, "Center");
        this._guiChooseDir.setText(I.GUI_DIR_CHOOSER_BTN().getLocalizedMessage());
        this._guiChooseDir.setMargin(new Insets(2, 3, 2, 2));
        this._guiChooseDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Gui.this._guiChooseDirActionPerformed(evt);
            }
        });
        this._guiDirChooserContainer.add((Component)this._guiChooseDir, "After");
        this._guiSaveContainer.add((Component)this._guiDirChooserContainer, "North");
        this._guiSavePanel.setBorder(BorderFactory.createEtchedBorder());
        this._guiSavePanel.setLayout(new BorderLayout());
        this._guiSaveContainer.add((Component)this._guiSavePanel, "Center");
        this._guiSaveBtnContainer.setLayout(new FlowLayout(2));
        this._guiApplyAll.setText(I.GUI_APPLY_TO_ALL_BTN(new UnlocalizedMessage("")).getLocalizedMessage());
        this._guiApplyAll.setEnabled(false);
        this._guiApplyAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Gui.this._guiApplyAllActionPerformed(evt);
            }
        });
        this._guiSaveBtnContainer.add(this._guiApplyAll);
        this._guiSaveAll.setText(I.GUI_SAVE_ALL_SELECTED_BTN().getLocalizedMessage());
        this._guiSaveAll.setEnabled(false);
        this._guiSaveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Gui.this._guiSaveAllActionPerformed(evt);
            }
        });
        this._guiSaveBtnContainer.add(this._guiSaveAll);
        this._guiSaveContainer.add((Component)this._guiSaveBtnContainer, "South");
        this._guiTab.addTab(I.GUI_SAVE_TAB().getLocalizedMessage(), this._guiSaveContainer);
        this._guiPreviewContainer.setLayout(new BorderLayout());
        this._guiPlayPauseBtn.setText(I.GUI_PLAY_BTN().getLocalizedMessage());
        this._guiPlayPauseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Gui.this._guiPlayPauseBtnActionPerformed(evt);
            }
        });
        this._guiPreviewContainer.add((Component)this._guiPlayPauseBtn, "South");
        this._guiPreviewPanel.setLayout(new BorderLayout());
        this._guiPreviewContainer.add((Component)this._guiPreviewPanel, "Center");
        this._guiTab.addTab(I.GUI_PLAY_TAB().getLocalizedMessage(), this._guiPreviewContainer);
        this._guiTabContainer.add((Component)this._guiTab, "Center");
        this._guiTab.getAccessibleContext().setAccessibleName("DoStuffTabs");
        this._guiMainSplit.setRightComponent(this._guiTabContainer);
        this.getContentPane().add((Component)this._guiMainSplit, "Center");
        this.pack();
    }

    private void _guiOpenIndexActionPerformed(ActionEvent evt) {
        if (!this.promptSaveIndex()) {
            return;
        }
        BetterFileChooser fc = new BetterFileChooser(this._settings.getIndexDir());
        fc.setAcceptAllFileFilterUsed(true);
        fc.setDialogTitle(I.GUI_LOAD_INDEX_FILE_DIALOG_TITLE().getLocalizedMessage());
        fc.addChoosableFileFilter(GuiFileFilters.INDEX_FILE_FILTER);
        fc.setFileFilter(GuiFileFilters.INDEX_FILE_FILTER);
        int iResult = fc.showOpenDialog(this);
        if (iResult != 0) {
            return;
        }
        this.openIndex(fc.getSelectedFile());
    }

    private void _guiDiscTreeValueChanged(TreeSelectionEvent evt) {
        GuiTree.TreeItem selection = this._guiDiscTree.getTreeTblSelection();
        this._guiTab.setSelectedIndex(0);
        DiscItemSaverBuilderGui gui = null;
        if (selection != null) {
            gui = this.getGuiForDiscItem(selection.getBuilder());
            this._guiTab.setEnabledAt(1, selection.canPlay());
        } else {
            this._guiTab.setEnabledAt(1, false);
        }
        DiscItem.GeneralType type = null;
        if (gui != null && !gui.isAncestorOf(this._guiSavePanel)) {
            this._guiSavePanel.removeAll();
            this._guiSavePanel.add(gui);
            this._guiApplyAll.setEnabled(true);
            type = selection.getType();
        } else if (gui == null) {
            this._guiSavePanel.removeAll();
            this._guiApplyAll.setEnabled(false);
            type = null;
        }
        if (type == null) {
            this._guiApplyAll.setText(I.GUI_APPLY_TO_ALL_BTN(new UnlocalizedMessage("")).getLocalizedMessage());
        } else {
            this._guiApplyAll.setText(I.GUI_APPLY_TO_ALL_BTN(type.getApplyToName()).getLocalizedMessage());
        }
        this._guiSavePanel.revalidate();
        this._guiSavePanel.repaint();
    }

    @CheckForNull
    private DiscItemSaverBuilderGui getGuiForDiscItem(@CheckForNull DiscItemSaverBuilder builder) {
        if (builder == null) {
            return null;
        }
        for (DiscItemSaverBuilderGui gui : this._saverGuis) {
            if (!gui.useSaverBuilder(builder)) continue;
            return gui;
        }
        DiscItemSaverBuilderGui gui = builder.getOptionPane();
        this._saverGuis.add(gui);
        return gui;
    }

    private void _guiPlayPauseBtnActionPerformed(ActionEvent evt) {
        try {
            if (this._currentPlayer != null) {
                if (this._currentPlayer.isPaused()) {
                    this._currentPlayer.unpause();
                } else {
                    this._currentPlayer.pause();
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private void _guiOpenDiscActionPerformed(ActionEvent evt) {
        if (!this.promptSaveIndex()) {
            return;
        }
        BetterFileChooser fc = new BetterFileChooser(this._settings.getImageDir());
        fc.setAcceptAllFileFilterUsed(true);
        fc.setDialogTitle(I.GUI_OPEN_DISC_DIALOG_TITLE().getLocalizedMessage());
        for (FileFilter filter : GuiFileFilters.DISC_OPEN_FILTERS) {
            fc.addChoosableFileFilter(filter);
        }
        fc.setFileFilter(GuiFileFilters.DISC_OPEN_FILTERS[0]);
        int iResult = fc.showOpenDialog(this);
        if (iResult != 0) {
            return;
        }
        this.openDisc(fc.getSelectedFile());
    }

    private void _guiSaveIndexActionPerformed(ActionEvent evt) {
        this.saveIndex();
    }

    private void _guiSelectAllActionPerformed(ActionEvent evt) {
        this._guiDiscTree.selectAllType((GuiTree.Select)((Object)this._guiSelectAllType.getSelectedItem()));
    }

    private void _guiExpandAllActionPerformed(ActionEvent evt) {
        this._guiDiscTree.expandAll();
    }

    private void _guiCollapseAllActionPerformed(ActionEvent evt) {
        this._guiDiscTree.collapseAll();
    }

    private void formWindowClosing(WindowEvent evt) {
        if (!this.promptSaveIndex()) {
            return;
        }
        this._settings.setSavingDir(this._guiDirectory.getText());
        try {
            this._settings.save();
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "Error saving ini file", ex);
        }
        System.exit(0);
    }

    private boolean promptSaveIndex() {
        if (this._guiSaveIndex.isEnabled()) {
            int iRet = JOptionPane.showConfirmDialog(this, I.GUI_SAVE_INDEX_PROMPT(), I.GUI_SAVE_INDEX_PROMPT_TITLE().getLocalizedMessage(), 1);
            if (iRet == 2) {
                return false;
            }
            if (iRet == 0) {
                return this.saveIndex();
            }
        }
        return true;
    }

    private void _guiApplyAllActionPerformed(ActionEvent evt) {
        GuiTree.TreeItem node = this._guiDiscTree.getTreeTblSelection();
        if (node == null) {
            return;
        }
        DiscItemSaverBuilder builder = node.getBuilder();
        if (builder != null) {
            int iCount = this._guiDiscTree.applySettings(builder);
            JOptionPane.showMessageDialog(this, I.GUI_APPLIED_SETTINGS(iCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _guiSaveAllActionPerformed(ActionEvent evt) {
        try {
            ArrayList<DiscItemSaverBuilder> builders;
            String sDir = this._guiDirectory.getText();
            File dir = sDir.length() == 0 ? null : new File(sDir);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                builders = this._guiDiscTree.collectSelected();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (builders.isEmpty()) {
                JOptionPane.showMessageDialog(this, I.GUI_NOTHING_IS_MARKED_FOR_SAVING());
                return;
            }
            SavingGui gui = new SavingGui((Frame)this, builders, this._index.getSourceCd().toString(), dir);
            gui.setVisible(true);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            LOG.log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, ex, I.GUI_BAD_ERROR().getLocalizedMessage(), 0);
        }
    }

    private void _guiChooseDirActionPerformed(ActionEvent evt) {
        JDirectoryChooser chooser = new JDirectoryChooser(this._guiDirectory.getText());
        int choice = chooser.showOpenDialog(this);
        if (choice != 0) {
            return;
        }
        this._guiDirectory.setText(chooser.getSelectedFile().getAbsolutePath());
    }

    private void _guiTabStateChanged(ChangeEvent evt) {
        if (this._guiTab.getSelectedIndex() == 1) {
            GuiTree.TreeItem selection = this._guiDiscTree.getTreeTblSelection();
            if (selection == null) {
                return;
            }
            this._currentPlayer = selection.getPlayer();
            if (this._currentPlayer != null) {
                try {
                    this._currentPlayer.activate();
                }
                catch (PlayerException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    this._currentPlayer = null;
                }
            }
            if (this._currentPlayer != null) {
                if (this._currentPlayer.hasVideo()) {
                    this._guiPreviewPanel.add(this._currentPlayer.getVideoScreen());
                    this._guiPreviewPanel.revalidate();
                }
                this._currentPlayer.addEventListener(this._playerListener);
                this._guiPlayPauseBtn.setText(I.GUI_PLAY_BTN().getLocalizedMessage());
                this._guiPlayPauseBtn.setEnabled(true);
            }
        } else if (this._currentPlayer != null) {
            this._currentPlayer.terminate();
            this._currentPlayer = null;
            this._guiPreviewPanel.removeAll();
            this._guiPreviewPanel.validate();
            this._guiPreviewPanel.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formWindowOpened(WindowEvent evt) {
        block9: {
            if (this._sCommandLineFile == null) {
                return;
            }
            File f = new File(this._sCommandLineFile);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                try {
                    byte[] abBuffer = Gui.readAsMuchAsPossible(fis, "[jPSXdec v1.05 (beta)]".length() * 2);
                    fis.close();
                    fis = null;
                    String s = Misc.asciiToString(abBuffer);
                    if (s.contains("jPSXdec")) {
                        this.openIndex(f);
                        break block9;
                    }
                    this.openDisc(f);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, this._sCommandLineFile, ex);
                    JOptionPane.showMessageDialog(this, I.IO_READING_FROM_FILE_ERROR_NAME(this._sCommandLineFile).getLocalizedMessage(), I.IO_READING_FROM_FILE_ERROR().getLocalizedMessage(), 0);
                }
            }
            catch (FileNotFoundException ex) {
                LOG.log(Level.WARNING, this._sCommandLineFile, ex);
                JOptionPane.showMessageDialog(this, I.IO_OPENING_FILE_NOT_FOUND_NAME(this._sCommandLineFile).getLocalizedMessage(), I.IO_OPENING_FILE_ERROR().getLocalizedMessage(), 0);
            }
            finally {
                IO.closeSilently(fis, LOG);
            }
        }
    }

    @Nonnull
    private static byte[] readAsMuchAsPossible(@Nonnull InputStream is, int iCount) throws IOException {
        byte[] ab = new byte[iCount];
        int iSize = IO.readByteArrayMax(is, ab, 0, ab.length);
        if (iSize < ab.length) {
            return Arrays.copyOfRange(ab, 0, iSize);
        }
        return ab;
    }

    public static void main(String[] args) {
        Main.loadDefaultLogger();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Gui().setVisible(true);
            }
        });
    }

    private class IndexMenu
    extends JPopupMenu
    implements PopupMenuListener,
    ActionListener {
        private final JMenuItem EMPTY_MENU_ITEM = new JMenuItem("Empty");

        public IndexMenu() {
            this.add(this.EMPTY_MENU_ITEM);
            this.addPopupMenuListener(this);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.removeAll();
            for (String sName : Gui.this._settings.getPreviousIndexes()) {
                JMenuItem item = new JMenuItem(sName);
                item.addActionListener(this);
                this.add(item);
            }
        }

        @Override
        public void actionPerformed(@Nonnull ActionEvent e) {
            File f = new File(e.getActionCommand());
            if (f.exists() && !Gui.this.promptSaveIndex()) {
                return;
            }
            Gui.this.openIndex(f);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private class DiscMenu
    extends JPopupMenu
    implements PopupMenuListener,
    ActionListener {
        private final JMenuItem EMPTY_MENU_ITEM = new JMenuItem("Empty");

        public DiscMenu() {
            this.add(this.EMPTY_MENU_ITEM);
            this.addPopupMenuListener(this);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.removeAll();
            for (String sName : Gui.this._settings.getPreviousImages()) {
                JMenuItem item = new JMenuItem(sName);
                item.addActionListener(this);
                this.add(item);
            }
        }

        @Override
        public void actionPerformed(@Nonnull ActionEvent e) {
            File f = new File(e.getActionCommand());
            if (f.exists() && !Gui.this.promptSaveIndex()) {
                return;
            }
            Gui.this.openDisc(f);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

