/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.gui;

import java.io.File;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import jpsxdec.i18n.I;
import jpsxdec.i18n.ILocalizedMessage;

public class BetterFileChooser
extends JFileChooser {
    private final transient FileFilter ALL_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return BetterFileChooser.super.getAcceptAllFileFilter().accept(f);
        }

        @Override
        public String getDescription() {
            return BetterFileChooser.super.getAcceptAllFileFilter().getDescription();
        }

        public String toString() {
            return BetterFileChooser.super.getAcceptAllFileFilter().getDescription();
        }
    };

    public BetterFileChooser() {
    }

    public BetterFileChooser(@Nonnull String currentDirectoryPath, @Nonnull FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
    }

    public BetterFileChooser(@Nonnull File currentDirectory, @Nonnull FileSystemView fsv) {
        super(currentDirectory, fsv);
    }

    public BetterFileChooser(@Nonnull FileSystemView fsv) {
        super(fsv);
    }

    public BetterFileChooser(@Nonnull File currentDirectory) {
        super(currentDirectory);
    }

    public BetterFileChooser(@CheckForNull String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    @Override
    @Nonnull
    public FileFilter getAcceptAllFileFilter() {
        return this.ALL_FILE_FILTER;
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    @Override
    public void approveSelection() {
        if (this.getDialogType() == 1) {
            String sTitle;
            ILocalizedMessage msg;
            int iOption;
            File f = this.getSelectedFile();
            FileFilter filter = this.getFileFilter();
            if (filter instanceof SaveFileFilter) {
                SaveFileFilter saveFilter = (SaveFileFilter)filter;
                if (!f.getName().toLowerCase().endsWith(saveFilter.getExtension().toLowerCase())) {
                    f = new File(f.getParentFile(), f.getName() + saveFilter.getExtension());
                    this.setSelectedFile(f);
                }
            }
            if (f.exists() && (iOption = JOptionPane.showConfirmDialog(this, msg = I.GUI_FILE_EXISTS_REPLACE(f.getName()), sTitle = this.getDialogTitle(), 0, 2)) != 0) {
                return;
            }
        }
        super.approveSelection();
    }

    public static abstract class SaveFileFilter
    extends FileFilter {
        @Nonnull
        public abstract String getExtension();
    }
}

