/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.formats;

import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;
import jpsxdec.formats.RGB;
import jpsxdec.formats.Rec601YCbCr;

public class YCbCrImage {
    private int _iLumaWidth;
    private int _iLumaHeight;
    private int _iChromaWidth;
    private int _iChromaHeight;
    @Nonnull
    private final byte[] _abY;
    @Nonnull
    private final byte[] _abCb;
    @Nonnull
    private final byte[] _abCr;

    public YCbCrImage(int iWidth, int iHeight) {
        if (iWidth < 2 || iHeight < 2 || iWidth % 2 != 0 || iHeight % 2 != 0) {
            throw new IllegalArgumentException("Dimensions must be even.");
        }
        this._iLumaWidth = iWidth;
        this._iLumaHeight = iHeight;
        this._iChromaWidth = iWidth / 2;
        this._iChromaHeight = iHeight / 2;
        this._abY = new byte[this._iLumaWidth * this._iLumaHeight];
        this._abCb = new byte[this._iChromaWidth * this._iChromaHeight];
        this._abCr = new byte[this._abCb.length];
    }

    public YCbCrImage(@Nonnull BufferedImage rgb) {
        this(rgb.getWidth(), rgb.getHeight());
        for (int x = 0; x < this._iLumaWidth; x += 2) {
            for (int y = 0; y < this._iLumaHeight; y += 2) {
                Rec601YCbCr ycc = new Rec601YCbCr(new RGB(rgb.getRGB(x, y)), new RGB(rgb.getRGB(x + 1, y)), new RGB(rgb.getRGB(x, y + 1)), new RGB(rgb.getRGB(x + 1, y + 1)));
                this._abY[x + y * this._iLumaWidth] = YCbCrImage.rc(ycc.y1);
                this._abY[x + 1 + y * this._iLumaWidth] = YCbCrImage.rc(ycc.y2);
                this._abY[x + (y + 1) * this._iLumaWidth] = YCbCrImage.rc(ycc.y3);
                this._abY[x + 1 + (y + 1) * this._iLumaWidth] = YCbCrImage.rc(ycc.y4);
                this._abCb[x / 2 + y / 2 * this._iChromaWidth] = YCbCrImage.rc(ycc.cb);
                this._abCr[x / 2 + y / 2 * this._iChromaWidth] = YCbCrImage.rc(ycc.cr);
            }
        }
    }

    private static byte rc(double dbl) {
        if (dbl < 0.0) {
            return 0;
        }
        if (dbl > 255.0) {
            return -1;
        }
        return (byte)Math.round(dbl);
    }

    public int getWidth() {
        return this._iLumaWidth;
    }

    public int getHeight() {
        return this._iLumaHeight;
    }

    @Nonnull
    public byte[] getY() {
        return this._abY;
    }

    @Nonnull
    public byte[] getCb() {
        return this._abCb;
    }

    @Nonnull
    public byte[] getCr() {
        return this._abCr;
    }

    public void setY(int iLumaX, int iLumaY, byte bY) {
        this._abY[iLumaX + iLumaY * this._iLumaWidth] = bY;
    }

    public void setCb(int iChromaX, int iChromaY, byte bCb) {
        this._abCb[iChromaX + iChromaY * this._iChromaWidth] = bCb;
    }

    public void setCr(int iChromaX, int iChromaY, byte bCr) {
        this._abCr[iChromaX + iChromaY * this._iChromaWidth] = bCr;
    }

    public void setY(int iDestX, int iDestY, int iSrcOfs, int iSrcWidth, int iCopyWidth, int iCopyHeight, @Nonnull byte[] abY) {
        this.set(this._abY, iDestX + iDestY * this._iLumaWidth, this._iLumaHeight, abY, iSrcOfs, iSrcWidth, iCopyWidth, iCopyHeight);
    }

    public void setCb(int iDestX, int iDestY, int iSrcOfs, int iSrcWidth, int iCopyWidth, int iCopyHeight, @Nonnull byte[] abCb) {
        this.set(this._abCb, iDestX + iDestY * this._iChromaWidth, this._iChromaWidth, abCb, iSrcOfs, iSrcWidth, iCopyWidth, iCopyHeight);
    }

    public void setCr(int iDestX, int iDestY, int iSrcOfs, int iSrcWidth, int iCopyWidth, int iCopyHeight, @Nonnull byte[] abCr) {
        this.set(this._abCr, iDestX + iDestY * this._iChromaWidth, this._iChromaWidth, abCr, iSrcOfs, iSrcWidth, iCopyWidth, iCopyHeight);
    }

    private void set(@Nonnull byte[] abDest, int iDestOfs, int iDestWidth, @Nonnull byte[] abSrc, int iSrcOfs, int iSrcWidth, int iCopyWidth, int iCopyHeight) {
        int iLine = 0;
        while (iLine < iCopyHeight) {
            System.arraycopy(abSrc, iSrcOfs, abDest, iDestOfs, iCopyWidth);
            ++iLine;
            iDestOfs += iDestWidth;
            iSrcOfs += iSrcWidth;
        }
    }
}

