/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.formats;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.annotation.Nonnull;

public class RgbIntImage {
    private final int _iWidth;
    private final int _iHeight;
    @Nonnull
    private int[] _aiData;

    public RgbIntImage(@Nonnull BufferedImage bi) {
        this(bi.getWidth(), bi.getHeight());
        this._aiData = new int[this._iWidth * this._iHeight];
        bi.getRGB(0, 0, this._iWidth, this._iHeight, this._aiData, 0, this._iWidth);
    }

    public RgbIntImage(int iWidth, int iHeight, @Nonnull int[] aiData) {
        this._iWidth = iWidth;
        this._iHeight = iHeight;
        this._aiData = aiData;
    }

    public RgbIntImage(int iWidth, int iHeight) {
        this(iWidth, iHeight, new int[iWidth * iHeight]);
    }

    public RgbIntImage(int iWidth, int iHeight, int iBufferSize) {
        this(iWidth, iHeight, new int[iBufferSize]);
    }

    public int getWidth() {
        return this._iWidth;
    }

    public int getHeight() {
        return this._iHeight;
    }

    @Nonnull
    public int[] getData() {
        return this._aiData;
    }

    public int get(int x, int y) {
        return this._aiData[x + y * this._iWidth];
    }

    public void set(int x, int y, int i) {
        this._aiData[x + y * this._iWidth] = i;
    }

    @Nonnull
    public BufferedImage toBufferedImage() {
        BufferedImage bi = new BufferedImage(this._iWidth, this._iHeight, 1);
        WritableRaster raster = bi.getRaster();
        raster.setDataElements(0, 0, this._iWidth, this._iHeight, this._aiData);
        return bi;
    }
}

