/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.formats;

import javax.annotation.Nonnull;
import jpsxdec.formats.RGB;

public class Rec601YCbCr {
    public double y1;
    public double y2;
    public double y3;
    public double y4;
    public double cb;
    public double cr;

    public Rec601YCbCr() {
    }

    public Rec601YCbCr(@Nonnull RGB rgb1, @Nonnull RGB rgb2, @Nonnull RGB rgb3, @Nonnull RGB rgb4) {
        this.fromRgb(rgb1, rgb2, rgb3, rgb4);
    }

    public void fromRgb(@Nonnull RGB rgb1, @Nonnull RGB rgb2, @Nonnull RGB rgb3, @Nonnull RGB rgb4) {
        this.cr = 0.0;
        this.cb = 0.0;
        this.y1 = this.oneRgb(rgb1);
        this.y2 = this.oneRgb(rgb2);
        this.y3 = this.oneRgb(rgb3);
        this.y4 = this.oneRgb(rgb4);
        this.cb /= 4.0;
        this.cr /= 4.0;
    }

    private double oneRgb(@Nonnull RGB rgb) {
        int r = rgb.getR();
        int g = rgb.getG();
        int b = rgb.getB();
        double y = 0.257 * (double)r + 0.504 * (double)g + 0.098 * (double)b + 16.0;
        this.cb += -0.148 * (double)r + -0.291 * (double)g + 0.439 * (double)b + 128.0;
        this.cr += 0.439 * (double)r + -0.368 * (double)g + -0.071 * (double)b + 128.0;
        return y;
    }

    public static void toRgb(double y, double cb, double cr, @Nonnull RGB rgb) {
        double y_16 = y - 16.0;
        double cb_128 = cb - 128.0;
        double cr_128 = cr - 128.0;
        rgb.setR(y_16 * 1.164 + 1.596 * cr_128);
        rgb.setG(y_16 * 1.164 + -0.391 * cb_128 + -0.813 * cr_128);
        rgb.setB(y_16 * 1.164 + 2.018 * cb_128);
    }

    public void toRgb(@Nonnull RGB rgb1, @Nonnull RGB rgb2, @Nonnull RGB rgb3, @Nonnull RGB rgb4) {
        double cb_128 = this.cb - 128.0;
        double cr_128 = this.cr - 128.0;
        double dblChromRed = 1.596 * cr_128;
        double dblChromGreen = -0.391 * cb_128 + -0.813 * cr_128;
        double dblChromBlue = 2.018 * cb_128;
        double dblYshift = (this.y1 - 16.0) * 1.164;
        rgb1.setR(dblYshift + dblChromRed);
        rgb1.setG(dblYshift + dblChromGreen);
        rgb1.setB(dblYshift + dblChromBlue);
        dblYshift = (this.y2 - 16.0) * 1.164;
        rgb2.setR(dblYshift + dblChromRed);
        rgb2.setG(dblYshift + dblChromGreen);
        rgb2.setB(dblYshift + dblChromBlue);
        dblYshift = (this.y3 - 16.0) * 1.164;
        rgb3.setR(dblYshift + dblChromRed);
        rgb3.setG(dblYshift + dblChromGreen);
        rgb3.setB(dblYshift + dblChromBlue);
        dblYshift = (this.y4 - 16.0) * 1.164;
        rgb4.setR(dblYshift + dblChromRed);
        rgb4.setG(dblYshift + dblChromGreen);
        rgb4.setB(dblYshift + dblChromBlue);
    }

    public String toString() {
        return String.format("([%f, %f, %f, %f] %f, %f)", this.y1, this.y2, this.y3, this.y4, this.cb, this.cr);
    }
}

